/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.walkingpath.footstep;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class SkeletonPath {
    private ArrayList<Line2D> pathSegments = new ArrayList();
    private Point2D finalPoint;

    public SkeletonPath() {
    }

    public SkeletonPath(double[] skeletonPathX, double[] skeletonPathY) {
        for (int i = 0; i < skeletonPathX.length - 1; ++i) {
            Line2D.Double aSegment = new Line2D.Double(skeletonPathX[i], skeletonPathY[i], skeletonPathX[i + 1], skeletonPathY[i + 1]);
            this.pathSegments.add(aSegment);
        }
    }

    public SkeletonPath(double shiftY, SkeletonPath refSegments) {
        for (int i = 0; i < refSegments.get().size(); ++i) {
            Line2D aLine = this.getShiftedSegment(shiftY, refSegments.get().get(i));
            this.pathSegments.add(aLine);
        }
    }

    public ArrayList<Line2D> get() {
        return this.pathSegments;
    }

    public Line2D getSegment(int index) {
        return this.pathSegments.get(index);
    }

    private Line2D getShiftedSegment(double delY, Line2D refLine) {
        double diffX = refLine.getX2() - refLine.getX1();
        double diffY = refLine.getY2() - refLine.getY1();
        double normDiff = Math.sqrt(diffX * diffX + diffY * diffY);
        double shiftX = -diffY / normDiff * delY;
        double shiftY = diffX / normDiff * delY;
        Line2D.Double retLine = new Line2D.Double(refLine.getX1() + shiftX, refLine.getY1() + shiftY, refLine.getX2() + shiftX, refLine.getY2() + shiftY);
        return retLine;
    }

    public int getIndexOfClosestSegment(Point2D aPoint) {
        double minMatric;
        int indexOfClosestSegment = 0;
        double curMatric = minMatric = Double.MAX_VALUE;
        for (int i = 0; i < this.pathSegments.size(); ++i) {
            curMatric = this.pathSegments.get(i).ptSegDist(aPoint);
            if (!(curMatric < minMatric)) continue;
            minMatric = curMatric;
            indexOfClosestSegment = i;
        }
        return indexOfClosestSegment;
    }

    private Point2D getLocationOfClosestPointOnSegment(int indexOfSegment, Point2D aPoint) {
        Point2D ret = new Point2D.Double();
        Line2D aSegment = this.pathSegments.get(indexOfSegment);
        double paramA = aSegment.getY2() - aSegment.getY1();
        double paramB = -aSegment.getX2() + aSegment.getX1();
        double paramC = -aSegment.getX1() * aSegment.getY2() + aSegment.getX2() * aSegment.getY1();
        ((Point2D)ret).setLocation((paramB * (paramB * aPoint.getX() - paramA * aPoint.getY()) - paramA * paramC) / (paramA * paramA + paramB * paramB), (paramA * (-paramB * aPoint.getX() + paramA * aPoint.getY()) - paramB * paramC) / (paramA * paramA + paramB * paramB));
        if (aSegment.ptSegDist(ret) > 1.0E-4) {
            ret = aSegment.getP1().distance(ret) > aSegment.getP2().distance(ret) ? aSegment.getP2() : aSegment.getP1();
        }
        return ret;
    }

    public Point2D getLocationOfClosestPointOnSegment(Point2D aPoint) {
        int indexOfSegment = this.getIndexOfClosestSegment(aPoint);
        return this.getLocationOfClosestPointOnSegment(indexOfSegment, aPoint);
    }

    public double getYawAngleOfClosestPointOnSegment(Point2D aPoint) {
        int indexOfSegment = this.getIndexOfClosestSegment(aPoint);
        return this.getYawAngleOfSegment(indexOfSegment);
    }

    public double getYawAngleOfSegment(int indexOfSegment) {
        double diffX = this.pathSegments.get(indexOfSegment).getX2() - this.pathSegments.get(indexOfSegment).getX1();
        double diffY = this.pathSegments.get(indexOfSegment).getY2() - this.pathSegments.get(indexOfSegment).getY1();
        double norm = Math.sqrt(diffX * diffX + diffY * diffY);
        double alpha = diffX >= 0.0 ? Math.asin(diffY / norm) : (diffY >= 0.0 ? -Math.asin(diffY / norm) + Math.PI : -Math.asin(diffY / norm) - Math.PI);
        return alpha;
    }

    public Point2D getFinalPoint() {
        this.finalPoint = new Point2D.Double();
        this.finalPoint.setLocation(this.pathSegments.get(this.pathSegments.size() - 1).getP2());
        return this.finalPoint;
    }
}

