/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCylinder;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class TreeStateVisualizer {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private double currentNormalizedTime;
    private double treeReachingTime = 0.0;
    private boolean currentCTTaskNodeValidity;
    private static Point3D pointCurrentTimeLineOrigin = new Point3D(0.0, 1.0, 1.0);
    private Point3D pointCurrentTime = new Point3D(0.0, 0.0, 1.0);
    private Point3D pointTreeReachingTime = new Point3D(0.0, 0.0, 1.0);
    private final YoFramePoint3D yoFramePointCurrentTimeLineOrigin;
    private final YoFramePoint3D yoFramePointCurrentTime;
    private final YoFramePoint3D yoFramePointCurrentTimeInvalid;
    private final YoFramePoint3D yoFramePointTreeReachingTime;
    private final YoGraphicCylinder currentTimeLineViz;
    private final YoGraphicPosition currentTimeViz;
    private final YoGraphicPosition currentTimeInvalidViz;
    private final YoGraphicPosition treeReachingTimeViz;

    public TreeStateVisualizer(String name, String graphicsListName, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        YoGraphicsList yoGraphicsList = new YoGraphicsList("TreeStateVisualizerGraphicsList");
        this.yoFramePointCurrentTimeLineOrigin = new YoFramePoint3D(name + "currentTimeOrigin", worldFrame, registry);
        this.yoFramePointCurrentTimeLineOrigin.set((Tuple3DReadOnly)pointCurrentTimeLineOrigin);
        YoFrameVector3D currentTimeLineVector = new YoFrameVector3D("currentTimeLineVector", worldFrame, registry);
        currentTimeLineVector.set((Tuple3DReadOnly)new Vector3D(0.0, 1.0, 0.0));
        this.currentTimeLineViz = new YoGraphicCylinder("currentTimeLine", this.yoFramePointCurrentTimeLineOrigin, currentTimeLineVector, YoAppearance.LightBlue(), 0.03);
        yoGraphicsList.add((YoGraphic)this.currentTimeLineViz);
        this.yoFramePointCurrentTime = new YoFramePoint3D(name + "currentTime", worldFrame, registry);
        this.pointCurrentTime.set(pointCurrentTimeLineOrigin);
        this.yoFramePointCurrentTime.set((Tuple3DReadOnly)this.pointCurrentTime);
        this.yoFramePointCurrentTimeInvalid = new YoFramePoint3D(name + "currentTimeInvalid", worldFrame, registry);
        this.pointCurrentTime.set(pointCurrentTimeLineOrigin);
        this.yoFramePointCurrentTimeInvalid.set((Tuple3DReadOnly)this.pointCurrentTime);
        this.currentTimeViz = new YoGraphicPosition("currentTime", this.yoFramePointCurrentTime, 0.06, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL);
        yoGraphicsList.add((YoGraphic)this.currentTimeViz);
        this.currentTimeInvalidViz = new YoGraphicPosition("currentTimeInvalid", this.yoFramePointCurrentTimeInvalid, 0.06, YoAppearance.Red(), YoGraphicPosition.GraphicType.BALL);
        yoGraphicsList.add((YoGraphic)this.currentTimeInvalidViz);
        this.yoFramePointTreeReachingTime = new YoFramePoint3D(name + "treeReachingTime", worldFrame, registry);
        this.pointCurrentTime.set(pointCurrentTimeLineOrigin);
        this.yoFramePointTreeReachingTime.set((Tuple3DReadOnly)this.pointCurrentTime);
        this.treeReachingTimeViz = new YoGraphicPosition("treeReachingTime", this.yoFramePointTreeReachingTime, 0.05, YoAppearance.Black(), YoGraphicPosition.GraphicType.BALL);
        yoGraphicsList.add((YoGraphic)this.treeReachingTimeViz);
        yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
    }

    public void setCurrentNormalizedTime(double value) {
        this.currentNormalizedTime = value;
        if (this.currentNormalizedTime > this.treeReachingTime) {
            this.treeReachingTime = value;
        }
    }

    public void setCurrentCTTaskNodeValidity(boolean value) {
        this.currentCTTaskNodeValidity = value;
    }

    public void updateVisualizer() {
        if (this.currentCTTaskNodeValidity) {
            this.pointCurrentTime.set(pointCurrentTimeLineOrigin);
            this.pointCurrentTime.add((Tuple3DReadOnly)new Vector3D(0.0, this.currentNormalizedTime, 0.0));
            this.yoFramePointCurrentTime.set((Tuple3DReadOnly)this.pointCurrentTime);
            this.pointCurrentTime.setToNaN();
            this.yoFramePointCurrentTimeInvalid.set((Tuple3DReadOnly)this.pointCurrentTime);
        } else {
            this.pointCurrentTime.set(pointCurrentTimeLineOrigin);
            this.pointCurrentTime.add((Tuple3DReadOnly)new Vector3D(0.0, this.currentNormalizedTime, 0.0));
            this.yoFramePointCurrentTimeInvalid.set((Tuple3DReadOnly)this.pointCurrentTime);
            this.pointCurrentTime.setToNaN();
            this.yoFramePointCurrentTime.set((Tuple3DReadOnly)this.pointCurrentTime);
        }
        this.pointTreeReachingTime.set(pointCurrentTimeLineOrigin);
        this.pointTreeReachingTime.add((Tuple3DReadOnly)new Vector3D(0.0, this.treeReachingTime, 0.0));
        this.yoFramePointTreeReachingTime.set((Tuple3DReadOnly)this.pointTreeReachingTime);
        this.currentTimeInvalidViz.update();
        this.treeReachingTimeViz.update();
        this.currentTimeLineViz.update();
        this.currentTimeViz.update();
    }
}

