/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.rrt.RRTNode;
import us.ihmc.manipulation.planning.rrt.RRTNode2D;
import us.ihmc.manipulation.planning.rrt.RRTPlanner;
import us.ihmc.manipulation.planning.rrt.RRTPlanner2D;

public class RRTTestProject
extends JPanel {
    double xUpper;
    double xLower;
    double yUpper;
    double yLower;
    double scale;
    int sizeU;
    int sizeV;
    double[] allPoints;
    int numOfPoints;
    double[] pathPoints;
    double[] boxInfo = new double[4];
    RRTPlanner info;

    public RRTTestProject(int scaleF, double[] pointInfo, RRTPlanner info) {
        this.scale = scaleF;
        this.xUpper = info.getRRTTree().upperBoundNode.getNodeData(0);
        this.xLower = info.getRRTTree().lowerBoundNode.getNodeData(0);
        this.yUpper = info.getRRTTree().upperBoundNode.getNodeData(1);
        this.yLower = info.getRRTTree().lowerBoundNode.getNodeData(1);
        this.sizeU = (int)Math.round((-this.yLower + this.yUpper) * this.scale);
        this.sizeV = (int)Math.round((-this.xLower + this.xUpper) * this.scale);
        this.allPoints = pointInfo;
        this.numOfPoints = this.allPoints.length / 4;
        this.boxInfo[0] = RRTNode2D.boxCenterX;
        this.boxInfo[1] = RRTNode2D.boxCenterY;
        this.boxInfo[2] = RRTNode2D.boxSizeX;
        this.boxInfo[3] = RRTNode2D.boxSizeY;
        this.info = info;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.red);
        g.drawLine(this.y2u(0.0), this.x2v(0.0), this.y2u(0.5), this.x2v(0.0));
        g.setColor(Color.green);
        g.drawLine(this.y2u(0.0), this.x2v(0.0), this.y2u(0.0), this.x2v(0.5));
        g.setColor(Color.GRAY);
        for (int i = 0; i < this.numOfPoints; ++i) {
            this.branchFill(g, this.allPoints[i * 4 + 0], this.allPoints[i * 4 + 1], this.allPoints[i * 4 + 2], this.allPoints[i * 4 + 3], 4);
        }
        this.point(g, 0.0, 0.0, 4);
        g.setColor(Color.MAGENTA);
        ArrayList<RRTNode> infoPathNode = this.info.getRRTTree().pathNode;
        for (int i = 1; i < infoPathNode.size(); ++i) {
            this.branch(g, infoPathNode.get(i - 1).getNodeData(0), infoPathNode.get(i - 1).getNodeData(1), infoPathNode.get(i).getNodeData(0), infoPathNode.get(i).getNodeData(1), 6);
        }
        g.setColor(Color.blue);
        this.point(g, this.info.getGoalNode().getNodeData(0), this.info.getGoalNode().getNodeData(1), 4);
        this.branch(g, this.boxInfo[0] + this.boxInfo[2] * 0.5, this.boxInfo[1] + this.boxInfo[3] * 0.5, this.boxInfo[0] + this.boxInfo[2] * 0.5, this.boxInfo[1] - this.boxInfo[3] * 0.5, 2);
        this.branch(g, this.boxInfo[0] + this.boxInfo[2] * 0.5, this.boxInfo[1] + this.boxInfo[3] * 0.5, this.boxInfo[0] - this.boxInfo[2] * 0.5, this.boxInfo[1] + this.boxInfo[3] * 0.5, 2);
        this.branch(g, this.boxInfo[0] - this.boxInfo[2] * 0.5, this.boxInfo[1] - this.boxInfo[3] * 0.5, this.boxInfo[0] - this.boxInfo[2] * 0.5, this.boxInfo[1] + this.boxInfo[3] * 0.5, 2);
        this.branch(g, this.boxInfo[0] - this.boxInfo[2] * 0.5, this.boxInfo[1] - this.boxInfo[3] * 0.5, this.boxInfo[0] + this.boxInfo[2] * 0.5, this.boxInfo[1] - this.boxInfo[3] * 0.5, 2);
        g.setColor(Color.green);
        ArrayList<RRTNode> piecewisePath = this.info.getPiecewisePath().getPiecewisePath();
        for (int i = 0; i < piecewisePath.size() - 1; ++i) {
            double p1x = piecewisePath.get(i).getNodeData(0);
            double p1y = piecewisePath.get(i).getNodeData(1);
            double p2x = piecewisePath.get(i + 1).getNodeData(0);
            double p2y = piecewisePath.get(i + 1).getNodeData(1);
            this.branch(g, p1x, p1y, p2x, p2y, 4);
        }
        g.setColor(Color.black);
        ArrayList<RRTNode> optimalPath = this.info.getOptimalPath();
        for (int i = 0; i < optimalPath.size() - 1; ++i) {
            double p1x = optimalPath.get(i).getNodeData(0);
            double p1y = optimalPath.get(i).getNodeData(1);
            double p2x = optimalPath.get(i + 1).getNodeData(0);
            double p2y = optimalPath.get(i + 1).getNodeData(1);
            this.branchFill(g, p1x, p1y, p2x, p2y, 6);
        }
    }

    public int x2v(double px) {
        return (int)Math.round((-px + this.xUpper) * this.scale);
    }

    public int y2u(double py) {
        return (int)Math.round((-py + this.yUpper) * this.scale);
    }

    public void branch(Graphics g, double p1x, double p1y, double p2x, double p2y, int size) {
        this.point(g, p1x, p1y, size);
        this.point(g, p2x, p2y, size);
        g.drawLine(this.y2u(p1y), this.x2v(p1x), this.y2u(p2y), this.x2v(p2x));
    }

    public void branchFill(Graphics g, double p1x, double p1y, double p2x, double p2y, int size) {
        this.pointFill(g, p1x, p1y, size);
        this.pointFill(g, p2x, p2y, size);
        g.drawLine(this.y2u(p1y), this.x2v(p1x), this.y2u(p2y), this.x2v(p2x));
    }

    public void point(Graphics g, double px, double py, int size) {
        int diameter = size;
        g.drawOval(this.y2u(py) - diameter / 2, this.x2v(px) - diameter / 2, diameter, diameter);
    }

    public void pointFill(Graphics g, double px, double py, int size) {
        int diameter = size;
        g.fillOval(this.y2u(py) - diameter / 2, this.x2v(px) - diameter / 2, diameter, diameter);
    }

    public static void main(String[] args) {
        PrintTools.info((String)"Start!!! ");
        RRTNode2D startNode = new RRTNode2D(0.0, 0.0);
        RRTNode2D goalNode = new RRTNode2D(3.0, 2.0);
        RRTPlanner2D rrtPlanner = new RRTPlanner2D(startNode, goalNode, 0.6);
        RRTNode2D upperBoundNode = new RRTNode2D(5.0, 4.0);
        RRTNode2D lowerBoundNode = new RRTNode2D(-5.0, -4.0);
        rrtPlanner.getRRTTree().setUpperBound(upperBoundNode);
        rrtPlanner.getRRTTree().setLowerBound(lowerBoundNode);
        int maxNumberOfExpanding = 1500;
        double[] rrtPointInfo = new double[maxNumberOfExpanding * 4];
        double[] rrtNewPointInfo = new double[4];
        for (int i = 0; i < maxNumberOfExpanding; ++i) {
            int j;
            for (j = 0; j < 4; ++j) {
                rrtPointInfo[i * 4 + j] = rrtNewPointInfo[j];
            }
            if (!rrtPlanner.expandTreeGoal(rrtNewPointInfo)) continue;
            ++i;
            for (j = 0; j < 4; ++j) {
                rrtPointInfo[i * 4 + j] = rrtNewPointInfo[j];
            }
            ++i;
            for (j = 0; j < 2; ++j) {
                rrtPointInfo[i * 4 + j] = rrtPointInfo[(i - 1) * 4 + j];
                rrtPointInfo[i * 4 + 2 + j] = rrtPlanner.getGoalNode().getNodeData(j);
            }
            break;
        }
        rrtPlanner.updateOptimalPath(101, 100);
        JFrame frame = new JFrame("RRTTest");
        RRTTestProject drawPanel = new RRTTestProject(100, rrtPointInfo, rrtPlanner);
        Dimension dim = new Dimension(drawPanel.sizeU, drawPanel.sizeV);
        frame.setPreferredSize(dim);
        frame.setLocation(200, 100);
        frame.add(drawPanel);
        frame.pack();
        frame.setVisible(true);
    }
}

