/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.exploringSpatial;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class TrajectoryLibraryForDRC {
    public static Pose3D computeOpeningDoorTrajectory(double time, double trajectoryTime, double openingRadius, double openingAngle, boolean openingDirectionCW, Pose3D knobGraspingPose, double twistTime, double twistRadius, double twistAngle, boolean twistDirectionCW) {
        RigidBodyTransform handControl = new RigidBodyTransform((Orientation3DReadOnly)knobGraspingPose.getOrientation(), (Tuple3DReadOnly)knobGraspingPose.getPosition());
        double distanceBetweenKnobAndDoor = 0.0;
        Vector3D zVectorOfKnob = new Vector3D();
        handControl.getRotation().getColumn(2, (Tuple3DBasics)zVectorOfKnob);
        Vector3D translationFromKnobToDoorPlane = new Vector3D();
        if (zVectorOfKnob.getY() > 0.0) {
            translationFromKnobToDoorPlane.setX(zVectorOfKnob.getY());
            translationFromKnobToDoorPlane.setY(-zVectorOfKnob.getX());
        } else {
            translationFromKnobToDoorPlane.setX(-zVectorOfKnob.getY());
            translationFromKnobToDoorPlane.setY(zVectorOfKnob.getX());
        }
        Vector3D twistAxis = new Vector3D((Tuple3DReadOnly)translationFromKnobToDoorPlane);
        translationFromKnobToDoorPlane.scale(distanceBetweenKnobAndDoor);
        double phase = time / twistTime;
        if (phase > 1.0) {
            phase = 1.0;
        }
        handControl.appendTranslation(0.0, 0.0, twistRadius);
        twistAxis.normalize();
        AxisAngle twistAxisAngle = new AxisAngle((Vector3DReadOnly)twistAxis, twistDirectionCW ? twistAngle * phase : -twistAngle * phase);
        handControl.multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)twistAxisAngle, (Tuple3DReadOnly)new Point3D()));
        handControl.appendTranslation(0.0, 0.0, -twistRadius);
        if (time > twistTime) {
            phase = (time - twistTime) / (trajectoryTime - twistTime);
            RigidBodyTransform knobCenterControl = new RigidBodyTransform((Orientation3DReadOnly)knobGraspingPose.getOrientation(), (Tuple3DReadOnly)knobGraspingPose.getPosition());
            RotationMatrix knobCenterOrientationControl = new RotationMatrix((Orientation3DReadOnly)knobGraspingPose.getOrientation());
            knobCenterControl.prependTranslation((Tuple3DReadOnly)translationFromKnobToDoorPlane);
            knobCenterControl.appendTranslation(0.0, 0.0, twistRadius - openingRadius);
            knobCenterOrientationControl.prependYawRotation(openingDirectionCW ? -openingAngle * phase : openingAngle * phase);
            knobCenterControl.getRotation().set((RotationMatrixReadOnly)knobCenterOrientationControl);
            knobCenterControl.appendTranslation(0.0, 0.0, -twistRadius + openingRadius);
            translationFromKnobToDoorPlane.negate();
            knobCenterControl.prependTranslation((Tuple3DReadOnly)translationFromKnobToDoorPlane);
            handControl = new RigidBodyTransform((RigidBodyTransformReadOnly)knobCenterControl);
            handControl.appendTranslation(0.0, 0.0, twistRadius);
            twistAxis.normalize();
            AxisAngle twistAxisAngle2 = new AxisAngle((Vector3DReadOnly)twistAxis, twistDirectionCW ? twistAngle * 1.0 : -twistAngle * 1.0);
            handControl.multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)twistAxisAngle2, (Tuple3DReadOnly)new Point3D()));
            handControl.appendTranslation(0.0, 0.0, -twistRadius);
        }
        return new Pose3D((RigidBodyTransformReadOnly)handControl);
    }

    public static Pose3D computeCuttingWallTrajectory(double time, double trajectoryTime, double cuttingRadius, boolean cuttingDirectionCW, Point3D cuttingCenterPosition, Vector3D wallNormalVector) {
        Vector3D xAxisRotationMatrix = new Vector3D(0.0, 0.0, 1.0);
        Vector3D yAxisRotationMatrix = new Vector3D();
        Vector3D zAxisRotationMatrix = new Vector3D((Tuple3DReadOnly)wallNormalVector);
        zAxisRotationMatrix.normalize();
        yAxisRotationMatrix.cross((Tuple3DReadOnly)zAxisRotationMatrix, (Tuple3DReadOnly)xAxisRotationMatrix);
        RotationMatrix cuttingRotationMatrix = new RotationMatrix();
        cuttingRotationMatrix.setColumns((Tuple3DReadOnly)xAxisRotationMatrix, (Tuple3DReadOnly)yAxisRotationMatrix, (Tuple3DReadOnly)zAxisRotationMatrix);
        RigidBodyTransform handControl = new RigidBodyTransform((Orientation3DReadOnly)cuttingRotationMatrix, (Tuple3DReadOnly)cuttingCenterPosition);
        double phase = time / trajectoryTime;
        handControl.appendYawRotation(cuttingDirectionCW ? -phase * 2.0 * Math.PI : phase * 2.0 * Math.PI);
        handControl.appendTranslation(0.0, cuttingRadius, 0.0);
        handControl.appendYawRotation(cuttingDirectionCW ? phase * 2.0 * Math.PI : -phase * 2.0 * Math.PI);
        return new Pose3D((RigidBodyTransformReadOnly)handControl);
    }

    public static Pose3D computeClosingValveTrajectory(double time, double trajectoryTime, double radius, boolean closingDirectionCW, double closingAngle, Point3D valveCenterPosition, Vector3D valveNormalVector) {
        Vector3D xAxisHandFrame = new Vector3D((Tuple3DReadOnly)valveNormalVector);
        Vector3D yAxisHandFrame = new Vector3D();
        Vector3D zAxisHandFrame = new Vector3D(0.0, 0.0, 1.0);
        xAxisHandFrame.negate();
        xAxisHandFrame.normalize();
        yAxisHandFrame.cross((Tuple3DReadOnly)zAxisHandFrame, (Tuple3DReadOnly)xAxisHandFrame);
        RotationMatrix handFrame = new RotationMatrix();
        handFrame.setColumns((Tuple3DReadOnly)xAxisHandFrame, (Tuple3DReadOnly)yAxisHandFrame, (Tuple3DReadOnly)zAxisHandFrame);
        handFrame.appendRollRotation(closingDirectionCW ? -1.5707963267948966 : 1.5707963267948966);
        RigidBodyTransform handControl = new RigidBodyTransform((Orientation3DReadOnly)handFrame, (Tuple3DReadOnly)valveCenterPosition);
        double phase = time / trajectoryTime;
        handControl.appendRollRotation(closingDirectionCW ? phase * closingAngle : -phase * closingAngle);
        handControl.appendTranslation(0.0, -radius, 0.0);
        return new Pose3D((RigidBodyTransformReadOnly)handControl);
    }

    public static Pose3D computeLinearTrajectory(double time, double trajectoryTime, RigidBodyTransform from, RigidBodyTransform to) {
        double progress = time / trajectoryTime;
        Point3D fromPoint = new Point3D((Tuple3DReadOnly)from.getTranslation());
        Point3D toPoint = new Point3D((Tuple3DReadOnly)to.getTranslation());
        Quaternion fromOrienation = new Quaternion((Orientation3DReadOnly)from.getRotation());
        Quaternion toOrienation = new Quaternion((Orientation3DReadOnly)to.getRotation());
        Point3D point = new Point3D();
        Quaternion orientation = new Quaternion();
        point.interpolate((Tuple3DReadOnly)fromPoint, (Tuple3DReadOnly)toPoint, progress);
        orientation.interpolate((QuaternionReadOnly)fromOrienation, (QuaternionReadOnly)toOrienation, progress);
        return new Pose3D((Tuple3DReadOnly)point, (Orientation3DReadOnly)orientation);
    }

    public static Pose3D computeCircleTrajectory(double time, double trajectoryTime, double circleRadius, Point3DReadOnly circleCenter, Quaternion circleRotation, QuaternionReadOnly constantOrientation, boolean ccw, double phase) {
        double theta = (ccw ? -time : time) / trajectoryTime * 2.0 * Math.PI + phase;
        double z = circleRadius * Math.sin(theta);
        double y = circleRadius * Math.cos(theta);
        Point3D point = new Point3D(0.0, y, z);
        circleRotation.transform((Tuple3DBasics)point);
        point.add((Tuple3DReadOnly)circleCenter);
        return new Pose3D((Tuple3DReadOnly)point, (Orientation3DReadOnly)constantOrientation);
    }
}

