/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialNode;

public class SpatialNodeTree {
    private SpatialNode rootNode;
    private double mostAdvancedTime = 0.0;
    private List<SpatialNode> validNodes = new ArrayList<SpatialNode>();
    private List<SpatialNode> invalidNodes = new ArrayList<SpatialNode>();
    private double timeWeight = 0.5;
    private double positionWeight = 1.0;
    private double orientationWeight = 1.0;
    private double maxTimeInterval = 0.5;
    private double maxPositionDistance = 0.05;
    private double maxOrientationDistance = Math.toRadians(10.0);
    private SpatialNode currentCandidate = null;
    private SpatialNode currentCandidateParent = null;
    private SpatialNode randomNode = null;

    public SpatialNodeTree() {
    }

    public SpatialNodeTree(SpatialNode rootNode) {
        this.rootNode = rootNode;
        this.validNodes.add(rootNode);
    }

    public void addInitialNode(SpatialNode node) {
        this.validNodes.add(node);
    }

    public void setRandomNode(SpatialNode node) {
        this.randomNode = node;
    }

    public SpatialNode getCandidate() {
        return this.currentCandidate;
    }

    public boolean findNearestValidNodeToCandidate(boolean includeTimeComparison) {
        double distanceToNearestNode = Double.MAX_VALUE;
        SpatialNode nearestNode = null;
        for (SpatialNode candidateForParent : this.validNodes) {
            double distance;
            if (this.randomNode.getTime() < candidateForParent.getTime() || !((distance = includeTimeComparison ? candidateForParent.computeDistanceWithinMaxDistance(this.timeWeight, this.positionWeight, this.orientationWeight, this.randomNode, this.maxTimeInterval, this.maxPositionDistance, this.maxOrientationDistance) : candidateForParent.computeDistanceWithinMaxDistance(0.0, this.positionWeight, this.orientationWeight, this.randomNode, this.maxTimeInterval, this.maxPositionDistance, this.maxOrientationDistance)) < distanceToNearestNode)) continue;
            distanceToNearestNode = distance;
            nearestNode = candidateForParent;
        }
        if (nearestNode == null) {
            return false;
        }
        this.currentCandidateParent = nearestNode;
        return true;
    }

    public void limitCandidateDistanceFromParent(double trajectoryTime) {
        this.currentCandidate = this.currentCandidateParent.createNodeWithinTimeStep(this.maxTimeInterval, this.randomNode);
        if (this.currentCandidate.getTime() > trajectoryTime) {
            this.currentCandidate.setTime(trajectoryTime);
        }
        this.currentCandidate.setParent(this.currentCandidateParent);
    }

    public void attachCandidate() {
        if (!this.currentCandidate.isValid()) {
            throw new RuntimeException("Should only attach valid nodes to this tree.");
        }
        this.mostAdvancedTime = Math.max(this.currentCandidate.getTime(), this.mostAdvancedTime);
        this.validNodes.add(new SpatialNode(this.currentCandidate));
    }

    public void attachCandidate(SpatialNode node) {
        this.mostAdvancedTime = Math.max(node.getTime(), this.mostAdvancedTime);
        this.validNodes.add(new SpatialNode(node));
    }

    public void dismissCandidate() {
        if (this.currentCandidate.isValid()) {
            throw new RuntimeException("Should attach valid nodes to this tree.");
        }
        this.currentCandidate.clearParent();
        this.invalidNodes.add(this.currentCandidate);
    }

    public SpatialNode getLastNodeAdded() {
        return this.validNodes.get(this.validNodes.size() - 1);
    }

    public double getTimeWeight() {
        return this.timeWeight;
    }

    public double getPositionWeight() {
        return this.positionWeight;
    }

    public double getOrientationWeight() {
        return this.orientationWeight;
    }

    public double getMaxTimeInterval() {
        return this.maxTimeInterval;
    }

    public double getMaxPositionDistance() {
        return this.maxPositionDistance;
    }

    public double getMaxOrientationDistance() {
        return this.maxOrientationDistance;
    }

    public void setTimeWeight(double timeWeight) {
        this.timeWeight = timeWeight;
    }

    public void setPositionWeight(double positionWeight) {
        this.positionWeight = positionWeight;
    }

    public void setOrientationWeight(double orientationWeight) {
        this.orientationWeight = orientationWeight;
    }

    public void setMaxTimeInterval(double maxTimeInterval) {
        this.maxTimeInterval = maxTimeInterval;
    }

    public void setMaxPositionDistance(double maxPositionDistance) {
        this.maxPositionDistance = maxPositionDistance;
    }

    public void setMaxOrientationDistance(double maxOrientationDistance) {
        this.maxOrientationDistance = maxOrientationDistance;
    }

    public List<SpatialNode> getValidNodes() {
        return this.validNodes;
    }

    public double getMostAdvancedTime() {
        return this.mostAdvancedTime;
    }
}

