/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import java.util.ArrayList;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.NodeData;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.TaskRegion;

public class CTTaskNode {
    protected NodeData nodeData;
    protected NodeData normalizedNodeData;
    private ArrayList<CTTaskNode> childNodes;
    private CTTaskNode parentNode;
    protected boolean validity = true;
    protected KinematicsToolboxOutputStatus configuration;

    public CTTaskNode(CTTaskNode node) {
        this.nodeData = new NodeData(node.nodeData);
        this.normalizedNodeData = new NodeData(node.normalizedNodeData);
        this.configuration = node.configuration;
        this.childNodes = node.childNodes;
        this.parentNode = node.parentNode;
        this.validity = node.validity;
    }

    public CTTaskNode(double[] rootData) {
        this.nodeData = new NodeData(rootData.length);
        this.nodeData.q = rootData;
        this.childNodes = new ArrayList();
        this.normalizedNodeData = new NodeData(rootData.length);
    }

    public CTTaskNode(int dimensionOfData) {
        this.nodeData = new NodeData(dimensionOfData);
        this.childNodes = new ArrayList();
        this.normalizedNodeData = new NodeData(dimensionOfData);
    }

    public final int getDimensionOfNodeData() {
        return this.nodeData.getDimension();
    }

    public final double getNodeData(int index) {
        return this.nodeData.getQ(index);
    }

    public final double getNormalizedNodeData(int index) {
        return this.normalizedNodeData.getQ(index);
    }

    public final double getDistance(CTTaskNode targetNode) {
        return this.nodeData.distance(targetNode.nodeData);
    }

    public final double getNormailzedDistance(CTTaskNode targetNode) {
        return this.normalizedNodeData.distance(targetNode.normalizedNodeData);
    }

    public final double getTimeGap(CTTaskNode targetNode) {
        return targetNode.getNodeData(0) - this.getNodeData(0);
    }

    public final double getNormalizedTimeGap(CTTaskNode targetNode) {
        return targetNode.getNormalizedNodeData(0) - this.getNormalizedNodeData(0);
    }

    public final void setNodeData(int index, double data) {
        this.nodeData.setQ(index, data);
    }

    public final void setNormalizedNodeData(int index, double data) {
        this.normalizedNodeData.setQ(index, data);
    }

    public final void setTimeData(double time) {
        this.nodeData.setQ(0, time);
    }

    public final void addChildNode(CTTaskNode node) {
        this.childNodes.add(node);
        node.setParentNode(this);
    }

    public final CTTaskNode getChildNode(int indexOfChild) {
        return this.childNodes.get(indexOfChild);
    }

    public final int getNumberOfChild() {
        return this.childNodes.size();
    }

    public final void setParentNode(CTTaskNode node) {
        this.parentNode = node;
    }

    public final void clearParentNode() {
        this.parentNode = null;
    }

    public final CTTaskNode getParentNode() {
        return this.parentNode;
    }

    public final void printNodeData() {
        for (int i = 0; i < this.getDimensionOfNodeData(); ++i) {
            PrintTools.info((String)(i + " " + this.getNodeData(i)));
        }
    }

    public final double getTime() {
        return this.getNodeData(0);
    }

    public final void convertDataToNormalizedData(TaskRegion nodeRegion) {
        this.normalizedNodeData = new NodeData(this.getDimensionOfNodeData());
        for (int i = 0; i < this.getDimensionOfNodeData(); ++i) {
            double normalizedValue = 0.0;
            normalizedValue = i == 0 ? (this.getNodeData(i) - nodeRegion.getLowerLimit(i)) / nodeRegion.getTrajectoryTime() : (nodeRegion.isEnable(i) ? (this.getNodeData(i) - nodeRegion.getLowerLimit(i)) / nodeRegion.sizeOfRegion(i) : 0.0);
            this.normalizedNodeData.setQ(i, normalizedValue);
        }
    }

    public final void convertNormalizedDataToData(TaskRegion nodeRegion) {
        this.nodeData = new NodeData(this.getDimensionOfNodeData());
        for (int i = 0; i < this.getDimensionOfNodeData(); ++i) {
            double value = 0.0;
            value = i == 0 ? this.getNormalizedNodeData(i) * nodeRegion.getTrajectoryTime() + nodeRegion.getLowerLimit(i) : this.getNormalizedNodeData(i) * nodeRegion.sizeOfRegion(i) + nodeRegion.getLowerLimit(i);
            this.nodeData.setQ(i, value);
        }
    }

    public final CTTaskNode createNewNodeTowardNode(CTTaskNode towardNode, double alpha) {
        if (alpha > 1.0) {
            alpha = 1.0;
        } else if (alpha < 0.0) {
            alpha = 0.0;
        }
        CTTaskNode createdNewNode = new CTTaskNode(this);
        for (int i = 0; i < createdNewNode.getDimensionOfNodeData(); ++i) {
            double stepToward = (towardNode.getNodeData(i) - this.getNodeData(i)) * alpha;
            createdNewNode.setNodeData(i, this.getNodeData(i) + stepToward);
            stepToward = (towardNode.getNormalizedNodeData(i) - this.getNormalizedNodeData(i)) * alpha;
            createdNewNode.setNormalizedNodeData(i, this.getNormalizedNodeData(i) + stepToward);
        }
        createdNewNode.setParentNode(this);
        return createdNewNode;
    }

    public final void setConfigurationJoints(KinematicsToolboxOutputStatus outputStatus) {
        this.configuration = new KinematicsToolboxOutputStatus(outputStatus);
    }

    public KinematicsToolboxOutputStatus getConfiguration() {
        return this.configuration;
    }

    public void setValidity(boolean value) {
        this.validity = value;
    }

    public boolean getValidity() {
        return this.validity;
    }
}

