/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.manipulation.planning.rrt.RRTNode;

public class RRTPiecewisePath {
    private ArrayList<RRTNode> linearPath = new ArrayList();
    private ArrayList<RRTNode> piecewisePath = new ArrayList();
    private ArrayList<RRTNode> shortcutPath = new ArrayList();
    private int[] pieceIndex;
    private int sizeOfPiecewisePath;
    private RRTNode nodeCreator;

    public RRTPiecewisePath(ArrayList<RRTNode> linearPath, int sizeOfPicewise) {
        this.linearPath = linearPath;
        this.sizeOfPiecewisePath = sizeOfPicewise;
        this.pieceIndex = new int[this.sizeOfPiecewisePath];
        this.nodeCreator = linearPath.get(0).createNode();
        this.initializePiecewisePath();
    }

    private void initializePiecewisePath() {
        RRTNode succedentNode;
        int i;
        double totalLength = 0.0;
        for (int i2 = 0; i2 < this.linearPath.size() - 1; ++i2) {
            totalLength += this.linearPath.get(i2).getDistance(this.linearPath.get(i2 + 1));
        }
        double pieceLength = totalLength / (double)(this.sizeOfPiecewisePath - 1);
        RRTNode precedentNode = this.linearPath.get(0);
        int curPiece = 0;
        RRTNode curPathNode = this.linearPath.get(curPiece);
        RRTNode nextPathNode = this.linearPath.get(curPiece + 1);
        this.addPathPiecewise(precedentNode, curPiece);
        for (i = 1; i < this.sizeOfPiecewisePath - 1; ++i) {
            succedentNode = this.nodeCreator.createNode();
            double remainderLength = pieceLength;
            while (true) {
                double nomalizedDistance;
                if ((nomalizedDistance = precedentNode.getDistance(nextPathNode)) >= remainderLength) break;
                remainderLength -= nomalizedDistance;
                curPathNode = this.linearPath.get(++curPiece);
                nextPathNode = this.linearPath.get(curPiece + 1);
                precedentNode = this.linearPath.get(curPiece);
            }
            double distanceToGo = remainderLength;
            this.setNodeDataInterpolation(precedentNode, nextPathNode, succedentNode, distanceToGo);
            this.addPathPiecewise(succedentNode, curPiece);
            precedentNode = succedentNode;
        }
        succedentNode = this.nodeCreator.createNode();
        for (i = 0; i < precedentNode.getDimensionOfNodeData(); ++i) {
            succedentNode.setNodeData(i, this.linearPath.get(this.linearPath.size() - 1).getNodeData(i));
        }
        this.addPathPiecewise(succedentNode, curPiece);
    }

    private void setNodeDataInterpolation(RRTNode nodeOne, RRTNode nodeTwo, RRTNode targetNode, double desLength) {
        double normailizedDistance = nodeOne.getDistance(nodeTwo);
        for (int i = 0; i < targetNode.getDimensionOfNodeData(); ++i) {
            double dataOne = nodeOne.getNodeData(i);
            double dataTwo = nodeTwo.getNodeData(i);
            double interpolatedData = desLength / normailizedDistance * (dataTwo - dataOne) + dataOne;
            targetNode.setNodeData(i, interpolatedData);
        }
    }

    private void addPathPiecewise(RRTNode node, int idOfPiece) {
        this.piecewisePath.add(node);
        this.pieceIndex[this.piecewisePath.size() - 1] = idOfPiece;
    }

    private int getRandomNumber(int minIndex, int maxIndex) {
        Random randomManager = new Random();
        if (minIndex == maxIndex) {
            return minIndex;
        }
        return randomManager.nextInt(maxIndex - minIndex) + minIndex;
    }

    private int getRandomNumber(int minIndex, int maxIndex, int exceptNumber) {
        int ret;
        Random randomManager = new Random();
        while ((ret = randomManager.nextInt(maxIndex - minIndex) + minIndex) == exceptNumber) {
        }
        return ret;
    }

    private int getRandomPiecewiseNodeIndex(int piece) {
        int i;
        int minIndex = 0;
        int maxIndex = 0;
        for (i = 0; i < this.piecewisePath.size(); ++i) {
            if (this.pieceIndex[i] != piece) continue;
            maxIndex = i;
        }
        for (i = this.piecewisePath.size() - 1; i > -1; --i) {
            if (this.pieceIndex[i] != piece) continue;
            minIndex = i;
        }
        if (minIndex == 0 && maxIndex == 0) {
            return -1;
        }
        return this.getRandomNumber(minIndex, maxIndex);
    }

    private int[] getPiecePair() {
        int[] retPair;
        retPair = new int[]{this.getRandomNumber(0, this.linearPath.size() - 1), this.getRandomNumber(0, this.linearPath.size() - 1, retPair[0])};
        if (retPair[0] > retPair[1]) {
            int pieceTemp = retPair[0];
            retPair[0] = retPair[1];
            retPair[1] = pieceTemp;
        }
        return retPair;
    }

    private boolean isValidPath(ArrayList<RRTNode> nodePath) {
        RRTPiecewisePath newPiecewisePath = new RRTPiecewisePath(nodePath, this.sizeOfPiecewisePath);
        for (int i = 0; i < newPiecewisePath.piecewisePath.size(); ++i) {
            if (newPiecewisePath.piecewisePath.get(i).isValidNode()) continue;
            return false;
        }
        return true;
    }

    public boolean updateShortCutPath() {
        int i;
        int[] linearPiecePair;
        this.shortcutPath.clear();
        int[] piecewisePair = new int[2];
        do {
            linearPiecePair = this.getPiecePair();
            piecewisePair[0] = this.getRandomPiecewiseNodeIndex(linearPiecePair[0]);
            piecewisePair[1] = this.getRandomPiecewiseNodeIndex(linearPiecePair[1]);
        } while (piecewisePair[0] == -1 || piecewisePair[1] == -1);
        for (i = 0; i <= linearPiecePair[0]; ++i) {
            this.shortcutPath.add(this.linearPath.get(i));
        }
        this.shortcutPath.add(this.piecewisePath.get(piecewisePair[0]));
        this.shortcutPath.add(this.piecewisePath.get(piecewisePair[1]));
        for (i = linearPiecePair[1] + 1; i < this.linearPath.size(); ++i) {
            this.shortcutPath.add(this.linearPath.get(i));
        }
        return this.isValidPath(this.shortcutPath);
    }

    public ArrayList<RRTNode> getLinearPath() {
        return this.linearPath;
    }

    public ArrayList<RRTNode> getPiecewisePath() {
        return this.piecewisePath;
    }

    public ArrayList<RRTNode> getShortCutPath() {
        return this.shortcutPath;
    }
}

