/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.walkingpath.rrtplanner;

import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.manipulation.planning.rrt.RRTNode;
import us.ihmc.simulationconstructionset.physics.CollisionShape;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleCollisionDetector;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleCollisionShapeFactory;

public class RRT2DNodeWalkingPath
extends RRTNode {
    private SimpleCollisionDetector collisionDetector = new SimpleCollisionDetector();
    private CollisionDetectionResult collisionDetectionResult = new CollisionDetectionResult();
    private SimpleCollisionShapeFactory shapeFactory;
    public static BoxInfo[] boxes = new BoxInfo[9];

    public RRT2DNodeWalkingPath() {
        super(2);
        super.setNodeData(0, 0.0);
        super.setNodeData(1, 0.0);
        this.setUpCollisionDetector();
    }

    public RRT2DNodeWalkingPath(double px, double py) {
        super(2);
        super.setNodeData(0, px);
        super.setNodeData(1, py);
        this.setUpCollisionDetector();
    }

    @Override
    public boolean isValidNode() {
        Point3D translationOfNode = new Point3D(this.getNodeData(0), this.getNodeData(1), 0.0);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set((Tuple3DReadOnly)translationOfNode);
        ((CollisionShape)this.collisionDetector.getCollisionObjects().get(0)).setTransformToWorld(transform);
        this.collisionDetectionResult.clear();
        this.collisionDetector.performCollisionDetection(this.collisionDetectionResult);
        return this.collisionDetectionResult.getNumberOfCollisions() <= 0;
    }

    @Override
    public RRTNode createNode() {
        return new RRT2DNodeWalkingPath();
    }

    private void setUpCollisionDetector() {
        int i;
        RRT2DNodeWalkingPath.boxes[0] = new BoxInfo(new Point3D(8.6, -4.0, 0.0), new double[]{0.3, 1.5, 2.0});
        for (i = 1; i < 9; ++i) {
            RRT2DNodeWalkingPath.boxes[i] = new BoxInfo(new Point3D(1.5, -0.5, 0.0), new double[]{0.2, 1.0, 0.5});
        }
        RRT2DNodeWalkingPath.boxes[1] = new BoxInfo(new Point3D(3.0, -2.0, 0.0), new double[]{1.5, 0.8, 0.5});
        RRT2DNodeWalkingPath.boxes[2] = new BoxInfo(new Point3D(2.5, 1.0, 0.0), new double[]{0.5, 2.0, 0.5});
        RRT2DNodeWalkingPath.boxes[3] = new BoxInfo(new Point3D(3.5, -0.5, 0.0), new double[]{0.5, 1.3, 0.5});
        RRT2DNodeWalkingPath.boxes[4] = new BoxInfo(new Point3D(5.0, -1.5, 0.0), new double[]{1.0, 0.3, 0.5});
        RRT2DNodeWalkingPath.boxes[5] = new BoxInfo(new Point3D(6.5, -4.5, 0.0), new double[]{1.0, 1.0, 0.5});
        RRT2DNodeWalkingPath.boxes[6] = new BoxInfo(new Point3D(6.0, -6.5, 0.0), new double[]{1.0, 1.3, 0.5});
        RRT2DNodeWalkingPath.boxes[7] = new BoxInfo(new Point3D(10.5, -3.5, 0.0), new double[]{0.3, 0.5, 0.5});
        RRT2DNodeWalkingPath.boxes[8] = new BoxInfo(new Point3D(10.0, -5.5, 0.0), new double[]{0.3, 0.2, 0.5});
        this.shapeFactory = (SimpleCollisionShapeFactory)this.collisionDetector.getShapeFactory();
        this.shapeFactory.addShape(this.shapeFactory.createCapsule(0.4, 2.0));
        ((CollisionShape)this.collisionDetector.getCollisionObjects().get(0)).setCollisionMask(2);
        ((CollisionShape)this.collisionDetector.getCollisionObjects().get(0)).setCollisionGroup(1);
        for (i = 0; i < boxes.length; ++i) {
            this.shapeFactory.addShape(this.shapeFactory.createBox(RRT2DNodeWalkingPath.boxes[i].sizeX / 2.0, RRT2DNodeWalkingPath.boxes[i].sizeY / 2.0, RRT2DNodeWalkingPath.boxes[i].sizeZ / 2.0));
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.getTranslation().set((Tuple3DReadOnly)RRT2DNodeWalkingPath.boxes[i].center);
            ((CollisionShape)this.collisionDetector.getCollisionObjects().get(i + 1)).setTransformToWorld(transform);
            ((CollisionShape)this.collisionDetector.getCollisionObjects().get(i + 1)).setCollisionMask(1);
            ((CollisionShape)this.collisionDetector.getCollisionObjects().get(i + 1)).setCollisionGroup(2);
        }
    }

    @Override
    public void setRandomNodeData() {
    }

    public static class BoxInfo {
        public double centerX;
        public double centerY;
        public double sizeX;
        public double sizeY;
        public double sizeZ;
        public Point3D center;

        public BoxInfo(Point3D center, double[] size) {
            this.center = center;
            this.centerX = center.getX();
            this.centerY = center.getY();
            this.sizeX = size[0];
            this.sizeY = size[1];
            this.sizeZ = size[2];
        }
    }
}

