/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt;

import java.util.ArrayList;
import us.ihmc.manipulation.planning.rrt.RRTInterface;

public abstract class RRTNode
implements RRTInterface {
    private NodeData nodeData;
    private ArrayList<RRTNode> childRRTNode;
    private RRTNode parentRRTNode;

    public RRTNode() {
    }

    public RRTNode(RRTNode node) {
        this.nodeData = node.nodeData;
        this.childRRTNode = node.childRRTNode;
        this.parentRRTNode = node.parentRRTNode;
    }

    public RRTNode(double[] rootData) {
        this.nodeData = new NodeData(rootData.length);
        this.nodeData.q = rootData;
        this.childRRTNode = new ArrayList();
    }

    public RRTNode(int dimensionOfData) {
        this.nodeData = new NodeData(dimensionOfData);
        this.childRRTNode = new ArrayList();
    }

    public final int getDimensionOfNodeData() {
        return this.nodeData.getDimension();
    }

    public final double getNodeData(int index) {
        return this.nodeData.getQ(index);
    }

    public final double getDistance(RRTNode targetNode) {
        return this.nodeData.distance(targetNode.nodeData);
    }

    public final void setNodeData(int index, double data) {
        this.nodeData.setQ(index, data);
    }

    public final void setNodeData(RRTNode copyNode) {
        for (int i = 0; i < copyNode.getDimensionOfNodeData(); ++i) {
            this.nodeData.setQ(i, copyNode.getNodeData(i));
        }
    }

    public final void addChildNode(RRTNode childNode) {
        this.childRRTNode.add(childNode);
        childNode.setParentNode(this);
    }

    public final void setChildNode(int indexOfChild, RRTNode childNode) {
        this.childRRTNode.set(indexOfChild, childNode);
    }

    public final RRTNode getChildNode(int indexOfChild) {
        return this.childRRTNode.get(indexOfChild);
    }

    public final int getNumberOfChild() {
        return this.childRRTNode.size();
    }

    public final void setParentNode(RRTNode parentNode) {
        this.parentRRTNode = parentNode;
    }

    public final RRTNode getParentNode() {
        return this.parentRRTNode;
    }

    public abstract void setRandomNodeData();

    public class NodeData {
        private double[] q;
        private int dimension;

        private NodeData(int dimension) {
            this.q = new double[dimension];
            this.dimension = dimension;
        }

        private NodeData(NodeData nodeData) {
            this.q = new double[nodeData.getDimension()];
            for (int i = 0; i < nodeData.getDimension(); ++i) {
                this.q[i] = nodeData.getQ(i);
            }
            this.dimension = nodeData.getDimension();
        }

        private final int getDimension() {
            return this.dimension;
        }

        private final double getQ(int index) {
            return this.q[index];
        }

        private final void setQ(int index, double value) {
            this.q[index] = value;
        }

        private final double distance(NodeData nodeData) {
            double ret = 0.0;
            for (int i = 0; i < this.dimension; ++i) {
                ret += (nodeData.getQ(i) - this.getQ(i)) * (nodeData.getQ(i) - this.getQ(i));
            }
            ret = Math.sqrt(ret);
            return ret;
        }
    }
}

