/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.manifold;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.MismatchedSizeException;
import toolbox_msgs.msg.dds.ReachingManifoldMessage;
import toolbox_msgs.msg.dds.RigidBodyExplorationConfigurationMessage;
import toolbox_msgs.msg.dds.WaypointBasedTrajectoryMessage;
import toolbox_msgs.msg.dds.WholeBodyTrajectoryToolboxConfigurationMessage;
import toolbox_msgs.msg.dds.WholeBodyTrajectoryToolboxMessage;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.Torus3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.SegmentedLine3DMeshDataGenerator;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.ConfigurationSpaceName;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.WholeBodyTrajectoryToolboxMessageTools;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.ReachingManifoldCommand;
import us.ihmc.manipulation.planning.exploringSpatial.ExploringRigidBodyTools;
import us.ihmc.manipulation.planning.exploringSpatial.TrajectoryLibraryForDRC;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.numericalMethods.GradientDescentModule;
import us.ihmc.robotics.numericalMethods.SingleQueryFunction;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;

public class ReachingManifoldTools {
    private static double extrapolateRatio = 1.5;

    public static Graphics3DObject createManifoldMessageStaticGraphic(ReachingManifoldMessage reachingManifoldMessage, double radius, int resolutionForSingleSpace) {
        Pose3D originPose = new Pose3D((Tuple3DReadOnly)reachingManifoldMessage.getManifoldOriginPosition(), (Orientation3DReadOnly)reachingManifoldMessage.getManifoldOriginOrientation());
        int numberOfPoints = (int)Math.pow(resolutionForSingleSpace, reachingManifoldMessage.getManifoldConfigurationSpaceNames().size());
        SegmentedLine3DMeshDataGenerator segmentedLine3DMeshGenerator = new SegmentedLine3DMeshDataGenerator(numberOfPoints, resolutionForSingleSpace, radius);
        Point3D[] points = new Point3D[numberOfPoints];
        for (int i = 0; i < numberOfPoints; ++i) {
            int j;
            Pose3D pose = new Pose3D((Pose3DReadOnly)originPose);
            double[] configurationValues = new double[reachingManifoldMessage.getManifoldConfigurationSpaceNames().size()];
            int[] configurationIndex = new int[reachingManifoldMessage.getManifoldConfigurationSpaceNames().size()];
            int tempIndex = i;
            for (j = reachingManifoldMessage.getManifoldConfigurationSpaceNames().size(); j > 0; --j) {
                configurationIndex[j - 1] = (int)((double)tempIndex / Math.pow(resolutionForSingleSpace, j - 1));
                tempIndex = (int)((double)tempIndex % Math.pow(resolutionForSingleSpace, j - 1));
            }
            block10: for (j = 0; j < reachingManifoldMessage.getManifoldConfigurationSpaceNames().size(); ++j) {
                configurationValues[j] = (reachingManifoldMessage.getManifoldUpperLimits().get(j) - reachingManifoldMessage.getManifoldLowerLimits().get(j)) / (double)(resolutionForSingleSpace - 1) * (double)configurationIndex[j] + reachingManifoldMessage.getManifoldLowerLimits().get(j);
                ConfigurationSpaceName configurationSpaceName = ConfigurationSpaceName.fromByte((byte)reachingManifoldMessage.getManifoldConfigurationSpaceNames().get(j));
                switch (configurationSpaceName) {
                    case X: {
                        pose.appendTranslation(configurationValues[j], 0.0, 0.0);
                        continue block10;
                    }
                    case Y: {
                        pose.appendTranslation(0.0, configurationValues[j], 0.0);
                        continue block10;
                    }
                    case Z: {
                        pose.appendTranslation(0.0, 0.0, configurationValues[j]);
                        continue block10;
                    }
                    case ROLL: {
                        pose.appendRollRotation(configurationValues[j]);
                        continue block10;
                    }
                    case PITCH: {
                        pose.appendPitchRotation(configurationValues[j]);
                        continue block10;
                    }
                    case YAW: {
                        pose.appendYawRotation(configurationValues[j]);
                        continue block10;
                    }
                }
            }
            points[i] = new Point3D((Tuple3DReadOnly)pose.getPosition());
        }
        if (points.length > 1) {
            segmentedLine3DMeshGenerator.compute((Point3DReadOnly[])points);
        }
        Graphics3DObject graphics = new Graphics3DObject();
        for (MeshDataHolder mesh : segmentedLine3DMeshGenerator.getMeshDataHolders()) {
            graphics.addMeshData(mesh, YoAppearance.AliceBlue());
        }
        return graphics;
    }

    public static WholeBodyTrajectoryToolboxMessage createReachingWholeBodyTrajectoryToolboxMessage(FullHumanoidRobotModel fullRobotModel, RobotSide robotSide, List<ReachingManifoldMessage> reachingManifoldMessages, double desiredTrajectoryTime) {
        RigidBodyBasics hand = fullRobotModel.getHand(robotSide);
        double extrapolateRatio = ReachingManifoldTools.extrapolateRatio;
        double trajectoryTimeBeforeExtrapolated = desiredTrajectoryTime;
        double trajectoryTime = trajectoryTimeBeforeExtrapolated * extrapolateRatio;
        WholeBodyTrajectoryToolboxConfigurationMessage configuration = new WholeBodyTrajectoryToolboxConfigurationMessage();
        configuration.getInitialConfiguration().set(HumanoidMessageTools.createKinematicsToolboxOutputStatus((FullHumanoidRobotModel)fullRobotModel));
        configuration.setMaximumExpansionSize(500);
        ArrayList<WaypointBasedTrajectoryMessage> handTrajectories = new ArrayList<WaypointBasedTrajectoryMessage>();
        ArrayList<RigidBodyExplorationConfigurationMessage> rigidBodyConfigurations = new ArrayList<RigidBodyExplorationConfigurationMessage>();
        ArrayList<ReachingManifoldMessage> reachingManifolds = new ArrayList<ReachingManifoldMessage>();
        double timeResolution = trajectoryTime / 20.0;
        MovingReferenceFrame handControlFrame = fullRobotModel.getHandControlFrame(robotSide);
        RigidBodyTransform handTransform = handControlFrame.getTransformToWorldFrame();
        RigidBodyTransform closestPointOnManifold = new RigidBodyTransform();
        RigidBodyTransform endTransformOnTrajectory = new RigidBodyTransform();
        ArrayList<ReachingManifoldCommand> manifolds = new ArrayList<ReachingManifoldCommand>();
        for (int i = 0; i < reachingManifoldMessages.size(); ++i) {
            ReachingManifoldCommand manifold = new ReachingManifoldCommand();
            manifold.setFromMessage(reachingManifoldMessages.get(i));
            manifolds.add(manifold);
        }
        ReachingManifoldTools.packClosestRigidBodyTransformOnManifold(manifolds, handTransform, closestPointOnManifold, 1.0, 0.1);
        ReachingManifoldTools.packExtrapolatedTransform(handTransform, closestPointOnManifold, extrapolateRatio, endTransformOnTrajectory);
        reachingManifolds.addAll(reachingManifoldMessages);
        WholeBodyTrajectoryToolboxMessageTools.FunctionTrajectory handFunction = time -> TrajectoryLibraryForDRC.computeLinearTrajectory(time, trajectoryTime, handTransform, endTransformOnTrajectory);
        SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
        selectionMatrix.resetSelection();
        WaypointBasedTrajectoryMessage trajectory = WholeBodyTrajectoryToolboxMessageTools.createTrajectoryMessage((RigidBodyBasics)hand, (double)0.0, (double)trajectoryTime, (double)timeResolution, (WholeBodyTrajectoryToolboxMessageTools.FunctionTrajectory)handFunction, (SelectionMatrix6D)selectionMatrix);
        RigidBodyTransform handControlFrameTransformToBodyFixedFrame = new RigidBodyTransform();
        handControlFrame.getTransformToDesiredFrame(handControlFrameTransformToBodyFixedFrame, (ReferenceFrame)hand.getBodyFixedFrame());
        trajectory.getControlFramePositionInEndEffector().set((Tuple3DReadOnly)handControlFrameTransformToBodyFixedFrame.getTranslation());
        trajectory.getControlFrameOrientationInEndEffector().set((Orientation3DReadOnly)handControlFrameTransformToBodyFixedFrame.getRotation());
        handTrajectories.add(trajectory);
        ConfigurationSpaceName[] spaces = new ConfigurationSpaceName[]{ConfigurationSpaceName.X, ConfigurationSpaceName.Y, ConfigurationSpaceName.Z, ConfigurationSpaceName.SO3};
        rigidBodyConfigurations.add(HumanoidMessageTools.createRigidBodyExplorationConfigurationMessage((RigidBodyBasics)hand, (ConfigurationSpaceName[])spaces));
        WholeBodyTrajectoryToolboxMessage message = HumanoidMessageTools.createWholeBodyTrajectoryToolboxMessage((WholeBodyTrajectoryToolboxConfigurationMessage)configuration, handTrajectories, reachingManifolds, rigidBodyConfigurations);
        return message;
    }

    public static double packClosestRigidBodyTransformOnManifold(List<ReachingManifoldCommand> manifolds, Pose3D pose, RigidBodyTransform rigidBodyTransformToPack, double positionWeight, double orientationWeight) {
        return ReachingManifoldTools.packClosestRigidBodyTransformOnManifold(manifolds, new RigidBodyTransform((Orientation3DReadOnly)pose.getOrientation(), (Tuple3DReadOnly)pose.getPosition()), rigidBodyTransformToPack, positionWeight, orientationWeight);
    }

    public static double packClosestRigidBodyTransformOnManifold(List<ReachingManifoldCommand> manifolds, RigidBodyTransform rigidBodyTransform, RigidBodyTransform rigidBodyTransformToPack, double positionWeight, double orientationWeight) {
        double distance = Double.MAX_VALUE;
        int indexToPack = 0;
        for (int i = 0; i < manifolds.size(); ++i) {
            double d = ReachingManifoldTools.packClosestRigidBodyTransformOnManifold(manifolds.get(i), rigidBodyTransform, rigidBodyTransformToPack, positionWeight, orientationWeight);
            if (!(d < distance)) continue;
            distance = d;
            indexToPack = i;
        }
        return ReachingManifoldTools.packClosestRigidBodyTransformOnManifold(manifolds.get(indexToPack), rigidBodyTransform, rigidBodyTransformToPack, positionWeight, orientationWeight);
    }

    public static List<ReachingManifoldMessage> createSphereManifoldMessagesForValkyrie(RobotSide robotSide, RigidBodyBasics hand, Sphere3D sphere3D) {
        return ReachingManifoldTools.createSphereManifoldMessagesForValkyrie(robotSide, hand, (Tuple3DReadOnly)sphere3D.getPosition(), sphere3D.getRadius());
    }

    public static List<ReachingManifoldMessage> createCylinderManifoldMessagesForValkyrie(RobotSide robotSide, RigidBodyBasics hand, Cylinder3D cylinder3D) {
        return ReachingManifoldTools.createCylinderManifoldMessagesForValkyrie(robotSide, hand, (Tuple3DReadOnly)cylinder3D.getPosition(), (RotationMatrixReadOnly)new RotationMatrix((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)cylinder3D.getAxis())), cylinder3D.getRadius(), cylinder3D.getLength());
    }

    public static List<ReachingManifoldMessage> createTorusManifoldMessagesForValkyrie(RobotSide robotSide, RigidBodyBasics hand, Torus3D torus3D) {
        return ReachingManifoldTools.createTorusManifoldMessagesForValkyrie(robotSide, hand, (Tuple3DReadOnly)torus3D.getPosition(), (RotationMatrixReadOnly)new RotationMatrix((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)torus3D.getAxis())), torus3D.getRadius(), torus3D.getTubeRadius());
    }

    public static List<ReachingManifoldMessage> createSphereManifoldMessagesForValkyrie(RobotSide robotSide, RigidBodyBasics hand, Tuple3DReadOnly manifoldOriginPosition, double radius) {
        ArrayList<ReachingManifoldMessage> messages = new ArrayList<ReachingManifoldMessage>();
        ReachingManifoldMessage message = HumanoidMessageTools.createReachingManifoldMessage((RigidBodyBasics)hand);
        ConfigurationSpaceName[] spaces = new ConfigurationSpaceName[]{ConfigurationSpaceName.YAW, ConfigurationSpaceName.ROLL, ConfigurationSpaceName.Y, ConfigurationSpaceName.PITCH};
        double[] lowerLimits = new double[]{-Math.PI, -1.5707963267948966, robotSide.negateIfRightSide(radius), -Math.PI};
        double[] upperLimits = new double[]{Math.PI, 1.5707963267948966, robotSide.negateIfRightSide(radius), Math.PI};
        message.getManifoldOriginPosition().set(manifoldOriginPosition);
        HumanoidMessageTools.packManifold((byte[])ConfigurationSpaceName.toBytes((ConfigurationSpaceName[])spaces), (double[])lowerLimits, (double[])upperLimits, (ReachingManifoldMessage)message);
        messages.add(message);
        return messages;
    }

    public static List<ReachingManifoldMessage> createCylinderManifoldMessagesForValkyrie(RobotSide robotSide, RigidBodyBasics hand, Tuple3DReadOnly manifoldOriginPosition, RotationMatrixReadOnly manifoldOriginOrientation, double radius, double height) {
        double topAreaReductionRatio = 1.0;
        double thicknessForViz = 0.01;
        ArrayList<ReachingManifoldMessage> messages = new ArrayList<ReachingManifoldMessage>();
        ReachingManifoldMessage sideMessage = HumanoidMessageTools.createReachingManifoldMessage((RigidBodyBasics)hand);
        ReachingManifoldMessage topMessage = HumanoidMessageTools.createReachingManifoldMessage((RigidBodyBasics)hand);
        ReachingManifoldMessage bottomMessage = HumanoidMessageTools.createReachingManifoldMessage((RigidBodyBasics)hand);
        ConfigurationSpaceName[] sideSpaces = new ConfigurationSpaceName[]{ConfigurationSpaceName.YAW, ConfigurationSpaceName.Z, ConfigurationSpaceName.Y};
        double[] sideLowerLimits = new double[]{-Math.PI, 0.0, robotSide.negateIfRightSide(radius)};
        double[] sideUpperLimits = new double[]{Math.PI, height, robotSide.negateIfRightSide(radius)};
        sideMessage.getManifoldOriginPosition().set(manifoldOriginPosition);
        sideMessage.getManifoldOriginOrientation().set((Orientation3DReadOnly)manifoldOriginOrientation);
        HumanoidMessageTools.packManifold((byte[])ConfigurationSpaceName.toBytes((ConfigurationSpaceName[])sideSpaces), (double[])sideLowerLimits, (double[])sideUpperLimits, (ReachingManifoldMessage)sideMessage);
        ConfigurationSpaceName[] topSpaces = new ConfigurationSpaceName[]{ConfigurationSpaceName.Y, ConfigurationSpaceName.PITCH, ConfigurationSpaceName.X};
        double[] topLowerLimits = new double[]{height - thicknessForViz, -Math.PI, -radius * topAreaReductionRatio};
        double[] topUpperLimits = new double[]{height, Math.PI, radius * topAreaReductionRatio};
        topMessage.getManifoldOriginPosition().set(manifoldOriginPosition);
        RotationMatrix topOrientation = new RotationMatrix(manifoldOriginOrientation);
        topOrientation.appendRollRotation(robotSide.negateIfRightSide(1.5707963267948966));
        topMessage.getManifoldOriginOrientation().set((Orientation3DReadOnly)topOrientation);
        HumanoidMessageTools.packManifold((byte[])ConfigurationSpaceName.toBytes((ConfigurationSpaceName[])topSpaces), (double[])topLowerLimits, (double[])topUpperLimits, (ReachingManifoldMessage)topMessage);
        ConfigurationSpaceName[] bottomSpaces = new ConfigurationSpaceName[]{ConfigurationSpaceName.Y, ConfigurationSpaceName.PITCH, ConfigurationSpaceName.X};
        double[] bottomLowerLimits = new double[]{0.0 - thicknessForViz, -Math.PI, -radius * topAreaReductionRatio};
        double[] bottomUpperLimits = new double[]{0.0, Math.PI, radius * topAreaReductionRatio};
        bottomMessage.getManifoldOriginPosition().set(manifoldOriginPosition);
        RotationMatrix bottomOrientation = new RotationMatrix(manifoldOriginOrientation);
        bottomOrientation.appendRollRotation(robotSide.negateIfRightSide(-1.5707963267948966));
        bottomMessage.getManifoldOriginOrientation().set((Orientation3DReadOnly)bottomOrientation);
        HumanoidMessageTools.packManifold((byte[])ConfigurationSpaceName.toBytes((ConfigurationSpaceName[])bottomSpaces), (double[])bottomLowerLimits, (double[])bottomUpperLimits, (ReachingManifoldMessage)bottomMessage);
        messages.add(sideMessage);
        messages.add(topMessage);
        messages.add(bottomMessage);
        return messages;
    }

    public static List<ReachingManifoldMessage> createTorusManifoldMessagesForValkyrie(RobotSide robotSide, RigidBodyBasics hand, Tuple3DReadOnly manifoldOriginPosition, RotationMatrixReadOnly manifoldOriginOrientation, double radius, double thickness) {
        double thicknessForViz = 0.01;
        ArrayList<ReachingManifoldMessage> messages = new ArrayList<ReachingManifoldMessage>();
        ReachingManifoldMessage message = HumanoidMessageTools.createReachingManifoldMessage((RigidBodyBasics)hand);
        ConfigurationSpaceName[] spaces = new ConfigurationSpaceName[]{ConfigurationSpaceName.ROLL, ConfigurationSpaceName.Y, ConfigurationSpaceName.YAW, ConfigurationSpaceName.Y};
        double[] lowerLimits = new double[]{-Math.PI, radius, -Math.PI, thickness - thicknessForViz};
        double[] upperLimits = new double[]{Math.PI, radius, Math.PI, thickness};
        message.getManifoldOriginPosition().set(manifoldOriginPosition);
        RotationMatrix orientation = new RotationMatrix(manifoldOriginOrientation);
        orientation.appendPitchRotation(1.5707963267948966);
        message.getManifoldOriginOrientation().set((Orientation3DReadOnly)orientation);
        HumanoidMessageTools.packManifold((byte[])ConfigurationSpaceName.toBytes((ConfigurationSpaceName[])spaces), (double[])lowerLimits, (double[])upperLimits, (ReachingManifoldMessage)message);
        messages.add(message);
        return messages;
    }

    public static ReachingManifoldMessage createGoalManifoldMessage(RigidBodyBasics hand, WholeBodyTrajectoryToolboxMessageTools.FunctionTrajectory handFunction, double trajectoryTime, ConfigurationSpaceName[] manifoldSpaces) {
        ReachingManifoldMessage reachingManifoldMessage = HumanoidMessageTools.createReachingManifoldMessage((RigidBodyBasics)hand);
        reachingManifoldMessage.getManifoldOriginPosition().set(handFunction.compute(trajectoryTime).getPosition());
        reachingManifoldMessage.getManifoldOriginOrientation().set(handFunction.compute(trajectoryTime).getOrientation());
        double[] lowerLimits = new double[manifoldSpaces.length];
        double[] upperLimits = new double[manifoldSpaces.length];
        for (int i = 0; i < lowerLimits.length; ++i) {
            lowerLimits[i] = manifoldSpaces[i].getDefaultExplorationLowerLimit();
            upperLimits[i] = manifoldSpaces[i].getDefaultExplorationUpperLimit();
        }
        HumanoidMessageTools.packManifold((byte[])ConfigurationSpaceName.toBytes((ConfigurationSpaceName[])manifoldSpaces), (double[])lowerLimits, (double[])upperLimits, (ReachingManifoldMessage)reachingManifoldMessage);
        return reachingManifoldMessage;
    }

    public static ReachingManifoldMessage createGoalManifoldMessage(RigidBodyBasics hand, WholeBodyTrajectoryToolboxMessageTools.FunctionTrajectory handFunction, double trajectoryTime, ConfigurationSpaceName[] manifoldSpaces, double[] upperLimits, double[] lowerLimits) {
        ReachingManifoldMessage reachingManifoldMessage = HumanoidMessageTools.createReachingManifoldMessage((RigidBodyBasics)hand);
        reachingManifoldMessage.getManifoldOriginPosition().set(handFunction.compute(trajectoryTime).getPosition());
        reachingManifoldMessage.getManifoldOriginOrientation().set(handFunction.compute(trajectoryTime).getOrientation());
        HumanoidMessageTools.packManifold((byte[])ConfigurationSpaceName.toBytes((ConfigurationSpaceName[])manifoldSpaces), (double[])lowerLimits, (double[])upperLimits, (ReachingManifoldMessage)reachingManifoldMessage);
        return reachingManifoldMessage;
    }

    public static void packExtrapolatedTransform(RigidBodyTransform from, RigidBodyTransform to, double ratio, RigidBodyTransform toPack) {
        Point3D pointToPack = new Point3D();
        RotationMatrix orientationToPack = new RotationMatrix();
        ReachingManifoldTools.packExtrapolatedPoint((Vector3DReadOnly)from.getTranslation(), (Vector3DReadOnly)to.getTranslation(), ratio, pointToPack);
        ReachingManifoldTools.packExtrapolatedOrienation((RotationMatrixReadOnly)from.getRotation(), (RotationMatrixReadOnly)to.getRotation(), ratio, orientationToPack);
        toPack.setIdentity();
        toPack.getTranslation().set((Tuple3DReadOnly)pointToPack);
        toPack.getRotation().set((RotationMatrixReadOnly)orientationToPack);
    }

    public static double getDistance(RigidBodyTransform origin, RigidBodyTransform end, RigidBodyTransform to, double positionWeight, double orientationWeight) {
        int wayPointSize = 100;
        double minimumDistance = Double.MAX_VALUE;
        for (int i = 0; i < wayPointSize; ++i) {
            double interpolatedRatio = (double)i / 100.0;
            RigidBodyTransform interpolated = new RigidBodyTransform();
            ReachingManifoldTools.packExtrapolatedTransform(origin, end, interpolatedRatio, interpolated);
            minimumDistance = Math.min(minimumDistance, ReachingManifoldTools.getDistance(interpolated, to, positionWeight, orientationWeight));
        }
        return minimumDistance;
    }

    public static double getDistance(RigidBodyTransform from, RigidBodyTransform to, double positionWeight, double orientationWeight) {
        Point3D pointFrom = new Point3D((Tuple3DReadOnly)from.getTranslation());
        Quaternion orientationFrom = new Quaternion((Orientation3DReadOnly)from.getRotation());
        Point3D pointTo = new Point3D((Tuple3DReadOnly)to.getTranslation());
        Quaternion orientationTo = new Quaternion((Orientation3DReadOnly)to.getRotation());
        double positionDistance = positionWeight * pointFrom.distance((Point3DReadOnly)pointTo);
        double orientationDistance = orientationWeight * orientationFrom.distance((Orientation3DReadOnly)orientationTo);
        double distance = positionDistance + orientationDistance;
        return distance;
    }

    private static void packExtrapolatedPoint(Vector3DReadOnly from, Vector3DReadOnly to, double ratio, Point3D toPack) {
        toPack.setX(ratio * (to.getX() - from.getX()) + from.getX());
        toPack.setY(ratio * (to.getY() - from.getY()) + from.getY());
        toPack.setZ(ratio * (to.getZ() - from.getZ()) + from.getZ());
    }

    private static void packExtrapolatedOrienation(RotationMatrixReadOnly from, RotationMatrixReadOnly to, double ratio, RotationMatrix toPack) {
        Quaternion invFrom = new Quaternion((Orientation3DReadOnly)from);
        invFrom.inverse();
        Quaternion delFromTo = new Quaternion();
        delFromTo.multiply((QuaternionReadOnly)invFrom, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)to));
        AxisAngle delFromToAxisAngle = new AxisAngle();
        AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)delFromTo, (AxisAngleBasics)delFromToAxisAngle);
        AxisAngle delFromExtraAxisAngle = new AxisAngle((Orientation3DReadOnly)delFromToAxisAngle);
        double extrapolatedAngle = ratio * delFromToAxisAngle.getAngle();
        delFromExtraAxisAngle.setAngle(extrapolatedAngle);
        AxisAngle toPackAxisAngle = new AxisAngle((Orientation3DReadOnly)from);
        toPackAxisAngle.multiply((AxisAngleReadOnly)delFromExtraAxisAngle);
        AxisAngle temp = new AxisAngle((Orientation3DReadOnly)from);
        temp.multiply((AxisAngleReadOnly)delFromToAxisAngle);
        RotationMatrixConversion.convertAxisAngleToMatrix((AxisAngleReadOnly)toPackAxisAngle, (CommonMatrix3DBasics)toPack);
    }

    private static double packClosestRigidBodyTransformOnManifold(final ReachingManifoldCommand reachingManifoldCommand, final RigidBodyTransform rigidBodyTransform, RigidBodyTransform rigidBodyTransformToPack, final double positionWeight, final double orientationWeight) {
        double[] manifoldUpperLimits = reachingManifoldCommand.getManifoldUpperLimits().toArray();
        double[] manifoldLowerLimits = reachingManifoldCommand.getManifoldLowerLimits().toArray();
        TDoubleArrayList initialInput = new TDoubleArrayList();
        TDoubleArrayList upperLimits = new TDoubleArrayList();
        TDoubleArrayList lowerLimits = new TDoubleArrayList();
        for (int i = 0; i < manifoldLowerLimits.length; ++i) {
            initialInput.add((manifoldUpperLimits[i] + manifoldLowerLimits[i]) / 2.0);
            upperLimits.add(manifoldUpperLimits[i]);
            lowerLimits.add(manifoldLowerLimits[i]);
        }
        SingleQueryFunction function = new SingleQueryFunction(){

            public double getQuery(TDoubleArrayList values) {
                RigidBodyTransform closestTransform = new RigidBodyTransform();
                ReachingManifoldTools.packRigidBodyTransformOnManifold(reachingManifoldCommand, values, closestTransform);
                return ReachingManifoldTools.getDistance(rigidBodyTransform, closestTransform, positionWeight, orientationWeight);
            }
        };
        GradientDescentModule solver = new GradientDescentModule(function, initialInput);
        solver.setMaximumIterations(200);
        solver.setInputLowerLimit(lowerLimits);
        solver.setInputUpperLimit(upperLimits);
        solver.run();
        TDoubleArrayList optimalSolution = solver.getOptimalInput();
        rigidBodyTransformToPack.setIdentity();
        rigidBodyTransformToPack.appendTranslation((Tuple3DReadOnly)reachingManifoldCommand.getManifoldOriginPosition());
        rigidBodyTransformToPack.getRotation().set((Orientation3DReadOnly)reachingManifoldCommand.getManifoldOriginOrientation());
        for (int i = 0; i < reachingManifoldCommand.getDimensionOfManifold(); ++i) {
            RigidBodyTransform appendingTransform = ExploringRigidBodyTools.getLocalRigidBodyTransform(reachingManifoldCommand.getDegreeOfManifold(i), optimalSolution.get(i));
            rigidBodyTransformToPack.multiply((RigidBodyTransformReadOnly)appendingTransform);
        }
        return solver.getOptimalQuery();
    }

    private static void packRigidBodyTransformOnManifold(ReachingManifoldCommand reachingManifoldCommand, TDoubleArrayList configurations, RigidBodyTransform rigidBodyTransformToPack) {
        int dimensionOfManifold = reachingManifoldCommand.getDimensionOfManifold();
        if (dimensionOfManifold != configurations.size()) {
            throw new MismatchedSizeException("configuration space size and name size are not matched.");
        }
        rigidBodyTransformToPack.setIdentity();
        rigidBodyTransformToPack.getTranslation().set((Tuple3DReadOnly)reachingManifoldCommand.getManifoldOriginPosition());
        rigidBodyTransformToPack.getRotation().set((Orientation3DReadOnly)reachingManifoldCommand.getManifoldOriginOrientation());
        for (int i = 0; i < configurations.size(); ++i) {
            RigidBodyTransform appendingTransform = ExploringRigidBodyTools.getLocalRigidBodyTransform(reachingManifoldCommand.getDegreeOfManifold(i), configurations.get(i));
            rigidBodyTransformToPack.multiply((RigidBodyTransformReadOnly)appendingTransform);
        }
    }
}

