/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.walkingpath.rrtplanner;

import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.rrt.RRTNode;
import us.ihmc.manipulation.planning.rrt.RRTPlanner;
import us.ihmc.manipulation.planning.walkingpath.footstep.SkeletonPathFootStepPlanner;

public class RRT2DPlannerWalkingPath
extends RRTPlanner {
    SkeletonPathFootStepPlanner footStepPlanner;

    public RRT2DPlannerWalkingPath(RRTNode root, RRTNode goal, double stepLength) {
        super(root, goal, stepLength);
    }

    public boolean expandTreeGoal(RRTNode nodeOne, RRTNode nodeTwo) {
        if (this.getRRTTree().expandTree()) {
            for (int i = 0; i < this.getRRTTree().getNewNode().getDimensionOfNodeData(); ++i) {
                nodeOne.setNodeData(i, this.getRRTTree().getNewNode().getNodeData(i));
                nodeTwo.setNodeData(i, this.getRRTTree().getNearNode().getNodeData(i));
            }
            if (this.getRRTTree().getNewNode().getDistance(this.getGoalNode()) < this.getRRTTree().getStepLength()) {
                this.getRRTTree().getNewNode().addChildNode(this.getGoalNode());
                this.getRRTTree().updatePathNode(this.getGoalNode());
                this.setOptimalPath(this.getRRTTree().getPathNode());
                PrintTools.info((String)("path size is " + this.getOptimalPath().size()));
                return true;
            }
            return false;
        }
        return false;
    }

    public void createFootStepPlanner(double stepLength, double stepWidth) {
        double[] pathX = new double[this.getOptimalPath().size()];
        double[] pathY = new double[this.getOptimalPath().size()];
        for (int i = 0; i < this.getOptimalPath().size(); ++i) {
            pathX[i] = this.getOptimalPath().get(i).getNodeData(0);
            pathY[i] = this.getOptimalPath().get(i).getNodeData(1);
        }
        this.footStepPlanner = new SkeletonPathFootStepPlanner(pathX, pathY, stepLength, stepWidth);
    }

    public SkeletonPathFootStepPlanner getFootStepPlanner() {
        return this.footStepPlanner;
    }
}

