/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.walkingpath.footstep;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.walkingpath.footstep.SkeletonPath;
import us.ihmc.manipulation.planning.walkingpath.footstep.SkeletonPathFootStep;
import us.ihmc.robotics.robotSide.RobotSide;

public class SkeletonPathFootStepPlanner {
    public ArrayList<SkeletonPathFootStep> footSteps = new ArrayList();
    public SkeletonPath skeletonPathSegments;
    public SkeletonPath pathSegmentsRightSide;
    public SkeletonPath pathSegmentsLeftSide;
    private double stepLength;
    private double stepWidth;
    private double stepStride;
    public Point2D tempPoint;

    public SkeletonPathFootStepPlanner(double[] skeletonPathX, double[] skeletonPathY, double stepLength, double stepWidth) {
        PrintTools.info((String)("Number of path node is " + skeletonPathX.length));
        this.stepLength = stepLength;
        this.stepWidth = stepWidth;
        this.stepStride = Math.sqrt(this.stepLength * this.stepLength + this.stepWidth * this.stepWidth);
        this.skeletonPathSegments = new SkeletonPath(skeletonPathX, skeletonPathY);
        this.pathSegmentsRightSide = new SkeletonPath(-this.stepWidth / 2.0, this.skeletonPathSegments);
        this.pathSegmentsLeftSide = new SkeletonPath(this.stepWidth / 2.0, this.skeletonPathSegments);
        PrintTools.info((String)("final " + this.skeletonPathSegments.getFinalPoint().getX() + " " + this.skeletonPathSegments.getFinalPoint().getY()));
    }

    public void setZeroStep(RobotSide robotSide) {
        Point2D.Double footStepLocation = new Point2D.Double();
        if (robotSide == RobotSide.RIGHT) {
            ((Point2D)footStepLocation).setLocation(0.0, -this.stepWidth / 2.0);
            SkeletonPathFootStep footStep = new SkeletonPathFootStep(RobotSide.RIGHT, footStepLocation, this.pathSegmentsRightSide.getYawAngleOfSegment(0));
            footStep.setIndexOfSegment(0);
            this.footSteps.add(footStep);
        } else {
            ((Point2D)footStepLocation).setLocation(0.0, this.stepWidth / 2.0);
            SkeletonPathFootStep footStep = new SkeletonPathFootStep(RobotSide.LEFT, footStepLocation, this.pathSegmentsLeftSide.getYawAngleOfSegment(0));
            footStep.setIndexOfSegment(0);
            this.footSteps.add(footStep);
        }
    }

    public void createFootSteps() {
        for (int i = 0; i < 100; ++i) {
            this.addNextStep();
            if (!(this.footSteps.get(this.footSteps.size() - 1).getLocation().distance(this.skeletonPathSegments.getFinalPoint()) < this.stepWidth / 2.0 + 1.0E-4)) continue;
            PrintTools.info((String)(i + " " + this.footSteps.get(this.footSteps.size() - 1).getLocation().distance(this.skeletonPathSegments.getFinalPoint())));
            this.addNextStep();
            PrintTools.info((String)("numberof steps " + this.footSteps.size()));
            break;
        }
    }

    private void addNextStep() {
        SkeletonPathFootStep newFootStep = new SkeletonPathFootStep();
        SkeletonPathFootStep curFootStep = this.footSteps.get(this.footSteps.size() - 1);
        newFootStep = this.getNextStep(curFootStep);
        this.footSteps.add(newFootStep);
    }

    public SkeletonPathFootStep getNextStep(SkeletonPathFootStep curStep) {
        SkeletonPathFootStep newFootStep = new SkeletonPathFootStep();
        newFootStep = curStep.getRobotSide() == RobotSide.RIGHT ? this.getNextLeftStep(curStep) : this.getNextRightStep(curStep);
        return newFootStep;
    }

    public SkeletonPathFootStep getNextRightStep(SkeletonPathFootStep curStep) {
        SkeletonPathFootStep ret = new SkeletonPathFootStep();
        int indexOfCurSegment = curStep.getIndexOfSegment();
        Line2D curSegment = this.skeletonPathSegments.getSegment(indexOfCurSegment);
        double maxMatric = 0.0;
        int numberOfCandidates = 20;
        for (int i = 0; i < numberOfCandidates; ++i) {
            double curMatric;
            double minSearching = -2.827433388230814;
            double maxSearching = -0.0;
            double angleOfCandidate = minSearching + (double)i * (maxSearching - minSearching) / (double)(numberOfCandidates - 1);
            Point2D aCandidate = this.getACandidate(curStep, this.stepStride, angleOfCandidate);
            SkeletonPathFootStep aProjectedCandidate = this.getProjectedFootStep(RobotSide.RIGHT, aCandidate);
            if (!this.isValidStep(RobotSide.RIGHT, aProjectedCandidate.getLocation(), curSegment) || !(aProjectedCandidate.getLocation().distance(curStep.getLocation()) < this.stepStride) || !((curMatric = this.getXMatric(aProjectedCandidate.getLocation(), curSegment)) > maxMatric)) continue;
            maxMatric = curMatric;
            ret = aProjectedCandidate;
        }
        this.tempPoint = new Point2D.Double(ret.getLocation().getX(), ret.getLocation().getY());
        return ret;
    }

    public SkeletonPathFootStep getNextLeftStep(SkeletonPathFootStep curStep) {
        SkeletonPathFootStep ret = new SkeletonPathFootStep();
        int indexOfCurSegment = curStep.getIndexOfSegment();
        Line2D curSegment = this.skeletonPathSegments.getSegment(indexOfCurSegment);
        double maxMatric = 0.0;
        int numberOfCandidates = 20;
        for (int i = 0; i < numberOfCandidates; ++i) {
            double curMatric;
            double minSearching = 0.0;
            double maxSearching = 2.827433388230814;
            double angleOfCandidate = minSearching + (double)i * (maxSearching - minSearching) / (double)(numberOfCandidates - 1);
            Point2D aCandidate = this.getACandidate(curStep, this.stepStride, angleOfCandidate);
            SkeletonPathFootStep aProjectedCandidate = this.getProjectedFootStep(RobotSide.LEFT, aCandidate);
            if (!this.isValidStep(RobotSide.LEFT, aProjectedCandidate.getLocation(), curSegment) || !(aProjectedCandidate.getLocation().distance(curStep.getLocation()) < this.stepStride) || !((curMatric = this.getXMatric(aProjectedCandidate.getLocation(), curSegment)) > maxMatric)) continue;
            maxMatric = curMatric;
            ret = aProjectedCandidate;
        }
        this.tempPoint = new Point2D.Double(ret.getLocation().getX(), ret.getLocation().getY());
        return ret;
    }

    public SkeletonPathFootStep getProjectedFootStep(RobotSide robotSide, Point2D aPoint) {
        SkeletonPathFootStep retFootStep = new SkeletonPathFootStep();
        SkeletonPath segments = robotSide == RobotSide.RIGHT ? this.pathSegmentsRightSide : this.pathSegmentsLeftSide;
        int indexOfClosestSegment = segments.getIndexOfClosestSegment(aPoint);
        Point2D locationOfProjectedFootStep = segments.getLocationOfClosestPointOnSegment(aPoint);
        double yawAngleOfProjectedFootStep = segments.getYawAngleOfClosestPointOnSegment(aPoint);
        retFootStep.setRobotSide(robotSide);
        retFootStep.setLocation(locationOfProjectedFootStep);
        retFootStep.setYawAngle(yawAngleOfProjectedFootStep);
        retFootStep.setIndexOfSegment(indexOfClosestSegment);
        return retFootStep;
    }

    public Point2D getACandidate(SkeletonPathFootStep curStep, double radius, double rotationAngle) {
        Point2D.Double ret = new Point2D.Double();
        Point2D curLocation = curStep.getLocation();
        double finalAngle = curStep.getYawAngle() + rotationAngle;
        ((Point2D)ret).setLocation(curLocation.getX() + radius * Math.cos(finalAngle), curLocation.getY() + radius * Math.sin(finalAngle));
        return ret;
    }

    private boolean isValidStep(RobotSide robotSideOfStep, Point2D aPoint, Line2D curSegment) {
        if (robotSideOfStep == RobotSide.LEFT) {
            return !(this.getYMatric(aPoint, curSegment) < 0.0);
        }
        return !(this.getYMatric(aPoint, curSegment) >= 0.0);
    }

    public double getXMatric(Point2D aPoint, Line2D curSegment) {
        Point2D.Double aVector = new Point2D.Double(aPoint.getX() - curSegment.getX1(), aPoint.getY() - curSegment.getY1());
        Point2D.Double refVector = new Point2D.Double(curSegment.getX2() - curSegment.getX1(), curSegment.getY2() - curSegment.getY1());
        double norm = Math.sqrt(((Point2D)refVector).getX() * ((Point2D)refVector).getX() + ((Point2D)refVector).getY() * ((Point2D)refVector).getY());
        Point2D.Double refVectorNorm = new Point2D.Double(((Point2D)refVector).getX() / norm, ((Point2D)refVector).getY() / norm);
        return ((Point2D)aVector).getX() * ((Point2D)refVectorNorm).getX() + ((Point2D)aVector).getY() * ((Point2D)refVectorNorm).getY();
    }

    public double getYMatric(Point2D aPoint, Line2D curSegment) {
        Point2D.Double aVector = new Point2D.Double(aPoint.getX() - curSegment.getX1(), aPoint.getY() - curSegment.getY1());
        Point2D.Double refVector = new Point2D.Double(-(curSegment.getY2() - curSegment.getY1()), curSegment.getX2() - curSegment.getX1());
        double norm = Math.sqrt(((Point2D)refVector).getX() * ((Point2D)refVector).getX() + ((Point2D)refVector).getY() * ((Point2D)refVector).getY());
        Point2D.Double refVectorNorm = new Point2D.Double(((Point2D)refVector).getX() / norm, ((Point2D)refVector).getY() / norm);
        return ((Point2D)aVector).getX() * ((Point2D)refVectorNorm).getX() + ((Point2D)aVector).getY() * ((Point2D)refVectorNorm).getY();
    }
}

