/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import java.util.ArrayList;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTNodeVisualizer;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTaskNode;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTaskNodeTree;

public class CTTreeVisualizer {
    private int configurationDimension;
    private ArrayList<CTNodeVisualizer> nodeVisualizers;

    public CTTreeVisualizer(CTTaskNodeTree tree, boolean showUp) {
        this.configurationDimension = tree.getDimensionOfTask();
        this.nodeVisualizers = new ArrayList();
        for (int i = 0; i < this.configurationDimension; ++i) {
            CTNodeVisualizer nodeVisualizer = new CTNodeVisualizer(tree.getTaskName(i + 1), i + 1, showUp);
            this.nodeVisualizers.add(nodeVisualizer);
        }
    }

    public void initialize() {
        for (int i = 0; i < this.configurationDimension; ++i) {
            this.nodeVisualizers.get(i).initialize();
        }
    }

    public void update(CTTaskNode newNode) {
        for (int i = 0; i < this.configurationDimension; ++i) {
            this.nodeVisualizers.get(i).updateVisualizer(newNode);
        }
    }

    public void update(ArrayList<CTTaskNode> path) {
        for (int i = 0; i < this.configurationDimension; ++i) {
            this.nodeVisualizers.get(i).updateVisualizer(path, false);
        }
    }

    public void showUpPath(ArrayList<CTTaskNode> path) {
        for (int i = 0; i < this.configurationDimension; ++i) {
            this.nodeVisualizers.get(i).updateVisualizer(path, true);
        }
    }
}

