/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.rrt.RRTNode;
import us.ihmc.manipulation.planning.rrt.RRTValidConnection;

public class RRTTree {
    protected RRTNode rootNode;
    protected RRTNode nearNode;
    protected RRTNode newNode;
    protected double stepLength;
    protected RRTNode upperBoundNode;
    protected RRTNode lowerBoundNode;
    protected ArrayList<RRTNode> pathNode = new ArrayList();
    protected ArrayList<RRTNode> wholeNodes = new ArrayList();
    public ArrayList<RRTNode> failNodes = new ArrayList();
    protected RRTNode nodeCreator;

    public RRTTree(RRTNode rootNode) {
        this.rootNode = rootNode;
        this.nodeCreator = rootNode.createNode();
        this.wholeNodes.add(this.rootNode);
    }

    public void setStepLength(double length) {
        this.stepLength = length;
    }

    public double getStepLength() {
        return this.stepLength;
    }

    public void setUpperBound(RRTNode upperBoundNode) {
        this.upperBoundNode = upperBoundNode;
    }

    public void setLowerBound(RRTNode lowerBoundNode) {
        this.lowerBoundNode = lowerBoundNode;
    }

    public double getMatric(RRTNode nodeOne, RRTNode nodeTwo) {
        return nodeOne.getDistance(nodeTwo);
    }

    public RRTNode getRandomNode() {
        this.warningMessage();
        RRTNode randomNode = this.nodeCreator.createNode();
        Random randomManager = new Random();
        for (int i = 0; i < randomNode.getDimensionOfNodeData(); ++i) {
            double randonValue = randomManager.nextDouble() * (this.upperBoundNode.getNodeData(i) - this.lowerBoundNode.getNodeData(i)) + this.lowerBoundNode.getNodeData(i);
            randomNode.setNodeData(i, randonValue);
        }
        return randomNode;
    }

    public boolean expandTree() {
        RRTNode node = this.getRandomNode();
        this.updateNearNodeForTargetNode(node);
        this.newNode = this.getNewNode(node);
        return this.addNewNode();
    }

    public boolean expandTree(RRTNode node) {
        this.updateNearNodeForTargetNode(node);
        this.newNode = this.getNewNode(node);
        return this.addNewNode();
    }

    public void updateNearNodeForTargetNode(RRTNode targetNode) {
        RRTNode optNode = this.wholeNodes.get(0);
        double optMatric = Double.MAX_VALUE;
        for (int i = 0; i < this.wholeNodes.size(); ++i) {
            RRTNode curNode = this.wholeNodes.get(i);
            double curMatric = this.getMatric(curNode, targetNode);
            if (!(curMatric < optMatric)) continue;
            optMatric = curMatric;
            optNode = curNode;
        }
        this.nearNode = optNode;
    }

    public RRTNode getNewNode(RRTNode targetNode) {
        RRTNode newNode = this.nodeCreator.createNode();
        if (targetNode.getDistance(this.nearNode) < this.getStepLength()) {
            newNode = targetNode;
        } else {
            for (int i = 0; i < targetNode.getDimensionOfNodeData(); ++i) {
                double normalizedDistance = (targetNode.getNodeData(i) - this.nearNode.getNodeData(i)) / this.nearNode.getDistance(targetNode);
                newNode.setNodeData(i, this.nearNode.getNodeData(i) + this.getStepLength() * normalizedDistance);
            }
        }
        return newNode;
    }

    public boolean addNewNode() {
        RRTValidConnection rrtValidConnection;
        if (this.newNode.isValidNode() && (rrtValidConnection = new RRTValidConnection(this.nearNode, this.newNode)).isValidConnection()) {
            this.nearNode.addChildNode(this.newNode);
            this.wholeNodes.add(this.newNode);
            return true;
        }
        return false;
    }

    public void updatePathNode(RRTNode endNodeOfPath) {
        this.pathNode.clear();
        ArrayList<RRTNode> pathNodeOne = new ArrayList<RRTNode>();
        RRTNode singleNode = endNodeOfPath;
        while (true) {
            pathNodeOne.add(singleNode);
            if (singleNode == this.rootNode) break;
            singleNode = singleNode.getParentNode();
        }
        PrintTools.info((String)"node Path is completely built");
        int pathSize = pathNodeOne.size();
        for (int i = 0; i < pathSize; ++i) {
            this.pathNode.add((RRTNode)pathNodeOne.get(pathSize - i - 1));
        }
    }

    private void warningMessage() {
        if (this.upperBoundNode == null || this.lowerBoundNode == null) {
            PrintTools.info((String)"Searching boundary should be defined (Use methods setUpperBound and setLowerBound)");
        }
        if (this.stepLength == 0.0) {
            PrintTools.info((String)"Step length should be defined (Use methods setStepLength)");
        }
    }

    public RRTNode getRootNode() {
        return this.rootNode;
    }

    public RRTNode getNearNode() {
        return this.nearNode;
    }

    public RRTNode getNewNode() {
        return this.newNode;
    }

    public ArrayList<RRTNode> getPathNode() {
        return this.pathNode;
    }

    public ArrayList<RRTNode> getWholeNode() {
        return this.wholeNodes;
    }

    public void updateNearNodeForTargetNodeOld(RRTNode targetNode) {
        int currentLevel = 0;
        int numberOfCurrentLevel = 0;
        int numberOfFutureLevel = 0;
        int numberOfSearch = 0;
        RRTNode optNode = this.rootNode;
        RRTNode curNode = this.rootNode;
        double optMatric = Double.MAX_VALUE;
        double curMatric = this.getMatric(targetNode, curNode);
        if (curMatric < optMatric) {
            optMatric = curMatric;
            optNode = curNode;
        }
        RRTNode[] nodeOnCurrentLevel = new RRTNode[++numberOfCurrentLevel];
        nodeOnCurrentLevel[currentLevel] = this.rootNode;
        while (true) {
            int i;
            numberOfFutureLevel = 0;
            for (int i2 = 0; i2 < numberOfCurrentLevel; ++i2) {
                numberOfFutureLevel += nodeOnCurrentLevel[i2].getNumberOfChild();
            }
            if (numberOfFutureLevel == 0) break;
            int tempNumber = 0;
            RRTNode[] nodeOnFutureLevel = new RRTNode[numberOfFutureLevel];
            for (i = 0; i < numberOfCurrentLevel; ++i) {
                for (int j = 0; j < nodeOnCurrentLevel[i].getNumberOfChild(); ++j) {
                    nodeOnFutureLevel[tempNumber + j] = nodeOnCurrentLevel[i].getChildNode(j);
                    curNode = nodeOnFutureLevel[tempNumber + j];
                    curMatric = this.getMatric(targetNode, curNode);
                    if (curMatric < optMatric) {
                        optMatric = curMatric;
                        optNode = curNode;
                    }
                    ++numberOfSearch;
                }
                tempNumber += nodeOnCurrentLevel[i].getNumberOfChild();
            }
            numberOfCurrentLevel = numberOfFutureLevel;
            nodeOnCurrentLevel = new RRTNode[numberOfCurrentLevel];
            for (i = 0; i < numberOfCurrentLevel; ++i) {
                nodeOnCurrentLevel[i] = nodeOnFutureLevel[i];
            }
            ++currentLevel;
        }
        this.nearNode = optNode;
    }
}

