/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt;

import java.util.ArrayList;
import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.rrt.RRTNode;
import us.ihmc.manipulation.planning.rrt.RRTPiecewisePath;
import us.ihmc.manipulation.planning.rrt.RRTTree;

public class RRTPlanner {
    private RRTNode rootNode;
    private RRTNode goalNode;
    private RRTTree rrtTree;
    private RRTPiecewisePath rrtPiecewisePath;
    private ArrayList<RRTNode> optimalPath = new ArrayList();

    public RRTPlanner(RRTNode root, RRTNode goal, double stepLength) {
        this.rootNode = root;
        this.goalNode = goal;
        this.rrtTree = new RRTTree(this.rootNode);
        this.rrtTree.setStepLength(stepLength);
    }

    public void expandTreeWhole(int numberOfExpanding) {
        for (int i = 0; i < numberOfExpanding; ++i) {
            this.rrtTree.expandTree();
        }
    }

    public boolean expandTreeGoal(int maxNumberOfExpanding) {
        for (int i = 0; i < maxNumberOfExpanding; ++i) {
            if (!this.rrtTree.expandTree() || !(this.rrtTree.newNode.getDistance(this.goalNode) < this.rrtTree.getStepLength())) continue;
            this.rrtTree.newNode.addChildNode(this.goalNode);
            this.rrtTree.updatePathNode(this.goalNode);
            this.optimalPath = this.rrtTree.pathNode;
            return true;
        }
        return false;
    }

    public void updateOptimalPath(int sizeOfPiecewisePath) {
        if (this.optimalPath.size() > 1) {
            this.rrtPiecewisePath = new RRTPiecewisePath(this.optimalPath, sizeOfPiecewisePath);
            if (this.rrtPiecewisePath.updateShortCutPath()) {
                this.optimalPath = this.rrtPiecewisePath.getShortCutPath();
            }
        }
    }

    public void updateOptimalPath(int sizeOfPiecewisePath, int numberOfIteration) {
        PrintTools.info((String)"Buliding Started");
        for (int i = 0; i < numberOfIteration; ++i) {
            this.updateOptimalPath(sizeOfPiecewisePath);
        }
        if (this.optimalPath.size() > 2) {
            ArrayList<RRTNode> tempPath = new ArrayList<RRTNode>();
            tempPath.add(this.optimalPath.get(0));
            for (int i = 1; i < this.optimalPath.size(); ++i) {
                if (!(this.optimalPath.get(0).getDistance(this.optimalPath.get(i)) > 0.0)) continue;
                tempPath.add(this.optimalPath.get(i));
            }
            this.optimalPath = tempPath;
        }
        PrintTools.info((String)"OptimalPath is Built");
    }

    public RRTTree getRRTTree() {
        return this.rrtTree;
    }

    public RRTPiecewisePath getPiecewisePath() {
        return this.rrtPiecewisePath;
    }

    public ArrayList<RRTNode> getOptimalPath() {
        return this.optimalPath;
    }

    public void setOptimalPath(ArrayList<RRTNode> path) {
        this.optimalPath = path;
    }

    public RRTNode getGoalNode() {
        return this.goalNode;
    }
}

