/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

public class TaskRegion {
    private double[] upperLimit;
    private double[] lowerLimit;
    private boolean[] isEnable;
    private double trajectoryTime;

    public TaskRegion(int size) {
        this.upperLimit = new double[size];
        this.lowerLimit = new double[size];
        this.isEnable = new boolean[size];
    }

    public void setRandomRegion(int index, double lowerValue, double upperValue) {
        if (index == 0) {
            this.upperLimit[index] = upperValue;
            this.trajectoryTime = upperValue;
        } else {
            this.upperLimit[index] = upperValue;
        }
        this.lowerLimit[index] = lowerValue;
        this.isEnable[index] = upperValue != lowerValue;
    }

    public boolean isEnable(int index) {
        return this.isEnable[index];
    }

    public double getUpperLimit(int index) {
        return this.upperLimit[index];
    }

    public double getLowerLimit(int index) {
        return this.lowerLimit[index];
    }

    public double sizeOfRegion(int index) {
        return Math.abs(this.getUpperLimit(index) - this.getLowerLimit(index));
    }

    public double getTrajectoryTime() {
        return this.trajectoryTime;
    }
}

