/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import java.util.Random;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTaskNode;

public class CTTreeTools {
    static Random randomManager = new Random(3L);
    static double timeCoefficient = 3.0;

    public static void setRandomNormalizedNodeData(CTTaskNode node, boolean isUniform, double treeReachingTime) {
        for (int i = 0; i < node.getDimensionOfNodeData(); ++i) {
            CTTreeTools.setRandomNormalizedNodeData(node, i, isUniform, treeReachingTime);
        }
    }

    public static void setRandomNormalizedNodeData(CTTaskNode node, int index, boolean isUniform, double treeReachingTime) {
        double value;
        double exceedIntentionalTimeRatio = timeCoefficient * treeReachingTime;
        double exceedIntentionalRatio = 0.5;
        exceedIntentionalRatio = isUniform ? 0.0 : 1.0;
        if (index == 0) {
            value = randomManager.nextDouble() * (1.0 + exceedIntentionalTimeRatio);
        } else {
            value = randomManager.nextDouble() * (1.0 + exceedIntentionalRatio);
            if ((value -= 0.5 * exceedIntentionalRatio) >= 1.0) {
                value = 1.0;
            }
            if (value <= 0.0) {
                value = 0.0;
            }
        }
        node.setNormalizedNodeData(index, value);
    }

    public static void setRandomConfigurationData(CTTaskNode node, int index, double lowerLimit, double upperLimit, boolean isUniform) {
        double exceedIntentionalRatio = 0.5;
        exceedIntentionalRatio = isUniform ? 0.0 : 1.0;
        double value = randomManager.nextDouble() * (1.0 + exceedIntentionalRatio);
        if ((value -= 0.5 * exceedIntentionalRatio) >= 1.0) {
            value = 1.0;
        }
        if (value <= 0.0) {
            value = 0.0;
        }
        double randomConfigurationData = lowerLimit + value * (upperLimit - lowerLimit);
        node.setNodeData(index, randomConfigurationData);
    }

    public static void setRandomTimeData(CTTaskNode node, double trajectoryTime, double treeReachingTime) {
        double exceedIntentionalTimeRatio = timeCoefficient * treeReachingTime;
        double value = randomManager.nextDouble() * (1.0 + exceedIntentionalTimeRatio);
        if (value > 1.0) {
            value = 1.0;
        }
        double randomTimeData = value * trajectoryTime;
        node.setTimeData(randomTimeData);
    }
}

