/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTaskNode;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTaskNodeTree;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTreeVisualizer;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.TaskRegion;

public class CTTaskNodeTreeExploringTest {
    int numberOfTasks = 5;
    CTTaskNode rootNode = new CTTaskNode(this.numberOfTasks + 1);
    CTTaskNodeTree tree;
    TaskRegion taskRegion;
    CTTreeVisualizer treeVisualizer;

    public CTTaskNodeTreeExploringTest() {
        int i;
        this.rootNode.setNodeData(0, 0.0);
        for (i = 1; i < this.numberOfTasks + 1; ++i) {
            this.rootNode.setNodeData(i, 0.5);
        }
        this.rootNode.setNodeData(1, 0.1);
        this.rootNode.setNodeData(3, 0.9);
        this.rootNode.setNodeData(4, 0.9);
        this.taskRegion = new TaskRegion(this.numberOfTasks + 1);
        for (i = 0; i < this.numberOfTasks + 1; ++i) {
            this.taskRegion.setRandomRegion(i, 0.0, 1.0);
        }
        this.rootNode.convertDataToNormalizedData(this.taskRegion);
        this.tree = new CTTaskNodeTree(this.rootNode);
        this.tree.setTaskRegion(this.taskRegion);
        this.treeVisualizer = new CTTreeVisualizer(this.tree, true);
        this.treeVisualizer.initialize();
        this.treeVisualizer.update(this.rootNode);
        for (i = 0; i < 1000; ++i) {
            this.expandTree();
            if (this.tree.getNewNode().getTime() != this.taskRegion.getTrajectoryTime()) continue;
            PrintTools.info((String)("Finished " + i));
            break;
        }
    }

    private void expandTree() {
        this.tree.updateRandomConfiguration();
        this.tree.updateNearestNodeTaskTime();
        this.tree.updateNewConfiguration();
        this.tree.getNewNode().convertNormalizedDataToData(this.taskRegion);
        this.tree.getNewNode().setParentNode(this.tree.getNearNode());
        this.updateValidity(this.tree.getNewNode());
        if (this.tree.getNewNode().getValidity()) {
            this.tree.connectNewNode(true);
            if (this.tree.getNewNode().getTime() == this.taskRegion.getTrajectoryTime()) {
                // empty if block
            }
        } else {
            this.tree.connectNewNode(false);
            this.tree.updateNearestNodeTaskOnly();
            this.tree.updateNewConfiguration();
            this.tree.getNewNode().convertNormalizedDataToData(this.taskRegion);
            this.tree.getNewNode().setParentNode(this.tree.getNearNode());
            this.updateValidity(this.tree.getNewNode());
            if (this.tree.getNewNode().getValidity()) {
                this.tree.connectNewNode(true);
                if (this.tree.getNewNode().getTime() == this.taskRegion.getTrajectoryTime()) {
                    // empty if block
                }
            }
        }
        this.treeVisualizer.update(this.tree.getNewNode());
    }

    private void updateValidity(CTTaskNode node) {
        boolean eq1;
        if (0.4 < node.getNormalizedNodeData(0) && node.getNormalizedNodeData(0) < 0.6) {
            boolean eq2;
            eq1 = 0.3 < node.getNormalizedNodeData(1) && node.getNormalizedNodeData(1) < 0.7;
            boolean bl = eq2 = 0.4 < node.getNormalizedNodeData(2) && node.getNormalizedNodeData(2) < 0.6;
            if (eq1 || eq2) {
                node.setValidity(false);
            }
        }
        if (0.8 < node.getNormalizedNodeData(0) && node.getNormalizedNodeData(0) < 0.95) {
            boolean bl = eq1 = 0.1 < node.getNormalizedNodeData(1) && node.getNormalizedNodeData(1) < 0.4;
            if (eq1) {
                node.setValidity(false);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("Exploring test for CTNodeTree");
        CTTaskNodeTreeExploringTest test = new CTTaskNodeTreeExploringTest();
        System.out.println("Finished");
    }
}

