/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt;

import java.util.ArrayList;
import us.ihmc.manipulation.planning.rrt.RRTNode;

public class RRTValidConnection {
    private RRTNode parentNode;
    private RRTNode childNode;
    private RRTNode nodeCreator;
    private ArrayList<RRTNode> nodes = new ArrayList();
    public int numberOfPiece = 20;

    public RRTValidConnection(RRTNode parentNode, RRTNode childNode) {
        this.parentNode = parentNode;
        this.childNode = childNode;
        this.nodeCreator = parentNode.createNode();
        this.initialize();
    }

    private void initialize() {
        double length = this.parentNode.getDistance(this.childNode);
        if (length == 0.0) {
            this.nodes.add(this.parentNode);
        } else {
            for (int i = 1; i < this.numberOfPiece - 1; ++i) {
                RRTNode aNode = this.nodeCreator.createNode();
                for (int j = 0; j < this.parentNode.getDimensionOfNodeData(); ++j) {
                    double parentData = this.parentNode.getNodeData(j);
                    double childData = this.childNode.getNodeData(j);
                    double aNodeData = (parentData - childData) * (double)i / (double)(this.numberOfPiece - 1) + childData;
                    aNode.setNodeData(j, aNodeData);
                }
                this.nodes.add(aNode);
            }
        }
    }

    public boolean isValidConnection() {
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            if (this.nodes.get(i).isValidNode()) continue;
            return false;
        }
        return true;
    }

    public void reInitialize(int numberOfPiece) {
        this.nodes.clear();
        this.numberOfPiece = numberOfPiece;
        this.initialize();
    }
}

