/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.WholeBodyTrajectoryToolboxMessageTools;

public class FunctionTrajectoryTools {
    public static WholeBodyTrajectoryToolboxMessageTools.FunctionTrajectory circleTrajectory(final Point3DReadOnly circleCenter, final QuaternionReadOnly circleOrientation, final QuaternionReadOnly outputOrientation, final double radius, final double angleStart, final boolean clockwise, final double t0, final double tf) {
        return new WholeBodyTrajectoryToolboxMessageTools.FunctionTrajectory(){

            public Pose3D compute(double time) {
                RigidBodyTransform circlePose = new RigidBodyTransform((Orientation3DReadOnly)circleOrientation, (Tuple3DReadOnly)circleCenter);
                time = MathTools.clamp((double)time, (double)t0, (double)tf);
                double angle = angleStart + Math.PI * 2 * (time - t0) / (tf - t0);
                if (clockwise) {
                    angle = -angle;
                }
                double xLocal = radius * Math.cos(angle);
                double yLocal = radius * Math.sin(angle);
                Point3D point = new Point3D(xLocal, yLocal, 0.0);
                circlePose.transform((Point3DBasics)point);
                return new Pose3D((Tuple3DReadOnly)point, (Orientation3DReadOnly)outputOrientation);
            }
        };
    }
}

