/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import java.util.ArrayList;
import us.ihmc.commons.PrintTools;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTaskNode;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTreeTools;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.TaskRegion;

public class CTTaskNodeTree {
    private CTTaskNode rootNode;
    private CTTaskNode nearNode;
    private CTTaskNode newNode;
    public CTTaskNode randomNode;
    private ArrayList<CTTaskNode> path = new ArrayList();
    private ArrayList<CTTaskNode> wholeNodes = new ArrayList();
    private ArrayList<CTTaskNode> failNodes = new ArrayList();
    private ArrayList<CTTaskNode> optimalPath = new ArrayList();
    private TaskRegion nodeRegion;
    private static double matricRatioTimeToTask = 0.2;
    private double maximumDisplacementOfStep = 0.06;
    private double maximumTimeGapOfStep = 0.05;
    public static double dismissibleTimeGap = 0.01;
    private int dimensionOfTask;
    private ArrayList<String> taskNames;
    private double trajectoryTime;
    private double treeReachingTime = 0.0;

    public CTTaskNodeTree(CTTaskNode rootNode) {
        this.rootNode = new CTTaskNode(rootNode);
        this.wholeNodes.add(this.rootNode);
        this.dimensionOfTask = rootNode.getDimensionOfNodeData() - 1;
        this.taskNames = new ArrayList();
        this.taskNames.add("time");
        for (int i = 1; i < this.dimensionOfTask + 1; ++i) {
            this.taskNames.add("Task_" + i + "_");
        }
        this.treeReachingTime = 0.0;
    }

    public CTTaskNodeTree(CTTaskNode rootNode, String ... taskNames) {
        this.rootNode = rootNode;
        this.wholeNodes.add(this.rootNode);
        this.dimensionOfTask = rootNode.getDimensionOfNodeData() - 1;
        this.taskNames = new ArrayList();
        this.taskNames.add("time");
        if (this.dimensionOfTask != taskNames.length) {
            PrintTools.warn((String)"Task dimension is incorrect");
        } else {
            for (int i = 1; i < this.dimensionOfTask + 1; ++i) {
                this.taskNames.add("Task_" + i + "_" + taskNames[i - 1]);
            }
        }
        this.treeReachingTime = 0.0;
    }

    public void setTaskRegion(TaskRegion taskRegion) {
        this.nodeRegion = taskRegion;
    }

    public String getTaskName(int indexOfDimension) {
        return this.taskNames.get(indexOfDimension);
    }

    public int getDimensionOfTask() {
        return this.dimensionOfTask;
    }

    public double getTrajectoryTime() {
        this.trajectoryTime = this.nodeRegion.getTrajectoryTime();
        return this.trajectoryTime;
    }

    public void setMatricRatioTimeToTask(double ratio) {
        matricRatioTimeToTask = ratio;
    }

    private double getNormalizedTaskDisplacement(CTTaskNode nodeOne, CTTaskNode nodeTwo) {
        double squaredDisplacement = 0.0;
        for (int i = 1; i < this.rootNode.getDimensionOfNodeData(); ++i) {
            double nodeOneValue = nodeOne.getNormalizedNodeData(i);
            double nodeTwoValue = nodeTwo.getNormalizedNodeData(i);
            squaredDisplacement += (nodeOneValue - nodeTwoValue) * (nodeOneValue - nodeTwoValue);
        }
        return Math.sqrt(squaredDisplacement);
    }

    public double getMetricTaskOnly(CTTaskNode nodeOne, CTTaskNode nodeTwo) {
        double normalizedtimeGap = nodeOne.getNormalizedTimeGap(nodeTwo);
        double normalizedTaskDisplacement = this.getNormalizedTaskDisplacement(nodeOne, nodeTwo);
        if (normalizedtimeGap <= 0.0) {
            return Double.MAX_VALUE;
        }
        double matric = normalizedTaskDisplacement;
        return matric;
    }

    public double getMetricTaskTime(CTTaskNode nodeOne, CTTaskNode nodeTwo) {
        double normalizedtimeGap = nodeOne.getNormalizedTimeGap(nodeTwo);
        double normalizedTaskDisplacement = this.getNormalizedTaskDisplacement(nodeOne, nodeTwo);
        if (normalizedtimeGap <= 0.0) {
            return Double.MAX_VALUE;
        }
        double matric = 0.0;
        matric = normalizedtimeGap * normalizedtimeGap * matricRatioTimeToTask + normalizedTaskDisplacement * normalizedTaskDisplacement * 1.0;
        matric = Math.sqrt(matric);
        return matric;
    }

    public void updateRandomConfiguration() {
        CTTaskNode randomNode = new CTTaskNode(this.rootNode);
        CTTreeTools.setRandomNormalizedNodeData(randomNode, false, this.treeReachingTime);
        for (int i = 0; i < this.rootNode.getDimensionOfNodeData(); ++i) {
            if (this.nodeRegion.isEnable(i)) continue;
            randomNode.setNormalizedNodeData(i, 0.0);
        }
        this.randomNode = randomNode;
    }

    public void updateNearestNodeTaskOnly() {
        CTTaskNode nearNode = this.rootNode;
        double optMatric = Double.MAX_VALUE;
        for (int i = 0; i < this.wholeNodes.size(); ++i) {
            CTTaskNode curNode = this.wholeNodes.get(i);
            double curMatric = this.getMetricTaskOnly(curNode, this.randomNode);
            if (!(curMatric < optMatric)) continue;
            optMatric = curMatric;
            nearNode = curNode;
        }
        this.nearNode = nearNode;
    }

    public void updateNearestNodeTaskTime() {
        CTTaskNode nearNode = this.rootNode;
        double optMatric = Double.MAX_VALUE;
        for (int i = 0; i < this.wholeNodes.size(); ++i) {
            CTTaskNode curNode = this.wholeNodes.get(i);
            double curMatric = this.getMetricTaskTime(curNode, this.randomNode);
            if (!(curMatric < optMatric)) continue;
            optMatric = curMatric;
            nearNode = curNode;
        }
        this.nearNode = nearNode;
    }

    public void updateNewConfiguration() {
        double expandingDisplacement;
        CTTaskNode newNode = new CTTaskNode(this.rootNode);
        double timeGap = this.nearNode.getNormalizedTimeGap(this.randomNode);
        double displacement = this.getNormalizedTaskDisplacement(this.nearNode, this.randomNode);
        double expandingTimeGap = timeGap > this.maximumTimeGapOfStep ? this.maximumTimeGapOfStep : timeGap;
        double expandedTime = this.nearNode.getNormalizedNodeData(0) + expandingTimeGap;
        if (expandedTime > 1.0) {
            expandedTime = 1.0;
            expandingTimeGap = expandedTime - this.nearNode.getNormalizedNodeData(0);
        }
        if ((expandingDisplacement = displacement * expandingTimeGap / timeGap) > this.maximumDisplacementOfStep) {
            expandingDisplacement = this.maximumDisplacementOfStep;
            expandingTimeGap = timeGap * this.maximumDisplacementOfStep / displacement;
        }
        newNode.setNormalizedNodeData(0, this.nearNode.getNormalizedNodeData(0) + expandingTimeGap);
        for (int i = 1; i < newNode.getDimensionOfNodeData(); ++i) {
            double iDisplacement = (this.randomNode.getNormalizedNodeData(i) - this.nearNode.getNormalizedNodeData(i)) / displacement * expandingDisplacement;
            newNode.setNormalizedNodeData(i, this.nearNode.getNormalizedNodeData(i) + iDisplacement);
        }
        this.newNode = newNode;
    }

    public void connectNewNode(boolean connect) {
        if (connect) {
            this.nearNode.addChildNode(this.newNode);
            this.wholeNodes.add(this.newNode);
            if (this.newNode.getNormalizedNodeData(0) > this.treeReachingTime) {
                this.treeReachingTime = this.newNode.getNormalizedNodeData(0);
            }
        } else {
            this.newNode.clearParentNode();
            this.failNodes.add(this.newNode);
        }
    }

    public void updateOptimalPath() {
        if (this.optimalPath.size() == 0) {
            PrintTools.info((String)"The optimalPath is empty.");
        } else if (this.optimalPath.size() == 2) {
            PrintTools.info((String)"The optimalPath has only one linear line.");
        }
    }

    public TaskRegion getTaskNodeRegion() {
        return this.nodeRegion;
    }

    public CTTaskNode getNewNode() {
        return this.newNode;
    }

    public CTTaskNode getNearNode() {
        return this.nearNode;
    }

    public ArrayList<CTTaskNode> getPath() {
        return this.path;
    }

    public void addNodeOnPath(CTTaskNode node) {
        this.path.add(node);
    }

    public ArrayList<CTTaskNode> getWholeNodes() {
        return this.wholeNodes;
    }

    public ArrayList<CTTaskNode> getFailNodes() {
        return this.failNodes;
    }

    public ArrayList<CTTaskNode> getOptimalPath() {
        return this.optimalPath;
    }

    public double getTreeReachingTime() {
        return this.treeReachingTime;
    }
}

