/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace;

import java.awt.Color;
import java.util.ArrayList;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.plotting.artifact.CircleArtifact;
import us.ihmc.graphicsDescription.plotting.artifact.LineArtifact;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.CTTaskNode;
import us.ihmc.plotting.Plotter;

public class CTNodeVisualizer {
    private Plotter plotter;
    private int configurationIndex;
    private int updateCnt;
    private boolean enabled;
    private String ctaskName;

    public CTNodeVisualizer(String ctaskName, int configurationIndex, boolean enabled) {
        this.ctaskName = ctaskName;
        this.plotter = new Plotter();
        this.configurationIndex = configurationIndex;
        this.plotter.setPreferredSize(700, 700);
        this.plotter.setViewRange(1.5);
        this.plotter.setXYZoomEnabled(true);
        this.plotter.setShowLabels(true);
        this.plotter.setFocusPointX(0.5);
        this.plotter.setFocusPointY(0.5);
        this.enabled = enabled;
    }

    public void initialize() {
        this.updateCnt = 0;
        if (this.enabled) {
            this.plotter.showInNewWindow(this.ctaskName, false);
        }
    }

    public void updateVisualizer(CTTaskNode newNode) {
        String prefix = "wholenodes_" + this.configurationIndex + "" + this.updateCnt;
        if (newNode.getValidity()) {
            if (newNode.getParentNode() != null) {
                CTTaskNode parentNode = newNode.getParentNode();
                LineArtifact lineArtifact = new LineArtifact(prefix + "_line", (Point2DReadOnly)new Point2D(parentNode.getNormalizedNodeData(0), parentNode.getNormalizedNodeData(this.configurationIndex)), (Point2DReadOnly)new Point2D(newNode.getNormalizedNodeData(0), newNode.getNormalizedNodeData(this.configurationIndex)));
                lineArtifact.setColor(Color.blue);
                this.plotter.addArtifact((Artifact)lineArtifact);
            }
            CircleArtifact nodeArtifact = new CircleArtifact(prefix + "_valid", newNode.getNormalizedNodeData(0), newNode.getNormalizedNodeData(this.configurationIndex), 0.0075, true);
            nodeArtifact.setColor(Color.blue);
            this.plotter.addArtifact((Artifact)nodeArtifact);
        } else {
            CircleArtifact nodeArtifact = new CircleArtifact(prefix + "_invalid", newNode.getNormalizedNodeData(0), newNode.getNormalizedNodeData(this.configurationIndex), 0.0075, true);
            nodeArtifact.setColor(Color.red);
            this.plotter.addArtifact((Artifact)nodeArtifact);
        }
        this.plotter.update();
        ++this.updateCnt;
    }

    private void updateVisualizer(CTTaskNode newNode, boolean isShortcut) {
        Color pathColor;
        String prefix;
        if (isShortcut) {
            prefix = "shortcut_" + this.configurationIndex + "" + this.updateCnt;
            pathColor = Color.green;
        } else {
            prefix = "path_" + this.configurationIndex + "" + this.updateCnt;
            pathColor = Color.black;
        }
        if (newNode.getParentNode() != null) {
            CTTaskNode parentNode = newNode.getParentNode();
            LineArtifact lineArtifact = new LineArtifact(prefix + "_line", (Point2DReadOnly)new Point2D(parentNode.getNormalizedNodeData(0), parentNode.getNormalizedNodeData(this.configurationIndex)), (Point2DReadOnly)new Point2D(newNode.getNormalizedNodeData(0), newNode.getNormalizedNodeData(this.configurationIndex)));
            lineArtifact.setColor(pathColor);
            this.plotter.addArtifact((Artifact)lineArtifact);
        }
        CircleArtifact nodeArtifact = new CircleArtifact(prefix + "_valid", newNode.getNormalizedNodeData(0), newNode.getNormalizedNodeData(this.configurationIndex), 0.012, true);
        nodeArtifact.setColor(pathColor);
        this.plotter.addArtifact((Artifact)nodeArtifact);
        this.plotter.update();
        ++this.updateCnt;
    }

    public void updateVisualizer(ArrayList<CTTaskNode> path, boolean isShortcut) {
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            this.updateVisualizer(path.get(i), isShortcut);
        }
    }
}

