/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.manifold;

import controller_msgs.msg.dds.ReachingManifoldMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.ReachingManifoldCommand;
import us.ihmc.manipulation.planning.manifold.ReachingManifoldTools;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ReachingManifoldVisualizingTest {
    private static final ManifoldType type = ManifoldType.Torus;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final double trajectoryTime = 0.05;
    private final double dt = 0.001;
    private final int recordFrequency = 1;
    private final int bufferSize = 52;
    private final YoDouble currentTrajectoryTime = new YoDouble("CurrentTime", this.registry);
    private final Random random = new Random(1L);
    private final Point3D manifoldOriginPosition = new Point3D(0.7, -0.2, 1.0);
    private final RotationMatrix manifoldOriginOrientation = new RotationMatrix();
    private final Point3D initialHandPosition = new Point3D(0.1, -0.4, 0.8);
    private final double[] handLowerLimits = new double[]{1.0, 0.5, 0.4};
    private final double[] handUpperLimits = new double[]{-0.2, -0.3, -0.2};

    public ReachingManifoldVisualizingTest() {
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setCreateGUI(true);
        parameters.setDataBufferSize(52);
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("voidrobot"), parameters);
        RigidBody hand = new RigidBody("hand", (RigidBodyTransformReadOnly)new RigidBodyTransform(), worldFrame);
        List<ReachingManifoldMessage> reachingManifolds = null;
        switch (type) {
            case Sphere: {
                reachingManifolds = ReachingManifoldTools.createSphereManifoldMessagesForValkyrie(RobotSide.LEFT, (RigidBodyBasics)hand, (Tuple3DReadOnly)this.manifoldOriginPosition, 0.1);
                break;
            }
            case Cylinder: {
                reachingManifolds = ReachingManifoldTools.createCylinderManifoldMessagesForValkyrie(RobotSide.LEFT, (RigidBodyBasics)hand, (Tuple3DReadOnly)this.manifoldOriginPosition, (RotationMatrixReadOnly)this.manifoldOriginOrientation, 0.2, 0.3);
                break;
            }
            case Torus: {
                reachingManifolds = ReachingManifoldTools.createTorusManifoldMessagesForValkyrie(RobotSide.LEFT, (RigidBodyBasics)hand, (Tuple3DReadOnly)this.manifoldOriginPosition, (RotationMatrixReadOnly)this.manifoldOriginOrientation, 0.3, 0.025);
            }
        }
        YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
        for (int i = 0; i < reachingManifolds.size(); ++i) {
            scs.addStaticLinkGraphics(ReachingManifoldTools.createManifoldMessageStaticGraphic(reachingManifolds.get(i), 0.01, 10));
        }
        ArrayList<ReachingManifoldCommand> manifolds = new ArrayList<ReachingManifoldCommand>();
        for (int i = 0; i < reachingManifolds.size(); ++i) {
            ReachingManifoldCommand manifold = new ReachingManifoldCommand();
            manifold.setFromMessage(reachingManifolds.get(i));
            manifolds.add(manifold);
        }
        YoDouble yoPXHand = new YoDouble("yoPXHand", this.registry);
        YoDouble yoPYHand = new YoDouble("yoPYHand", this.registry);
        YoDouble yoPZHand = new YoDouble("yoPZHand", this.registry);
        YoDouble yoYawHand = new YoDouble("yoYawHand", this.registry);
        YoDouble yoPitchHand = new YoDouble("yoPitchHand", this.registry);
        YoDouble yoRollHand = new YoDouble("yoRollHand", this.registry);
        YoFramePoint3D yoFramePointHand = new YoFramePoint3D(yoPXHand, yoPYHand, yoPZHand, worldFrame);
        YoFrameYawPitchRoll yoFrameYawPitchRollHand = new YoFrameYawPitchRoll(yoYawHand, yoPitchHand, yoRollHand, worldFrame);
        yoGraphicsListRegistry.registerYoGraphic("handViz", (YoGraphic)new YoGraphicCoordinateSystem("handViz", yoFramePointHand, yoFrameYawPitchRollHand, 0.2));
        YoDouble yoPX = new YoDouble("yoPX", this.registry);
        YoDouble yoPY = new YoDouble("yoPY", this.registry);
        YoDouble yoPZ = new YoDouble("yoPZ", this.registry);
        YoDouble yoYaw = new YoDouble("yoYaw", this.registry);
        YoDouble yoPitch = new YoDouble("yoPitch", this.registry);
        YoDouble yoRoll = new YoDouble("yoRoll", this.registry);
        YoFramePoint3D yoFramePoint = new YoFramePoint3D(yoPX, yoPY, yoPZ, worldFrame);
        YoFrameYawPitchRoll yoFrameYawPitchRoll = new YoFrameYawPitchRoll(yoYaw, yoPitch, yoRoll, worldFrame);
        yoGraphicsListRegistry.registerYoGraphic("pointViz", (YoGraphic)new YoGraphicCoordinateSystem("closestPointViz", yoFramePoint, yoFrameYawPitchRoll, 0.2));
        scs.addYoRegistry(this.registry);
        scs.setDT(0.001, 1);
        Graphics3DObject worldFrameGraphics = new Graphics3DObject();
        worldFrameGraphics.addCoordinateSystem(0.3);
        scs.addStaticLinkGraphics(worldFrameGraphics);
        scs.addYoGraphicsListRegistry(yoGraphicsListRegistry, true);
        for (double t = 0.0; t <= 0.05; t += 0.001) {
            this.currentTrajectoryTime.set(t);
            yoPXHand.set(this.initialHandPosition.getX() + this.random(this.handLowerLimits[0], this.handUpperLimits[0]));
            yoPYHand.set(this.initialHandPosition.getY() + this.random(this.handLowerLimits[1], this.handUpperLimits[1]));
            yoPZHand.set(this.initialHandPosition.getZ() + this.random(this.handLowerLimits[2], this.handUpperLimits[2]));
            YawPitchRoll randomYPR = new YawPitchRoll();
            Quaternion randomQuat = new Quaternion();
            double s = this.random(0.0, 1.0);
            double s1 = Math.sqrt(1.0 - s);
            double s2 = Math.sqrt(s);
            double theta1 = Math.PI * 2 * this.random(0.0, 1.0);
            double theta2 = Math.PI * 2 * this.random(0.0, 1.0);
            randomQuat.set(Math.sin(theta1) * s1, Math.cos(theta1) * s1, Math.sin(theta2) * s2, Math.cos(theta2) * s2);
            randomQuat.norm();
            YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)randomQuat, (YawPitchRollBasics)randomYPR);
            yoYawHand.set(randomYPR.getYaw());
            yoPitchHand.set(randomYPR.getPitch());
            yoRollHand.set(randomYPR.getRoll());
            RigidBodyTransform handTransform = new RigidBodyTransform();
            handTransform.appendTranslation(yoPXHand.getDoubleValue(), yoPYHand.getDoubleValue(), yoPZHand.getDoubleValue());
            handTransform.getRotation().setYawPitchRoll(yoYawHand.getDoubleValue(), yoPitchHand.getDoubleValue(), yoRollHand.getDoubleValue());
            RigidBodyTransform closestTransform = new RigidBodyTransform();
            ReachingManifoldTools.packClosestRigidBodyTransformOnManifold(manifolds, handTransform, closestTransform, 1.0, 0.1);
            yoPX.set(closestTransform.getTranslationX());
            yoPY.set(closestTransform.getTranslationY());
            yoPZ.set(closestTransform.getTranslationZ());
            YawPitchRoll closestYPR = new YawPitchRoll();
            YawPitchRollConversion.convertMatrixToYawPitchRoll((RotationMatrixReadOnly)closestTransform.getRotation(), (YawPitchRollBasics)closestYPR);
            yoYaw.set(closestYPR.getYaw());
            yoPitch.set(closestYPR.getPitch());
            yoRoll.set(closestYPR.getRoll());
            scs.tickAndUpdate();
        }
        scs.startOnAThread();
        ThreadTools.sleepForever();
    }

    public static void main(String[] args) {
        new ReachingManifoldVisualizingTest();
    }

    private double random(double lowerLimit, double upperLimit) {
        return this.random.nextDouble() * (upperLimit - lowerLimit) + lowerLimit;
    }

    private static enum ManifoldType {
        Sphere,
        Cylinder,
        Torus;

    }
}

