/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.exploringSpatial;

import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialData;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public class SpatialNode {
    private double time;
    private SpatialData spatialData;
    private SpatialNode parent;
    private boolean validity = true;
    private KinematicsToolboxOutputStatus configuration;

    public SpatialNode() {
    }

    public SpatialNode(SpatialData spatialData) {
        this(0.0, spatialData);
    }

    public SpatialNode(double time, SpatialData spatialData) {
        this.time = time;
        this.spatialData = spatialData;
    }

    public SpatialNode(SpatialNode other) {
        this.time = other.time;
        this.spatialData = new SpatialData(other.spatialData);
        this.parent = other.parent != null ? new SpatialNode(other.parent) : null;
        this.validity = other.validity;
        if (other.configuration != null) {
            this.configuration = new KinematicsToolboxOutputStatus(other.configuration);
        }
    }

    public void initializeSpatialData() {
        this.spatialData.initializeData();
    }

    public double getTimeGap(SpatialNode other) {
        if (this.getTime() > other.getTime()) {
            return Double.MAX_VALUE;
        }
        return other.getTime() - this.getTime();
    }

    public double getPositionDistance(SpatialNode other) {
        return this.spatialData.getPositionDistance(other.getSpatialData());
    }

    public double getOrientationDistance(SpatialNode other) {
        return this.spatialData.getOrientationDistance(other.getSpatialData());
    }

    public double computeDistance(double timeWeight, double positionWeight, double orientationWeight, SpatialNode other) {
        double timeDistance = timeWeight * this.getTimeGap(other);
        double positionDistance = positionWeight * this.getPositionDistance(other);
        double orientationDistance = orientationWeight * this.getOrientationDistance(other);
        double distance = timeDistance + positionDistance + orientationDistance;
        return distance;
    }

    public double computeDistanceWithinMaxDistance(double timeWeight, double positionWeight, double orientationWeight, SpatialNode other, double maxTimeInterval, double maxPositionDistance, double maxOrientationDistance) {
        double timeDistance = timeWeight * this.getTimeGap(other);
        double positionDistance = positionWeight * this.getPositionDistance(other);
        double orientationDistance = orientationWeight * this.getOrientationDistance(other);
        double greatestPositionDistance = this.spatialData.getMaximumPositionDistance(other.getSpatialData());
        double greatestOrientationDistance = this.spatialData.getMaximumOrientationDistance(other.getSpatialData());
        if (greatestPositionDistance / this.getTimeGap(other) > maxPositionDistance / maxTimeInterval) {
            return Double.MAX_VALUE;
        }
        if (greatestOrientationDistance / this.getTimeGap(other) > maxOrientationDistance / maxTimeInterval) {
            return Double.MAX_VALUE;
        }
        double distance = timeDistance + positionDistance + orientationDistance;
        return distance;
    }

    public void interpolate(SpatialNode nodeOne, SpatialNode nodeTwo, double alpha) {
        this.time = EuclidCoreTools.interpolate((double)nodeOne.time, (double)nodeTwo.time, (double)alpha);
        this.spatialData.interpolate(nodeOne.getSpatialData(), nodeTwo.getSpatialData(), alpha);
    }

    public SpatialNode createNodeWithinMaxDistance(double maxTimeInterval, double maxPositionDistance, double maxOrientationDistance, SpatialNode query) {
        double alpha = 1.0;
        double timeGap = this.getTimeGap(query);
        double greatestPositionDistance = this.spatialData.getMaximumPositionDistance(query.getSpatialData());
        double greatestOrientationDistance = this.spatialData.getMaximumOrientationDistance(query.getSpatialData());
        if (timeGap > maxTimeInterval) {
            alpha = Math.min(alpha, maxTimeInterval / timeGap);
        }
        if (greatestPositionDistance > maxPositionDistance) {
            alpha = Math.min(alpha, maxPositionDistance / greatestPositionDistance);
        }
        if (greatestOrientationDistance > maxOrientationDistance) {
            alpha = Math.min(alpha, maxOrientationDistance / greatestOrientationDistance);
        }
        if (alpha >= 1.0) {
            return new SpatialNode(query);
        }
        if (alpha <= 0.0) {
            return new SpatialNode(this);
        }
        SpatialNode spatialNode = new SpatialNode(this);
        spatialNode.interpolate(this, query, alpha);
        return spatialNode;
    }

    public SpatialNode createNodeWithinTimeStep(double maxTimeInterval, SpatialNode query) {
        SpatialNode spatialNode = new SpatialNode(this);
        double alpha = 1.0;
        double timeGap = this.getTimeGap(query);
        if (timeGap > maxTimeInterval) {
            alpha = Math.min(alpha, maxTimeInterval / timeGap);
        }
        spatialNode.interpolate(this, query, alpha);
        return spatialNode;
    }

    public double getConfigurationData(int index) {
        return this.spatialData.getConfigurationData().get(index);
    }

    public String getConfigurationName(int index) {
        return this.spatialData.getConfigurationNames().get(index);
    }

    public SpatialData getSpatialData() {
        return this.spatialData;
    }

    public void setParent(SpatialNode parent) {
        this.parent = parent;
    }

    public void clearParent() {
        this.parent = null;
    }

    public SpatialNode getParent() {
        return this.parent;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public double getTime() {
        return this.time;
    }

    public void setConfiguration(KinematicsToolboxOutputStatus configuration) {
        this.configuration = new KinematicsToolboxOutputStatus(configuration);
    }

    public KinematicsToolboxOutputStatus getConfiguration() {
        return this.configuration;
    }

    public void setValidity(boolean validity) {
        this.validity = validity;
    }

    public boolean isValid() {
        return this.validity;
    }

    public int getSize() {
        return this.spatialData.getRigidBodyNames().size();
    }

    public String getName(int index) {
        return this.spatialData.getRigidBodyNames().get(index);
    }

    public Pose3D getSpatialData(int index) {
        return this.spatialData.getRigidBodySpatials().get(index);
    }

    public Pose3D getSpatialData(RigidBodyBasics rigidBody) {
        for (int i = 0; i < this.spatialData.getRigidBodyNames().size(); ++i) {
            if (!this.spatialData.getRigidBodyNames().get(i).equals(rigidBody.getName())) continue;
            return this.getSpatialData(i);
        }
        return null;
    }

    public void setSpatialsAndConfiguration(SpatialNode other) {
        this.time = other.time;
        this.spatialData = new SpatialData(other.getSpatialData());
        this.configuration = new KinematicsToolboxOutputStatus(other.configuration);
        this.validity = other.validity;
    }
}

