/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.manipulation.planning.exploringSpatial;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.robotics.geometry.AngleTools;

public class SpatialData {
    private static boolean VERBOSE = true;
    private final List<String> rigidBodyNames = new ArrayList<String>();
    private final List<Pose3D> rigidBodySpatials = new ArrayList<Pose3D>();
    private final List<String> configurationNames = new ArrayList<String>();
    private final List<Double> configurationData = new ArrayList<Double>();

    public SpatialData() {
    }

    public SpatialData(SpatialData other) {
        this();
        for (int i = 0; i < other.getRigidBodySpatials().size(); ++i) {
            this.rigidBodySpatials.add(new Pose3D((Pose3DReadOnly)other.getRigidBodySpatials().get(i)));
        }
        this.rigidBodyNames.addAll(other.getRigidBodyNames());
        this.configurationNames.addAll(other.getConfigurationNames());
        this.configurationData.addAll(other.getConfigurationData());
    }

    public void initializeData() {
        int i;
        for (i = 0; i < this.configurationData.size(); ++i) {
            this.configurationData.set(i, 0.0);
        }
        for (i = 0; i < this.rigidBodySpatials.size(); ++i) {
            this.rigidBodySpatials.set(i, new Pose3D());
        }
    }

    public void appendSpatial(String rigidBodyName, String[] configurationNames, double[] configurationData, RigidBodyTransform pose) {
        int i;
        this.rigidBodyNames.add(rigidBodyName);
        this.rigidBodySpatials.add(new Pose3D((RigidBodyTransformReadOnly)pose));
        for (i = 0; i < configurationNames.length; ++i) {
            this.configurationNames.add(configurationNames[i]);
        }
        for (i = 0; i < configurationData.length; ++i) {
            this.configurationData.add(configurationData[i]);
        }
    }

    public void interpolate(SpatialData dataOne, SpatialData dataTwo, double alpha) {
        int i;
        for (i = 0; i < this.rigidBodySpatials.size(); ++i) {
            this.rigidBodySpatials.get(i).interpolate((Pose3DReadOnly)dataOne.getRigidBodySpatials().get(i), (Pose3DReadOnly)dataTwo.getRigidBodySpatials().get(i), alpha);
        }
        for (i = 0; i < this.configurationData.size(); ++i) {
            double double1 = dataOne.getConfigurationData().get(i);
            double double2 = dataTwo.getConfigurationData().get(i);
            double doubleInterpolate = double1 + (double2 - double1) * alpha;
            this.configurationData.remove(i);
            this.configurationData.add(i, doubleInterpolate);
        }
    }

    public double getPositionDistance(SpatialData other) {
        double distance = 0.0;
        for (int i = 0; i < this.rigidBodySpatials.size(); ++i) {
            if (this.rigidBodyNames.get(i) != other.getRigidBodyNames().get(i)) {
                PrintTools.warn((String)"other spatial data has different order");
            }
            distance += this.rigidBodySpatials.get(i).getPosition().distance((Point3DReadOnly)other.getRigidBodySpatials().get(i).getPosition());
        }
        return distance;
    }

    public double getOrientationDistance(SpatialData other) {
        double distance = 0.0;
        for (int i = 0; i < this.rigidBodySpatials.size(); ++i) {
            double orientationDistance = this.rigidBodySpatials.get(i).getOrientation().equals((Tuple4DReadOnly)other.getRigidBodySpatials().get(i).getOrientation()) ? 0.0 : this.rigidBodySpatials.get(i).getOrientation().distance((QuaternionReadOnly)other.getRigidBodySpatials().get(i).getOrientation());
            orientationDistance = AngleTools.trimAngleMinusPiToPi((double)orientationDistance);
            orientationDistance = Math.abs(orientationDistance);
            distance += orientationDistance;
        }
        return distance;
    }

    public double getMaximumPositionDistance(SpatialData other) {
        double distance = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.rigidBodySpatials.size(); ++i) {
            double positionDistance = this.rigidBodySpatials.get(i).getPosition().distance((Point3DReadOnly)other.getRigidBodySpatials().get(i).getPosition());
            if (!(distance < positionDistance)) continue;
            distance = positionDistance;
        }
        return distance;
    }

    public double getMaximumOrientationDistance(SpatialData other) {
        double distance = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.rigidBodySpatials.size(); ++i) {
            double orientationDistance = this.rigidBodySpatials.get(i).getOrientation().distance((QuaternionReadOnly)other.getRigidBodySpatials().get(i).getOrientation());
            orientationDistance = AngleTools.trimAngleMinusPiToPi((double)orientationDistance);
            if (!(distance < (orientationDistance = Math.abs(orientationDistance)))) continue;
            distance = orientationDistance;
        }
        return distance;
    }

    public List<String> getRigidBodyNames() {
        return this.rigidBodyNames;
    }

    public List<Pose3D> getRigidBodySpatials() {
        return this.rigidBodySpatials;
    }

    public List<String> getConfigurationNames() {
        return this.configurationNames;
    }

    public List<Double> getConfigurationData() {
        return this.configurationData;
    }
}

