/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERayCastOpacity;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;

public class JMERayCollisionAdapter {
    private static final boolean DEBUG = false;
    private Collidable collidable;
    private CollisionResults results = new CollisionResults();
    private Node rootNode;

    public JMERayCollisionAdapter(Node rootNode) {
        this.rootNode = rootNode;
    }

    public double getPickDistance() {
        return this.getPickDistance(this.rootNode);
    }

    public Node cloneRootNode() {
        return this.rootNode.clone(false);
    }

    public double getPickDistance(Node rootNode) {
        return this.getPickDistance(rootNode, null, null);
    }

    public double getPickDistance(Node rootNode, Vector3DBasics normalToPack, Point3DBasics closestPoint) {
        this.results.clear();
        rootNode.collideWith(this.collidable, this.results);
        for (CollisionResult collisionResult : this.results) {
            Geometry geometry = collisionResult.getGeometry();
            String userDataRayCastOpacity = JMERayCollisionAdapter.searchForUserData(geometry.getParent(), "RayCastOpacity");
            if (!JMERayCastOpacity.OPAQUE.toString().equals(userDataRayCastOpacity)) continue;
            if (normalToPack != null) {
                this.packInSCSCoordinates(collisionResult.getContactNormal(), (Tuple3DBasics)normalToPack);
            }
            if (closestPoint != null) {
                this.packInSCSCoordinates(collisionResult.getContactPoint(), (Tuple3DBasics)closestPoint);
            }
            return collisionResult.getDistance();
        }
        return Double.NaN;
    }

    private static String searchForUserData(Node startingNode, String userDataToSearch) {
        Node node = startingNode;
        do {
            String userData;
            if ((userData = (String)node.getUserData(userDataToSearch)) == null) continue;
            return userData;
        } while ((node = node.getParent()) != null);
        return null;
    }

    private void packInSCSCoordinates(Vector3f vector3f, Tuple3DBasics tuple3d) {
        JMEGeometryUtils.transformFromJMECoordinatesToZup(vector3f);
        JMEDataTypeUtils.packJMEVector3fInVecMathTuple3d(vector3f, tuple3d);
    }

    public void setPickingGeometry(Line3DReadOnly ray3d) {
        Point3DReadOnly rayOrigin = ray3d.getPoint();
        UnitVector3DReadOnly rayDirection = ray3d.getDirection();
        Vector3f rayOrigin3f = new Vector3f();
        Vector3f rayDirection3f = new Vector3f();
        JMEDataTypeUtils.packVecMathTuple3dInJMEVector3f((Tuple3DReadOnly)rayOrigin, rayOrigin3f);
        JMEDataTypeUtils.packVecMathTuple3dInJMEVector3f((Tuple3DReadOnly)rayDirection, rayDirection3f);
        JMEGeometryUtils.transformFromZupToJMECoordinates(rayOrigin3f);
        JMEGeometryUtils.transformFromZupToJMECoordinates(rayDirection3f);
        Ray jmeRay = new Ray(rayOrigin3f, rayDirection3f);
        this.collidable = jmeRay;
    }
}

