/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.tralala;

import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import us.ihmc.jMonkeyEngineToolkit.tralala.Utilities;

public final class MeshData {
    private float[] vertexArray;
    private float[] normalArray;
    private float[][] uvArrays;
    private short[] indexArray;
    private float[] boneWeightArray;
    private byte[] boneIndexArray;
    private int maxNumOfWeights;
    public static final int MAX_TEX_COORDS = 8;

    private MeshData() {
    }

    public MeshData(float[] vertexArray, float[] normalArray, float[] uvArray, short[] indexArray) {
        this.vertexArray = vertexArray;
        this.normalArray = normalArray;
        this.uvArrays = new float[1][];
        this.uvArrays[0] = uvArray;
        this.indexArray = indexArray;
    }

    public MeshData(float[] vertexArray, float[] normalArray, float[][] uvArrays, short[] indexArray, float[] boneWeightArray, byte[] boneIndexArray, int maxNumOfWeights) {
        this.maxNumOfWeights = maxNumOfWeights;
        this.vertexArray = vertexArray;
        this.normalArray = normalArray;
        this.uvArrays = new float[uvArrays.length][];
        for (int t = 0; t < uvArrays.length; ++t) {
            this.uvArrays[t] = uvArrays[t];
        }
        this.indexArray = indexArray;
        this.boneWeightArray = boneWeightArray;
        this.boneIndexArray = boneIndexArray;
    }

    public MeshData(Mesh mesh) {
        int i;
        this.maxNumOfWeights = mesh.getMaxNumWeights();
        this.vertexArray = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(VertexBuffer.Type.Position));
        this.normalArray = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(VertexBuffer.Type.Normal));
        int numOfTexcoordinates = 0;
        for (i = 0; i < 8; ++i) {
            if (mesh.getBuffer(Utilities.getTexCoordType(i)) == null) continue;
            ++numOfTexcoordinates;
        }
        this.uvArrays = new float[numOfTexcoordinates][];
        for (i = 0; i < numOfTexcoordinates; ++i) {
            this.uvArrays[i] = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(Utilities.getTexCoordType(i)));
        }
        this.indexArray = Utilities.getShortArray(mesh.getShortBuffer(VertexBuffer.Type.Index));
        this.boneWeightArray = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight));
        VertexBuffer boneIndexBuffer = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        if (boneIndexBuffer != null) {
            this.boneIndexArray = Utilities.getByteArray((ByteBuffer)boneIndexBuffer.getData());
        }
    }

    public MeshData merge(MeshData mesh2) {
        int i;
        MeshData mesh1 = this;
        MeshData resultMesh = new MeshData();
        resultMesh.vertexArray = Utilities.merge(mesh1.vertexArray, mesh2.vertexArray);
        resultMesh.normalArray = Utilities.merge(mesh1.normalArray, mesh2.normalArray);
        resultMesh.uvArrays = new float[mesh1.uvArrays.length][];
        for (i = 0; i < mesh1.uvArrays.length; ++i) {
            resultMesh.uvArrays[i] = Utilities.merge(mesh1.uvArrays[i], mesh2.uvArrays[i]);
        }
        resultMesh.indexArray = new short[mesh1.indexArray.length + mesh2.indexArray.length];
        System.arraycopy(mesh1.indexArray, 0, resultMesh.indexArray, 0, mesh1.indexArray.length);
        for (i = 0; i < mesh2.indexArray.length; ++i) {
            resultMesh.indexArray[mesh1.indexArray.length + i] = (short)(mesh2.indexArray[i] + mesh1.getNumberOfVertexElements());
        }
        resultMesh.boneWeightArray = mesh1.boneWeightArray;
        resultMesh.boneIndexArray = mesh1.boneIndexArray;
        return resultMesh;
    }

    public MeshData mirror(Vector3f planeOrigin, Vector3f planeNormal) {
        int i;
        MeshData mesh = this;
        MeshData resultMesh = mesh.shallowClone();
        resultMesh.vertexArray = new float[mesh.vertexArray.length];
        resultMesh.normalArray = new float[mesh.normalArray.length];
        for (i = 0; i < mesh.getNumberOfVertexElements(); ++i) {
            Vector3f position = mesh.getVertex(i);
            Vector3f summetricPosition = Utilities.getSummetricPosition(position, planeOrigin, planeNormal);
            resultMesh.setVertex(summetricPosition, i);
        }
        for (i = 0; i < mesh.getNumberOfNormalElements(); ++i) {
            Vector3f normalPosition = mesh.getNormal(i);
            Vector3f summetricNormalPosition = Utilities.getSummetricPosition(normalPosition, planeOrigin, planeNormal);
            resultMesh.setNormal(summetricNormalPosition, i);
        }
        resultMesh = resultMesh.flipIndexes();
        return resultMesh;
    }

    public MeshData createSymmetricMesh(Vector3f planeOrigin, Vector3f planeNormal, float weldThreshold) {
        MeshData mesh = this.shallowClone();
        MeshData mirrorMesh = mesh.mirror(planeOrigin, planeNormal);
        float[] weldedMeshVertexArray = new float[mesh.vertexArray.length];
        float[] weldedMirrorMeshVertexArray = new float[mirrorMesh.vertexArray.length];
        float[] weldedMeshNormalArray = new float[mesh.normalArray.length];
        float[] weldedMirrorMeshNormalArray = new float[mirrorMesh.normalArray.length];
        for (int i = 0; i < mesh.getNumberOfIndexElements(); ++i) {
            short index = mesh.getIndex(i);
            Vector3f p1 = mesh.getVertex(index);
            Vector3f mp1 = mirrorMesh.getVertex(index);
            Vector3f n1 = mesh.getNormal(index);
            Vector3f mn1 = mirrorMesh.getNormal(index);
            if (Utilities.getDistanceOfPointFromPlane(p1, planeOrigin, planeNormal) <= weldThreshold) {
                p1 = p1.clone().interpolateLocal(mp1, 0.5f);
                n1 = n1.clone().interpolateLocal(mn1, 0.5f);
                mp1 = p1;
                mn1 = n1;
            }
            Utilities.setInArray(p1, weldedMeshVertexArray, (int)index);
            Utilities.setInArray(mp1, weldedMirrorMeshVertexArray, (int)index);
            Utilities.setInArray(n1, weldedMeshNormalArray, (int)index);
            Utilities.setInArray(mn1, weldedMirrorMeshNormalArray, (int)index);
        }
        mesh.vertexArray = weldedMeshVertexArray;
        mesh.normalArray = weldedMeshNormalArray;
        mirrorMesh.vertexArray = weldedMirrorMeshVertexArray;
        mirrorMesh.normalArray = weldedMirrorMeshNormalArray;
        MeshData resultMesh = mesh.merge(mirrorMesh);
        return resultMesh;
    }

    public MeshData scale(Vector3f size) {
        return this.scale(size, this.getCenter());
    }

    public MeshData scale(Vector3f size, Vector3f pivot) {
        MeshData returned = this.shallowClone();
        float[] vertex = returned.getVertexArrayCopy();
        for (int i = 0; i < returned.getNumberOfVertexElements(); ++i) {
            Vector3f v = returned.getVertex(i);
            Utilities.setInArray(new Vector3f((v.x - pivot.x) * size.x + pivot.x, (v.y - pivot.y) * size.y + pivot.y, (v.z - pivot.z) * size.z + pivot.z), vertex, i);
        }
        returned.vertexArray = vertex;
        return returned;
    }

    public MeshData translate(Vector3f translate) {
        MeshData returned = this.shallowClone();
        float[] vertex = returned.getVertexArrayCopy();
        for (int i = 0; i < returned.getNumberOfVertexElements(); ++i) {
            Vector3f v = returned.getVertex(i);
            Utilities.setInArray(v.add(translate), vertex, i);
        }
        returned.vertexArray = vertex;
        return returned;
    }

    public void getBounds(Vector3f min, Vector3f max) {
        for (int i = 0; i < this.getNumberOfVertexElements(); ++i) {
            Vector3f v = this.getVertex(i);
            if (v.x < min.x) {
                min.x = v.x;
            }
            if (v.y < min.y) {
                min.y = v.y;
            }
            if (v.z < min.z) {
                min.z = v.z;
            }
            if (v.x > max.x) {
                max.x = v.x;
            }
            if (v.y > max.y) {
                max.y = v.y;
            }
            if (!(v.z > max.z)) continue;
            max.z = v.z;
        }
    }

    public Vector3f getCenter() {
        Vector3f min = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vector3f max = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.getBounds(min, max);
        return min.addLocal(max.subtractLocal(min).divideLocal(2.0f));
    }

    public MeshData flipIndexes() {
        MeshData mesh = this;
        MeshData result = mesh.shallowClone();
        result.indexArray = new short[mesh.indexArray.length];
        for (int i = 0; i < mesh.indexArray.length; i += 3) {
            result.indexArray[i] = mesh.indexArray[i + 2];
            result.indexArray[i + 1] = mesh.indexArray[i + 1];
            result.indexArray[i + 2] = mesh.indexArray[i];
        }
        return result;
    }

    public MeshData flipU(int TexCoordNumber) {
        MeshData mesh = this;
        MeshData result = mesh.shallowClone();
        result.uvArrays[TexCoordNumber] = new float[mesh.uvArrays[TexCoordNumber].length];
        for (int i = 0; i < mesh.uvArrays[TexCoordNumber].length; i += 2) {
            result.uvArrays[TexCoordNumber][i] = (1.0f - mesh.uvArrays[TexCoordNumber][i]) % 1.0f;
            result.uvArrays[TexCoordNumber][i + 1] = mesh.uvArrays[TexCoordNumber][i + 1] % 1.0f;
        }
        return result;
    }

    public MeshData flipV(int TexCoordNumber) {
        MeshData mesh = this;
        MeshData result = mesh.shallowClone();
        result.uvArrays[TexCoordNumber] = new float[mesh.uvArrays[TexCoordNumber].length];
        for (int i = 0; i < mesh.uvArrays[TexCoordNumber].length; i += 2) {
            result.uvArrays[TexCoordNumber][i] = mesh.uvArrays[TexCoordNumber][i] % 1.0f;
            result.uvArrays[TexCoordNumber][i + 1] = (1.0f - mesh.uvArrays[TexCoordNumber][i + 1]) % 1.0f;
        }
        return result;
    }

    public MeshData moveUV(Vector2f uvMoveOffset, int TexCoordNumber) {
        MeshData mesh = this;
        MeshData result = mesh.shallowClone();
        result.uvArrays[TexCoordNumber] = new float[mesh.uvArrays[TexCoordNumber].length];
        for (int i = 0; i < mesh.uvArrays[TexCoordNumber].length; i += 2) {
            result.uvArrays[TexCoordNumber][i] = (mesh.uvArrays[TexCoordNumber][i] + uvMoveOffset.x) % 1.0f;
            result.uvArrays[TexCoordNumber][i + 1] = (mesh.uvArrays[TexCoordNumber][i + 1] + uvMoveOffset.y) % 1.0f;
        }
        return result;
    }

    public MeshData rotateUV(float uvRotateAngle, int TexCoordNumber) {
        MeshData mesh = this;
        MeshData result = mesh.shallowClone();
        result.uvArrays[TexCoordNumber] = new float[mesh.uvArrays[TexCoordNumber].length];
        for (int i = 0; i < mesh.uvArrays[TexCoordNumber].length; i += 2) {
            result.uvArrays[TexCoordNumber][i] = (mesh.uvArrays[TexCoordNumber][i] * FastMath.cos((float)uvRotateAngle) - mesh.uvArrays[TexCoordNumber][i + 1] * FastMath.sin((float)uvRotateAngle)) % 1.0f;
            result.uvArrays[TexCoordNumber][i + 1] = (mesh.uvArrays[TexCoordNumber][i] * FastMath.sin((float)uvRotateAngle) + mesh.uvArrays[TexCoordNumber][i + 1] * FastMath.cos((float)uvRotateAngle)) % 1.0f;
        }
        return result;
    }

    public MeshData scaleUV(Vector2f uvScaleAmount, int TexCoordNumber) {
        MeshData mesh = this;
        MeshData result = mesh.shallowClone();
        result.uvArrays[TexCoordNumber] = new float[mesh.uvArrays[TexCoordNumber].length];
        for (int i = 0; i < mesh.uvArrays[TexCoordNumber].length; i += 2) {
            result.uvArrays[TexCoordNumber][i] = mesh.uvArrays[TexCoordNumber][i] * uvScaleAmount.x % 1.0f;
            result.uvArrays[TexCoordNumber][i + 1] = mesh.uvArrays[TexCoordNumber][i + 1] * uvScaleAmount.y % 1.0f;
        }
        return result;
    }

    public MeshData switchUV(int TexCoordNumber) {
        MeshData mesh = this;
        MeshData result = mesh.shallowClone();
        result.uvArrays[TexCoordNumber] = new float[mesh.uvArrays[TexCoordNumber].length];
        for (int i = 0; i < mesh.uvArrays[TexCoordNumber].length; i += 2) {
            result.uvArrays[TexCoordNumber][i] = result.uvArrays[TexCoordNumber][i + 1];
            result.uvArrays[TexCoordNumber][i + 1] = result.uvArrays[TexCoordNumber][i];
        }
        return result;
    }

    public Mesh save(Mesh mesh) {
        VertexBuffer vb;
        if (this.vertexArray != null) {
            vb = mesh.getBuffer(VertexBuffer.Type.Position);
            if (vb != null) {
                vb.updateData((Buffer)BufferUtils.createFloatBuffer((float[])this.vertexArray));
            } else {
                mesh.setBuffer(VertexBuffer.Type.Position, 3, this.vertexArray);
            }
        }
        if (this.normalArray != null) {
            vb = mesh.getBuffer(VertexBuffer.Type.Normal);
            if (vb != null) {
                vb.updateData((Buffer)BufferUtils.createFloatBuffer((float[])this.normalArray));
            } else {
                mesh.setBuffer(VertexBuffer.Type.Normal, 3, this.normalArray);
            }
        }
        for (int i = 0; i < this.uvArrays.length; ++i) {
            if (this.uvArrays[i] == null) continue;
            VertexBuffer vb2 = mesh.getBuffer(Utilities.getTexCoordType(i));
            if (vb2 != null) {
                vb2.updateData((Buffer)BufferUtils.createFloatBuffer((float[])this.uvArrays[i]));
                continue;
            }
            mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, this.uvArrays[i]);
        }
        if (this.indexArray != null) {
            VertexBuffer vb3 = mesh.getBuffer(VertexBuffer.Type.Index);
            if (vb3 != null) {
                vb3.updateData((Buffer)BufferUtils.createShortBuffer((short[])this.indexArray));
            } else {
                mesh.setBuffer(VertexBuffer.Type.Index, 3, this.indexArray);
            }
        }
        if (this.boneIndexArray != null && this.boneWeightArray != null) {
            FloatBuffer weights = FloatBuffer.allocate(mesh.getVertexCount() * 4);
            VertexBuffer weightsBuf = new VertexBuffer(VertexBuffer.Type.BoneWeight);
            weightsBuf.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.Float, (Buffer)weights);
            mesh.setBuffer(weightsBuf);
            ByteBuffer indices = ByteBuffer.allocate(mesh.getVertexCount() * 4);
            VertexBuffer indicesBuf = new VertexBuffer(VertexBuffer.Type.BoneIndex);
            indicesBuf.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.UnsignedByte, (Buffer)indices);
            mesh.setBuffer(indicesBuf);
            VertexBuffer bindPos = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
            bindPos.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((float[])this.vertexArray));
            mesh.setBuffer(bindPos);
            VertexBuffer bindNorm = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
            bindNorm.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((float[])this.normalArray));
            mesh.setBuffer(bindNorm);
            for (int i = 0; i < mesh.getVertexCount() * 4; i += 4) {
                indices.array()[i + 0] = this.boneIndexArray[i];
                indices.array()[i + 1] = this.boneIndexArray[i + 1];
                indices.array()[i + 2] = this.boneIndexArray[i + 2];
                indices.array()[i + 3] = this.boneIndexArray[i + 3];
                weights.array()[i + 0] = this.boneWeightArray[i];
                weights.array()[i + 1] = this.boneWeightArray[i + 1];
                weights.array()[i + 2] = this.boneWeightArray[i + 2];
                weights.array()[i + 3] = this.boneWeightArray[i + 3];
            }
        }
        if (this.vertexArray != null) {
            mesh.updateBound();
        }
        return mesh;
    }

    public MeshData removeDuplicateData() {
        int i;
        short[] returnedIndexArray = this.getIndexArrayCopy();
        ArrayList<Vector3f> vertex = new ArrayList<Vector3f>();
        for (i = 0; i < this.getNumberOfVertexElements(); ++i) {
            vertex.add(this.getVertex(i));
        }
        for (i = 0; i < this.getNumberOfVertexElements(); ++i) {
            Vector3f vi = (Vector3f)vertex.get(i);
            for (int j = i + 1; j < this.getNumberOfVertexElements(); ++j) {
                Vector3f vj = (Vector3f)vertex.get(j);
                if (!vi.equals((Object)vj) || !this.getNormal(i).equals((Object)this.getNormal(j)) || !this.getUv(i).equals((Object)this.getUv(j))) continue;
                returnedIndexArray[j] = (short)i;
            }
        }
        MeshData returned = this.shallowClone();
        returned.indexArray = returnedIndexArray;
        returned = returned.compress();
        return returned;
    }

    public MeshData compress() {
        MeshData mesh = this;
        int[] numOfUnusedElements = new int[mesh.getNumberOfVertexElements()];
        Arrays.fill(numOfUnusedElements, -1);
        for (int i = 0; i < mesh.getNumberOfIndexElements(); ++i) {
            numOfUnusedElements[mesh.getIndex((int)i)] = 0;
        }
        int numOfUsed = 0;
        int numOfUnused = 0;
        for (int i = 0; i < numOfUnusedElements.length; ++i) {
            if (numOfUnusedElements[i] == -1) {
                ++numOfUnused;
                continue;
            }
            ++numOfUsed;
            numOfUnusedElements[i] = numOfUnused;
        }
        int m = 0;
        float[] compressedVertexArray = new float[numOfUsed * 3];
        float[] compressedNormalArray = new float[numOfUsed * 3];
        float[][] compressedUvArray = new float[mesh.uvArrays.length][];
        for (int t = 0; t < compressedUvArray.length; ++t) {
            compressedUvArray[t] = new float[numOfUsed * 2];
        }
        for (int i = 0; i < numOfUnusedElements.length; ++i) {
            if (numOfUnusedElements[i] == -1) continue;
            compressedVertexArray[m * 3] = mesh.vertexArray[i * 3];
            compressedVertexArray[m * 3 + 1] = mesh.vertexArray[i * 3 + 1];
            compressedVertexArray[m * 3 + 2] = mesh.vertexArray[i * 3 + 2];
            compressedNormalArray[m * 3] = mesh.normalArray[i * 3];
            compressedNormalArray[m * 3 + 1] = mesh.normalArray[i * 3 + 1];
            compressedNormalArray[m * 3 + 2] = mesh.normalArray[i * 3 + 2];
            for (int t = 0; t < compressedUvArray.length; ++t) {
                compressedUvArray[t][m * 2] = mesh.uvArrays[t][i * 2];
                compressedUvArray[t][m * 2 + 1] = mesh.uvArrays[t][i * 2 + 1];
            }
            ++m;
        }
        short[] compressedIndexArray = new short[mesh.indexArray.length];
        for (int i = 0; i < mesh.indexArray.length; ++i) {
            compressedIndexArray[i] = (short)(mesh.indexArray[i] - numOfUnusedElements[mesh.indexArray[i]]);
        }
        return new MeshData(compressedVertexArray, compressedNormalArray, compressedUvArray, compressedIndexArray, mesh.boneWeightArray, mesh.boneIndexArray, mesh.maxNumOfWeights);
    }

    public LinkedHashSet<Short> getAdjacentIndices(short index) {
        MeshData mesh = this;
        LinkedHashSet<Short> otherIndexes = new LinkedHashSet<Short>();
        for (int i = 0; i < mesh.indexArray.length; i += 3) {
            if (index == mesh.indexArray[i]) {
                otherIndexes.add(mesh.indexArray[i + 1]);
                otherIndexes.add(mesh.indexArray[i + 2]);
            }
            if (index == mesh.indexArray[i + 1]) {
                otherIndexes.add(mesh.indexArray[i]);
                otherIndexes.add(mesh.indexArray[i + 2]);
            }
            if (index != mesh.indexArray[i + 2]) continue;
            otherIndexes.add(mesh.indexArray[i]);
            otherIndexes.add(mesh.indexArray[i + 1]);
        }
        return otherIndexes;
    }

    public Mesh createMesh() {
        Mesh mesh = new Mesh();
        return this.save(mesh);
    }

    private MeshData shallowClone() {
        return new MeshData(this.vertexArray, this.normalArray, this.uvArrays, this.indexArray, this.boneWeightArray, this.boneIndexArray, this.maxNumOfWeights);
    }

    public MeshData setIndexArray(short[] indexArray) {
        MeshData mesh = this.shallowClone();
        mesh.indexArray = indexArray;
        return mesh;
    }

    public MeshData setNormalArray(float[] normalArray) {
        MeshData mesh = this.shallowClone();
        mesh.normalArray = normalArray;
        return mesh;
    }

    public MeshData setUvArray(float[] uvArray, int TexCoordNumber) {
        MeshData mesh = this.shallowClone();
        mesh.uvArrays[TexCoordNumber] = uvArray;
        return mesh;
    }

    public MeshData setVertexArray(float[] vertexArray) {
        MeshData mesh = this.shallowClone();
        mesh.vertexArray = vertexArray;
        return mesh;
    }

    public MeshData setBoneWeightArray(float[] boneWeightArray) {
        MeshData mesh = this.shallowClone();
        mesh.boneWeightArray = boneWeightArray;
        return mesh;
    }

    public MeshData setBoneIndexArray(byte[] boneIndexArray) {
        MeshData mesh = this.shallowClone();
        mesh.boneIndexArray = boneIndexArray;
        return mesh;
    }

    public Vector3f getVertex(int i) {
        return Utilities.getVector3FromArray(this.vertexArray, i);
    }

    public Vector3f getNormal(int i) {
        return Utilities.getVector3FromArray(this.normalArray, i);
    }

    public Vector2f getUv(int i) {
        return this.getUv(i, 0);
    }

    public Vector2f getUv(int i, int TexCoordNumber) {
        return Utilities.getVector2FromArray(this.uvArrays[TexCoordNumber], i);
    }

    public short getIndex(int i) {
        return this.indexArray[i];
    }

    private void setVertex(Vector3f p, int i) {
        Utilities.setInArray(p, this.vertexArray, i);
    }

    private void setNormal(Vector3f p, int i) {
        Utilities.setInArray(p, this.normalArray, i);
    }

    private void setUv(Vector2f p, int i, int TexCoordNumber) {
        Utilities.setInArray(p, this.uvArrays[TexCoordNumber], i);
    }

    private void setIndex(Short p, int i) {
        this.indexArray[i] = p;
    }

    public int getNumberOfVertexElements() {
        if (this.vertexArray == null) {
            return 0;
        }
        return this.vertexArray.length / 3;
    }

    public int getNumberOfNormalElements() {
        if (this.normalArray == null) {
            return 0;
        }
        return this.normalArray.length / 3;
    }

    public int getNumberOfUvElements(int TexCoordNumber) {
        if (this.uvArrays[TexCoordNumber] == null) {
            return 0;
        }
        return this.uvArrays[TexCoordNumber].length / 2;
    }

    public int getNumberOfIndexElements() {
        if (this.indexArray == null) {
            return 0;
        }
        return this.indexArray.length;
    }

    public float[] getVertexArrayCopy() {
        if (this.vertexArray == null) {
            return null;
        }
        return (float[])this.vertexArray.clone();
    }

    public float[] getNormalArrayCopy() {
        if (this.normalArray == null) {
            return null;
        }
        return (float[])this.normalArray.clone();
    }

    public float[] getUvArrayCopy(int TexCoordNumber) {
        if (this.uvArrays[TexCoordNumber] == null) {
            return null;
        }
        return (float[])this.uvArrays[TexCoordNumber].clone();
    }

    public short[] getIndexArrayCopy() {
        if (this.indexArray == null) {
            return null;
        }
        return (short[])this.indexArray.clone();
    }

    public float[] getBoneWeightArrayCopy() {
        if (this.boneWeightArray == null) {
            return null;
        }
        return (float[])this.boneWeightArray.clone();
    }

    public byte[] getBoneIndexArrayCopy() {
        if (this.boneIndexArray == null) {
            return null;
        }
        return (byte[])this.boneIndexArray.clone();
    }
}

