/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.google.common.collect.HashBiMap;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetConfig;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.audio.AudioContext;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.InputManager;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.awt.AwtKeyInput;
import com.jme3.input.awt.AwtMouseInput;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.TechniqueDef;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.profile.AppStep;
import com.jme3.renderer.opengl.GLRenderer;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.OBJLoader;
import com.jme3.scene.plugins.ogre.MaterialLoader;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import com.jme3.system.NativeLibraryLoader;
import com.jme3.system.SystemListener;
import com.jme3.system.lwjgl.LwjglContext;
import com.jme3.system.lwjgl.LwjglOffscreenBuffer;
import com.jme3.texture.Texture;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.SkyFactory;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import jme3dae.ColladaLoader;
import jme3dae.collada14.ColladaDocumentV14;
import jme3dae.materials.FXBumpMaterialGenerator;
import org.lwjgl.glfw.GLFW;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DSpotLight;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.input.keyboard.KeyListener;
import us.ihmc.graphicsDescription.input.keyboard.KeyListenerHolder;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DInterface;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DListener;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DListenerHolder;
import us.ihmc.graphicsDescription.input.mouse.MouseListener;
import us.ihmc.graphicsDescription.input.mouse.MouseListenerHolder;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.GPULidarListener;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DBackgroundScaleMode;
import us.ihmc.jMonkeyEngineToolkit.Updatable;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.jMonkeyEngineToolkit.input.SelectedListenerHolder;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEContextManager;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.jme.JMESpotLight;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEViewportAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.context.AWTPanelPostRender;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanel;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanelListener;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanelsContext;
import us.ihmc.jMonkeyEngineToolkit.jme.contextManager.AWTPanelsContextManager;
import us.ihmc.jMonkeyEngineToolkit.jme.contextManager.CanvasContextManager;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.JMEGPULidar;
import us.ihmc.jMonkeyEngineToolkit.jme.terrain.JMEHeightMapTerrain;
import us.ihmc.jMonkeyEngineToolkit.jme.util.IHMCMTLLoader;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMENodeTools;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLLoader;
import us.ihmc.log.LogTools;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.tools.thread.CloseableAndDisposableRegistry;

public class JMERenderer
extends SimpleApplication
implements Graphics3DAdapter,
PBOAwtPanelListener {
    private final Logger[] jmeLoggers = new Logger[]{Logger.getLogger(FXBumpMaterialGenerator.class.getName()), Logger.getLogger(ColladaDocumentV14.class.getName()), Logger.getLogger(OBJLoader.class.getName()), Logger.getLogger(GLRenderer.class.getName()), Logger.getLogger(AssetConfig.class.getName()), Logger.getLogger(JmeSystem.class.getName()), Logger.getLogger(LwjglContext.class.getName())};
    public static final SkyboxToUse skyboxToUse = SkyboxToUse.BLUE_SKY;
    public static final boolean USE_PBO = true;
    public static boolean USE_GPU_LIDAR_PARALLEL_SCENE = false;
    public static final boolean DEBUG_GPU_LIDAR_PARALLEL_SCENE = false;
    private final RenderType renderType;
    public static boolean tickUpdated = false;
    private final Object repaintNotifier = new Object();
    private boolean lazyRendering = true;
    private int lazyRendersToPerform = 10;
    private final Object loadingStatus = new Object();
    private final Object graphicsConch = new Object();
    private JMEContextManager contextManager;
    private List<JMEViewportAdapter> viewportAdapters = new ArrayList<JMEViewportAdapter>();
    private HashBiMap<Graphics3DNode, JMEGraphics3DNode> jmeGraphicsNodes = HashBiMap.create();
    private Collection<JMEGraphics3DNode> jmeGraphicsNodesListView = this.jmeGraphicsNodes.values();
    private HashBiMap<Graphics3DSpotLight, JMESpotLight> jmeSpotLights = HashBiMap.create();
    private Collection<JMESpotLight> jmeSpotLightsView = this.jmeSpotLights.values();
    private boolean isTerrainVisible = true;
    private Mouse3DInterface mouse3DJoystick;
    private SelectedListenerHolder selectedListenerHolder = new SelectedListenerHolder();
    private KeyListenerHolder keyListenerHolder = new KeyListenerHolder();
    private MouseListenerHolder mouseListenerHolder = new MouseListenerHolder();
    private Mouse3DListenerHolder mouse3DListenerHolder = new Mouse3DListenerHolder();
    private Node rootJoint;
    private Node terrain;
    private Node zUpNode;
    private List<DirectionalLight> lights = new ArrayList<DirectionalLight>();
    private List<JMEGPULidar> gpuLidars = new ArrayList<JMEGPULidar>();
    private List<PBOAwtPanel> pboAwtPanels;
    private DirectionalLight primaryLight;
    private CloseableAndDisposableRegistry closeableAndDisposableRegistry = new CloseableAndDisposableRegistry();
    private List<Updatable> updatables = new ArrayList<Updatable>();
    private Spatial sky = null;
    private HeightMap heightMap = null;
    private AppearanceDefinition terrainAppearance = null;
    private AWTPanelPostRender canvas = null;
    private AmbientLight ambientLight;
    int count = 0;
    private boolean alreadyClosing = false;

    public JMERenderer(RenderType renderType) {
        this(renderType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMERenderer(RenderType renderType, Mouse3DInterface mouse3dJoystick) {
        this.renderType = renderType;
        this.mouse3DJoystick = mouse3dJoystick;
        this.changeJMELoggerLevelToSevere();
        if (renderType == RenderType.AWTPANELS) {
            this.initializeAWTPanels();
        } else {
            this.initializeCanvas();
        }
        Object object = this.loadingStatus;
        synchronized (object) {
            try {
                this.loadingStatus.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Loading interrupted");
            }
        }
    }

    private void changeJMELoggerLevelToSevere() {
        for (Logger jmeLogger : this.jmeLoggers) {
            jmeLogger.setLevel(Level.SEVERE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRepaint(int rendersToPerform) {
        Object object = this.repaintNotifier;
        synchronized (object) {
            this.lazyRendersToPerform = Math.max(this.lazyRendersToPerform, rendersToPerform * 2);
            this.repaintNotifier.notifyAll();
        }
    }

    private void notifyRepaint() {
        this.notifyRepaint(1);
    }

    @Deprecated
    public Node getRootNode() {
        return super.getRootNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMEGraphics3DNode addNodesRecursively(Graphics3DNode graphics3dNode, Node parentNode) {
        Object object = this.graphicsConch;
        synchronized (object) {
            JMEGraphics3DNode jmeNode = new JMEGraphics3DNode(graphics3dNode, this.getAssetManager(), (Application)this, this.closeableAndDisposableRegistry);
            if (this.rootJoint == null) {
                this.rootJoint = jmeNode;
            }
            Graphics3DNodeType nodeType = graphics3dNode.getNodeType();
            jmeNode.setType(nodeType);
            this.jmeGraphicsNodes.put((Object)graphics3dNode, (Object)jmeNode);
            parentNode.attachChild((Spatial)jmeNode);
            for (Graphics3DNode child : graphics3dNode.getChildrenNodes()) {
                this.addNodesRecursively(child, jmeNode);
            }
            this.notifyRepaint();
            return jmeNode;
        }
    }

    @Override
    public void addRootNode(final Graphics3DNode rootNode) {
        this.enqueue(new Callable<JMEGraphics3DNode>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JMEGraphics3DNode call() throws Exception {
                Object object = JMERenderer.this.graphicsConch;
                synchronized (object) {
                    JMEGraphics3DNode node = JMERenderer.this.addNodesRecursively(rootNode, JMERenderer.this.zUpNode);
                    JMERenderer.this.jmeGraphicsNodes.put((Object)rootNode, (Object)node);
                    return node;
                }
            }
        });
        this.notifyRepaint();
    }

    public void registerViewport(JMEViewportAdapter viewportAdapter) {
        this.viewportAdapters.add(viewportAdapter);
    }

    @Override
    public ViewportAdapter createNewViewport(GraphicsDevice graphicsDevice, boolean isMainViewport, boolean isOffScreen) {
        if (isMainViewport) {
            for (JMEViewportAdapter jmeViewportAdapter : this.viewportAdapters) {
                if (!jmeViewportAdapter.isMainViewport()) continue;
                throw new RuntimeException("Can only have one main viewport");
            }
        }
        JMEViewportAdapter newViewport = new JMEViewportAdapter(this, this.rootNode, isMainViewport, isOffScreen ? JMEViewportAdapter.ViewportType.OFFSCREEN : JMEViewportAdapter.ViewportType.CANVAS, false, Color.LIGHT_GRAY, false);
        this.notifyRepaint();
        return newViewport;
    }

    @Override
    public void closeViewport(ViewportAdapter viewport) {
        ((JMEViewportAdapter)viewport).closeViewportAdapter();
        while (this.viewportAdapters.remove(viewport)) {
        }
        this.notifyRepaint();
    }

    @Override
    public Object getGraphicsConch() {
        return this.graphicsConch;
    }

    public Canvas getCanvas() {
        if (this.renderType != RenderType.CANVAS) {
            throw new RuntimeException("Cannot get canvas if rendertype not is canvas");
        }
        return this.canvas;
    }

    private void initializeCanvas() {
        this.settings = new AppSettings(true);
        this.settings.setWidth(1200);
        this.settings.setHeight(600);
        this.settings.setAudioRenderer(null);
        this.settings.setVSync(true);
        this.settings.setRenderer("LWJGL-OpenGL3");
        this.setPauseOnLostFocus(false);
        Dimension dim = new Dimension(1200, 600);
        this.canvas = new AWTPanelPostRender();
        this.canvas.setPreferredSize(dim);
        this.context = new LwjglOffscreenBuffer(){
            AwtMouseInput awtMouseInput;
            AwtKeyInput awtKeyInput;

            public MouseInput getMouseInput() {
                if (this.awtMouseInput == null) {
                    this.awtMouseInput = new AwtMouseInput();
                    this.awtMouseInput.setInputSource((Component)JMERenderer.this.canvas);
                }
                return this.awtMouseInput;
            }

            public KeyInput getKeyInput() {
                if (this.awtKeyInput == null) {
                    this.awtKeyInput = new AwtKeyInput();
                    this.awtKeyInput.setInputSource((Component)JMERenderer.this.canvas);
                }
                return this.awtKeyInput;
            }
        };
        this.context.setSettings(this.settings);
        this.context.setSystemListener((SystemListener)this);
        this.contextManager = new CanvasContextManager(this);
        this.addRepaintListeners(this.canvas);
        this.context.create(false);
    }

    private void initializeAWTPanels() {
        AppSettings appSettings = new AppSettings(true);
        appSettings.setCustomRenderer(PBOAwtPanelsContext.class);
        appSettings.setAudioRenderer(null);
        appSettings.setFrameRate(30);
        this.setSettings(appSettings);
        this.setShowSettings(false);
        this.setPauseOnLostFocus(false);
        this.contextManager = new AWTPanelsContextManager(this);
        this.start();
        if (this.getContext() instanceof PBOAwtPanelsContext) {
            ((PBOAwtPanelsContext)this.getContext()).addPBOAwtPanelListener(this);
            this.pboAwtPanels = ((PBOAwtPanelsContext)this.getContext()).getPanelList();
        } else {
            LogTools.debug((String)("Context is not of type " + PBOAwtPanelsContext.class.getSimpleName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursivelyRemoveNodesFromMap(Graphics3DNode rootNode) {
        Object object = this.graphicsConch;
        synchronized (object) {
            for (Graphics3DNode child : rootNode.getChildrenNodes()) {
                this.recursivelyRemoveNodesFromMap(child);
            }
            this.jmeGraphicsNodes.remove((Object)rootNode);
        }
    }

    @Override
    public void removeRootNode(final Graphics3DNode rootNode) {
        this.enqueue(new Callable<JMEGraphics3DNode>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JMEGraphics3DNode call() throws Exception {
                Object object = JMERenderer.this.graphicsConch;
                synchronized (object) {
                    JMEGraphics3DNode node = (JMEGraphics3DNode)JMERenderer.this.jmeGraphicsNodes.get((Object)rootNode);
                    if (node != null) {
                        node.removeFromParent();
                        JMERenderer.this.recursivelyRemoveNodesFromMap(rootNode);
                    }
                    JMERenderer.this.notifyRepaint();
                    return node;
                }
            }
        });
    }

    public static void setupAssetManger(AssetManager assetManager) {
        assetManager.registerLoader(IHMCMTLLoader.class, new String[]{"mtl"});
        assetManager.registerLoader(AWTLoader.class, new String[]{"tif"});
        assetManager.registerLoader(ColladaLoader.class, new String[]{"dae"});
        assetManager.registerLoader(STLLoader.class, new String[]{"stl"});
        assetManager.registerLoader(MaterialLoader.class, new String[]{"material"});
    }

    private void disableMainViewport() {
        this.flyCam.setEnabled(false);
        this.flyCam = null;
        this.viewPort.setEnabled(false);
        this.renderManager.removeMainView(this.viewPort);
        this.renderManager.removeMainView(this.guiViewPort);
    }

    public void setAmbientLightBrightness(float brightness) {
        this.ambientLight.setColor(ColorRGBA.White.mult(brightness));
        this.notifyRepaint();
    }

    @Override
    public void setAmbientLight(final Color ambient) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ColorRGBA jmeAmbient = JMEDataTypeUtils.colorToColorRGBA(ambient);
                JMERenderer.this.ambientLight.setColor(jmeAmbient);
                JMERenderer.this.notifyRepaint();
                return null;
            }
        });
    }

    private void setupLighting() {
        Vector3f fromTheTop = new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal();
        Vector3f fromTheFront = new Vector3f(0.0f, 0.0f, -1.0f).normalizeLocal();
        Vector3f fromTheSide = new Vector3f(-1.0f, 0.0f, 0.0f).normalizeLocal();
        Vector3f fromTheBack = new Vector3f(fromTheFront).negate().normalizeLocal();
        Vector3f fromTheOtherSide = new Vector3f(fromTheSide).negate().normalizeLocal();
        Vector3f fromTheBottom = new Vector3f(fromTheTop).negate().normalizeLocal();
        Vector3f fromTheTopFront = fromTheTop.add(fromTheFront).normalizeLocal();
        Vector3f fromTheFrontSide = fromTheFront.add(fromTheSide).normalizeLocal();
        Vector3f fromTheBackOtherSide = fromTheBack.add(fromTheOtherSide).normalizeLocal();
        Vector3f fromTheBackBottom = fromTheBack.add(fromTheBottom).normalizeLocal();
        this.primaryLight = new DirectionalLight();
        this.primaryLight.setColor(ColorRGBA.White.mult(0.5f));
        this.primaryLight.setDirection(fromTheTopFront);
        this.rootNode.addLight((Light)this.primaryLight);
        this.lights.add(this.primaryLight);
        this.ambientLight = new AmbientLight();
        this.ambientLight.setColor(ColorRGBA.White.mult(0.2f));
        this.rootNode.addLight((Light)this.ambientLight);
        this.addDirectionalLight(ColorRGBA.White.mult(0.35f), fromTheFrontSide);
        this.addDirectionalLight(ColorRGBA.White.mult(0.3f), fromTheBackOtherSide);
        this.addDirectionalLight(ColorRGBA.White.mult(0.28f), fromTheBackBottom);
        this.addDirectionalLight(ColorRGBA.White.mult(0.32f), fromTheOtherSide);
        this.addDirectionalLight(ColorRGBA.White.mult(0.35f), fromTheSide);
        this.renderManager.setPreferredLightMode(TechniqueDef.LightMode.SinglePass);
        this.rootNode.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.zUpNode.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
    }

    private void addDirectionalLight(ColorRGBA color, Vector3f direction) {
        if (this.lights.isEmpty()) {
            this.primaryLight.setColor(color);
            this.primaryLight.setDirection(direction);
            this.lights.add(this.primaryLight);
            this.rootNode.addLight((Light)this.primaryLight);
        } else {
            DirectionalLight light = new DirectionalLight();
            light.setColor(color);
            light.setDirection(direction.normalizeLocal());
            this.lights.add(light);
            this.rootNode.addLight((Light)light);
        }
    }

    private void deleteSky() {
        if (this.sky != null) {
            this.rootNode.detachChild(this.sky);
            this.sky = null;
        }
    }

    private void updateSky() {
        this.sky.setLocalScale(1000.0f);
        this.rootNode.attachChild(this.sky);
        this.notifyRepaint();
    }

    @Override
    public void setupSky(final String skyBox) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMERenderer.this.deleteSky();
                JMERenderer.this.sky = SkyFactory.createSky((AssetManager)JMERenderer.this.assetManager, (String)skyBox, (SkyFactory.EnvMapType)SkyFactory.EnvMapType.CubeMap);
                JMERenderer.this.updateSky();
                return null;
            }
        });
    }

    @Override
    public void setupSky(String west, String east, String north, String south, String up, String down) {
        final Texture westTex = this.assetManager.loadTexture(new TextureKey(west, true));
        final Texture eastTex = this.assetManager.loadTexture(new TextureKey(east, true));
        final Texture northTex = this.assetManager.loadTexture(new TextureKey(north, true));
        final Texture southTex = this.assetManager.loadTexture(new TextureKey(south, true));
        final Texture upTex = this.assetManager.loadTexture(new TextureKey(up, true));
        final Texture downTex = this.assetManager.loadTexture(new TextureKey(down, true));
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMERenderer.this.deleteSky();
                JMERenderer.this.sky = SkyFactory.createSky((AssetManager)JMERenderer.this.assetManager, (Texture)westTex, (Texture)eastTex, (Texture)northTex, (Texture)southTex, (Texture)upTex, (Texture)downTex);
                JMERenderer.this.updateSky();
                return null;
            }
        });
    }

    @Override
    public void setupSky() {
        try {
            if (skyboxToUse == SkyboxToUse.BLUE_SKY) {
                String west = "Textures/Sky/Bright/skyboxsun25degtest/skyrender0005.bmp";
                String east = "Textures/Sky/Bright/skyboxsun25degtest/skyrender0002.bmp";
                String north = "Textures/Sky/Bright/skyboxsun25degtest/skyrender0001.bmp";
                String south = "Textures/Sky/Bright/skyboxsun25degtest/skyrender0004.bmp";
                String up = "Textures/Sky/Bright/skyboxsun25degtest/skyrender0003.bmp";
                String down = "Textures/Sky/Bright/skyboxsun25degtest/skyrender0007.bmp";
                this.setupSky(west, east, north, south, up, down);
            } else if (skyboxToUse == SkyboxToUse.DUSK_SKY) {
                String west = "Textures/Sky/Bright/skyboxsun45deg/skyrender0005.bmp";
                String east = "Textures/Sky/Bright/skyboxsun45deg/skyrender0002.bmp";
                String north = "Textures/Sky/Bright/skyboxsun45deg/skyrender0001.bmp";
                String south = "Textures/Sky/Bright/skyboxsun45deg/skyrender0004.bmp";
                String up = "Textures/Sky/Bright/skyboxsun45deg/skyrender0003.bmp";
                String down = "Textures/Sky/Bright/skyboxsun45deg/skyrender0006.bmp";
                this.setupSky(west, east, north, south, up, down);
            } else if (skyboxToUse == SkyboxToUse.JME_MOUNTAINS) {
                this.setupSky("Textures/Sky/Bright/BrightSky.dds");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInitApp() {
        this.setupExceptionHandling();
        JMERenderer.setupAssetManger(this.assetManager);
        this.zUpNode = new Node("zUpNode");
        this.zUpNode.setLocalRotation(JMEGeometryUtils.getRotationFromJMEToZupCoordinates());
        this.rootNode.attachChild((Spatial)this.zUpNode);
        this.setupLighting();
        this.disableMainViewport();
        this.contextManager.initialize();
        Object object = this.loadingStatus;
        synchronized (object) {
            this.loadingStatus.notify();
        }
        this.setDisplayFps(true);
        this.setDisplayStatView(false);
    }

    private void setupExceptionHandling() {
        Thread.currentThread().setUncaughtExceptionHandler(null);
        Thread.setDefaultUncaughtExceptionHandler(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleUpdate(float tpf) {
        if (this.alreadyClosing) {
            return;
        }
        Object object = this.graphicsConch;
        synchronized (object) {
            if (this.alreadyClosing) {
                return;
            }
            for (JMEGraphics3DNode jmeGraphicsNode : this.jmeGraphicsNodesListView) {
                jmeGraphicsNode.update();
            }
            this.updateSpotLights();
            this.updateCameras();
        }
        if (this.count > 1000 && !tickUpdated) {
            tickUpdated = true;
        }
        ++this.count;
        this.updateGraphics(tpf);
    }

    private boolean shouldRepaint() {
        return true;
    }

    public void initialize() {
        super.initialize();
        if (this.canvas != null) {
            this.canvas.initialize(this.renderManager);
        }
    }

    public void update() {
        if (this.alreadyClosing) {
            return;
        }
        if (this.prof != null) {
            this.prof.appStep(AppStep.BeginFrame);
        }
        this.applicationUpdate();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        float tpf = this.timer.getTimePerFrame() * this.speed;
        if (this.prof != null) {
            this.prof.appStep(AppStep.StateManagerUpdate);
        }
        this.stateManager.update(tpf);
        this.simpleUpdate(tpf);
        if (this.shouldRepaint()) {
            this.lazyRendersToPerform = Math.max(this.lazyRendersToPerform, 2);
        }
        if (this.prof != null) {
            this.prof.appStep(AppStep.SpatialUpdate);
        }
        this.rootNode.updateLogicalState(tpf);
        this.guiNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
        this.guiNode.updateGeometricState();
        if (this.prof != null) {
            this.prof.appStep(AppStep.StateManagerRender);
        }
        this.stateManager.render(this.renderManager);
        if (this.prof != null) {
            this.prof.appStep(AppStep.RenderFrame);
        }
        if (!this.lazyRendering || this.lazyRendersToPerform > 0) {
            this.renderManager.render(tpf, this.context.isRenderable());
            if (this.canvas != null) {
                this.canvas.postFrame();
            }
            this.lazyRendersToPerform = Math.max(0, this.lazyRendersToPerform - 1);
        }
        this.simpleRender(this.renderManager);
        this.stateManager.postRender();
        if (this.prof != null) {
            this.prof.appStep(AppStep.EndFrame);
        }
    }

    public void applicationUpdate() {
        AudioContext.setAudioRenderer((AudioRenderer)this.audioRenderer);
        if (this.prof != null) {
            this.prof.appStep(AppStep.QueuedTasks);
        }
        this.runQueuedTasks();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        this.timer.update();
        if (this.inputEnabled) {
            if (this.prof != null) {
                this.prof.appStep(AppStep.ProcessInput);
            }
            this.inputManager.update(this.timer.getTimePerFrame());
        }
        if (this.audioRenderer != null) {
            if (this.prof != null) {
                this.prof.appStep(AppStep.ProcessAudio);
            }
            this.audioRenderer.update(this.timer.getTimePerFrame());
        }
    }

    private void updateSpotLights() {
        for (JMESpotLight spotLight : this.jmeSpotLightsView) {
            spotLight.update();
        }
    }

    private synchronized void updateCameras() {
        if (this.alreadyClosing) {
            return;
        }
        for (JMEViewportAdapter viewportAdapter : this.viewportAdapters) {
            viewportAdapter.updateCamera();
        }
    }

    @Override
    public void setGroundVisible(final boolean isVisible) {
        this.enqueue(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (isVisible != JMERenderer.this.isTerrainVisible) {
                    if (isVisible) {
                        JMERenderer.this.zUpNode.attachChild((Spatial)JMERenderer.this.terrain);
                    } else {
                        JMERenderer.this.terrain.removeFromParent();
                    }
                    JMERenderer.this.isTerrainVisible = isVisible;
                }
                return isVisible;
            }
        });
        this.notifyRepaint();
    }

    private void repaintTerrain() {
        this.enqueue(new Callable<JMEHeightMapTerrain>(){

            @Override
            public JMEHeightMapTerrain call() throws Exception {
                if (JMERenderer.this.terrain != null) {
                    JMERenderer.this.terrain.removeFromParent();
                }
                JMEHeightMapTerrain jmeTerrain = new JMEHeightMapTerrain(JMERenderer.this.heightMap, JMERenderer.this.assetManager, JMERenderer.this.terrainAppearance);
                JMERenderer.this.terrain = jmeTerrain.getTerrain();
                JMERenderer.this.terrain.setShadowMode(RenderQueue.ShadowMode.Receive);
                if (JMERenderer.this.isTerrainVisible) {
                    JMERenderer.this.zUpNode.attachChild((Spatial)JMERenderer.this.terrain);
                }
                return jmeTerrain;
            }
        });
        this.notifyRepaint();
    }

    @Override
    public void setHeightMap(HeightMap heightMap) {
        this.heightMap = heightMap;
        this.repaintTerrain();
    }

    public HashBiMap<Graphics3DNode, JMEGraphics3DNode> getJmeGraphicsNodes() {
        return this.jmeGraphicsNodes;
    }

    @Override
    public void addSelectedListener(SelectedListener selectedListener) {
        this.selectedListenerHolder.addSelectedListener(selectedListener);
    }

    public Node getZUpNode() {
        return this.zUpNode;
    }

    public void setTransparentNodesScaleToZero() {
        for (Node transparentNode : this.getVisualizationNodes()) {
            if (transparentNode instanceof JMEGraphics3DNode) {
                ((JMEGraphics3DNode)transparentNode).getGraphics3DNode().getTransform().setToZero();
                continue;
            }
            transparentNode.setLocalScale(0.0f);
        }
        this.notifyRepaint();
    }

    public void setTransparentNodesScaleToOne() {
        for (Node transparentNode : this.getVisualizationNodes()) {
            if (transparentNode instanceof JMEGraphics3DNode) {
                ((JMEGraphics3DNode)transparentNode).getGraphics3DNode().getTransform().resetScale();
                continue;
            }
            transparentNode.setLocalScale(1.0f);
        }
        this.notifyRepaint();
    }

    @Override
    public void isShowing(PBOAwtPanel pboAwtPanel) {
        LogTools.info((String)("A " + pboAwtPanel.getClass().getSimpleName() + " showed on screen."));
        this.addRepaintListeners(pboAwtPanel);
        if (!this.gpuLidars.isEmpty()) {
            this.updateGPULidarScenes();
        }
    }

    public void addRepaintListeners(Component panel) {
        if (this.alreadyClosing) {
            return;
        }
        if (panel == null) {
            return;
        }
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JMERenderer.this.notifyRepaint();
            }
        });
        panel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JMERenderer.this.notifyRepaint();
            }
        });
        panel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JMERenderer.this.notifyRepaint();
            }
        });
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JMERenderer.this.notifyRepaint(3);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                JMERenderer.this.notifyRepaint();
            }
        });
        RepaintManager.setCurrentManager(new NewRepaintManager(this, panel, this.closeableAndDisposableRegistry));
    }

    @Override
    public void isCreated(PBOAwtPanel pboAwtPanel) {
    }

    public void updateGPULidarScenes() {
        if (!this.pboAwtPanels.isEmpty()) {
            Stopwatch timer = new Stopwatch().start();
            for (JMEGPULidar gpuLidar : this.gpuLidars) {
                gpuLidar.updateViewPortScenes();
            }
            this.notifyRepaint();
            LogTools.info((String)("GPULidar scene updated. Took " + MathTools.roundToSignificantFigures((double)timer.totalElapsed(), (int)2) + " s"));
        }
    }

    public void syncSubsceneToMain(Node subscene) {
        this.syncSubsceneToMain(this.getZUpNode(), subscene, subscene);
    }

    private void syncSubsceneToMain(Node main, Node sub, Node subsceneRoot) {
        if (this.alreadyClosing) {
            return;
        }
        sub.setLocalTransform(main.getLocalTransform());
        for (Spatial child : main.getChildren()) {
            if (child.getName() == null) continue;
            Spatial subchild = this.findChildWithName(sub, child.getName());
            if (subchild == null && !JMENodeTools.isVisualization(child)) {
                if (child instanceof Node) {
                    subchild = this.cloneNode((Node)child);
                    sub.attachChild(subchild);
                } else {
                    subchild = child.clone(false);
                    sub.attachChild(subchild);
                }
            }
            if (subchild == null) continue;
            if (child instanceof Node) {
                this.syncSubsceneToMain((Node)child, (Node)subchild, subsceneRoot);
                continue;
            }
            subchild.setLocalTransform(child.getLocalTransform());
        }
        subsceneRoot.updateGeometricState();
        this.notifyRepaint();
    }

    private Spatial findChildWithName(Node node, String name) {
        if (name == null) {
            return null;
        }
        for (Spatial child : node.getChildren()) {
            if (child == null || child.getName() == null || !child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public Node cloneScene() {
        Node clonedScene = this.cloneNode(this.getZUpNode());
        return clonedScene;
    }

    private Node cloneNode(Node node) {
        Node clone = node.clone(false);
        ArrayList<Object> newChildren = new ArrayList<Object>();
        for (Spatial spatial : clone.getChildren()) {
            if (spatial instanceof Node && spatial.getName() != null) {
                newChildren.add(this.cloneNode((Node)spatial));
                continue;
            }
            newChildren.add(spatial);
        }
        clone.detachAllChildren();
        for (Spatial spatial : newChildren) {
            clone.attachChild(spatial);
        }
        clone.updateGeometricState();
        return clone;
    }

    public Node cloneSceneWithoutVisualizations() {
        Node clonedScene = this.cloneScene();
        this.removeVisualizations(clonedScene, 0L, clonedScene);
        return clonedScene;
    }

    private long removeVisualizations(Node node, long num, Node rootNode) {
        for (Spatial child : node.getChildren()) {
            if (!(child instanceof Node)) continue;
            if (JMENodeTools.isVisualization(child)) {
                child.removeFromParent();
                ++num;
                continue;
            }
            this.removeVisualizations((Node)child, num, rootNode);
        }
        rootNode.updateGeometricState();
        this.notifyRepaint();
        return num;
    }

    public List<Node> getVisualizationNodes() {
        List<Node> flattenedNodeList = this.getAllNodesInSceneAsList();
        ArrayList<Node> transparentNodeList = new ArrayList<Node>();
        for (Node node : flattenedNodeList) {
            if (!JMENodeTools.isVisualization((Spatial)node)) continue;
            transparentNodeList.add(node);
        }
        return transparentNodeList;
    }

    public long getNumberOfNodesInScene() {
        return this.getNumberOfNodesInScene(this.getZUpNode());
    }

    private long getNumberOfNodesInScene(Node root) {
        long count = 1L;
        for (Spatial spatial : root.getChildren()) {
            if (!(spatial instanceof Node)) continue;
            count += this.getNumberOfNodesInScene((Node)spatial);
        }
        return count;
    }

    public List<Node> getAllNodesInSceneAsList() {
        return this.getAllNodesInSceneAsList(this.getZUpNode(), new ArrayList<Node>());
    }

    private List<Node> getAllNodesInSceneAsList(Node root, List<Node> list) {
        list.add(root);
        for (Spatial spatial : root.getChildren()) {
            if (!(spatial instanceof Node)) continue;
            this.getAllNodesInSceneAsList((Node)spatial, list);
        }
        return list;
    }

    @Override
    public void setBackgroundColor(MutableColor color) {
    }

    @Override
    public void setBackgroundImage(URL fileURL, Graphics3DBackgroundScaleMode backgroundScaleMode) {
        System.err.println(this.getClass().getSimpleName() + ": setBackgroundImage not implemented.");
    }

    @Override
    public void setGroundAppearance(AppearanceDefinition app) {
        this.terrainAppearance = app;
        if (this.heightMap != null) {
            this.repaintTerrain();
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.keyListenerHolder.addKeyListener(keyListener);
    }

    public SelectedListenerHolder getSelectedListenerHolder() {
        return this.selectedListenerHolder;
    }

    public KeyListenerHolder getKeyListenerHolder() {
        return this.keyListenerHolder;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListenerHolder.addMouseListener(mouseListener);
    }

    public MouseListenerHolder getMouseListenerHolder() {
        return this.mouseListenerHolder;
    }

    @Override
    public void addMouse3DListener(Mouse3DListener mouse3DListener) {
        this.mouse3DListenerHolder.addMouse3DListener(mouse3DListener);
    }

    public Mouse3DListenerHolder getMouse3DListenerHolder() {
        return this.mouse3DListenerHolder;
    }

    public Mouse3DInterface getMouse3DJoystick() {
        return this.mouse3DJoystick;
    }

    public DirectionalLight getPrimaryLight() {
        return this.primaryLight;
    }

    public InputManager getInputManager() {
        return this.inputManager;
    }

    @Override
    public void freezeFrame(final Graphics3DNode rootJoint) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMEGraphics3DNode node = (JMEGraphics3DNode)JMERenderer.this.jmeGraphicsNodes.get((Object)rootJoint);
                Node freezedNode = node.clone(true);
                JMERenderer.this.zUpNode.attachChild((Spatial)freezedNode);
                return null;
            }
        });
        this.notifyRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAndDispose() {
        Iterator<Object> iterator;
        if (this.alreadyClosing) {
            return;
        }
        this.alreadyClosing = true;
        this.notifyRepaint();
        this.stop();
        this.rootNode = null;
        this.guiNode = null;
        this.fpsText = null;
        this.guiFont = null;
        this.flyCam = null;
        if (this.closeableAndDisposableRegistry != null) {
            this.closeableAndDisposableRegistry.closeAndDispose();
            this.closeableAndDisposableRegistry = null;
        }
        if (this.viewportAdapters != null) {
            for (JMEViewportAdapter viewportAdapter : this.viewportAdapters) {
                viewportAdapter.closeAndDispose();
            }
            this.viewportAdapters.clear();
            this.viewportAdapters = null;
        }
        if (this.contextManager != null) {
            this.contextManager.closeAndDispose();
            this.contextManager = null;
        }
        if (this.jmeGraphicsNodes != null) {
            iterator = this.graphicsConch;
            synchronized (iterator) {
                this.jmeGraphicsNodes.clear();
                this.jmeGraphicsNodes = null;
            }
        }
        if (this.jmeGraphicsNodesListView != null) {
            iterator = this.graphicsConch;
            synchronized (iterator) {
                this.jmeGraphicsNodesListView.clear();
                this.jmeGraphicsNodesListView = null;
            }
        }
        this.selectedListenerHolder = null;
        this.keyListenerHolder = null;
        this.mouseListenerHolder = null;
        this.mouse3DListenerHolder = null;
        if (this.mouse3DJoystick != null) {
            this.mouse3DJoystick.stopPolling();
            this.mouse3DJoystick = null;
        }
        this.rootJoint = null;
        this.terrain = null;
        this.zUpNode = null;
        if (this.gpuLidars != null) {
            for (JMEGPULidar jmegpuLidar : this.gpuLidars) {
                jmegpuLidar.cleanup();
            }
            this.gpuLidars.clear();
            this.gpuLidars = null;
        }
        if (this.pboAwtPanels != null) {
            for (PBOAwtPanel pboAwtPanel : this.pboAwtPanels) {
                pboAwtPanel.closeAndDispose();
            }
            this.pboAwtPanels.clear();
            this.pboAwtPanels = null;
        }
        this.primaryLight = null;
    }

    @Override
    public JMEContextManager getContextManager() {
        return this.contextManager;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public boolean isGroundVisible() {
        return this.isTerrainVisible;
    }

    @Override
    public JMEGPULidar createGPULidar(int pointsPerSweep, int scanHeight, double fieldOfView, double minRange, double maxRange) {
        JMEGPULidar gpuLidar = new JMEGPULidar(this, pointsPerSweep, scanHeight, fieldOfView, minRange, maxRange);
        this.gpuLidars.add(gpuLidar);
        this.updateGPULidarScenes();
        return gpuLidar;
    }

    @Override
    public JMEGPULidar createGPULidar(GPULidarListener listener, int pointsPerSweep, int scanHeight, double fieldOfView, double minRange, double maxRange) {
        JMEGPULidar gpuLidar = this.createGPULidar(pointsPerSweep, scanHeight, fieldOfView, minRange, maxRange);
        gpuLidar.addGPULidarListener(listener);
        return gpuLidar;
    }

    @Override
    public void play() {
        this.notifyRepaint();
        this.lazyRendering = false;
    }

    @Override
    public void pause() {
        this.lazyRendering = true;
    }

    protected synchronized void updateGraphics(float tpf) {
        for (Updatable updatable : this.updatables) {
            updatable.simpleUpdate(tpf);
        }
    }

    public synchronized void registerUpdatable(final Updatable updatable) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMERenderer.this.updatables.add(updatable);
                return null;
            }
        });
    }

    public synchronized void removeUpdatable(final Updatable updatable) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMERenderer.this.updatables.remove(updatable);
                return null;
            }
        });
    }

    @Override
    public void addDirectionalLight(Color color, Vector3D direction) {
        final Vector3f jmeDirection = JMEDataTypeUtils.vecMathTuple3dToJMEVector3f((Tuple3DReadOnly)direction);
        JMEGeometryUtils.transformFromZupToJMECoordinates(jmeDirection);
        final ColorRGBA jmeColor = JMEDataTypeUtils.colorToColorRGBA(color);
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMERenderer.this.addDirectionalLight(jmeColor, jmeDirection);
                return null;
            }
        });
    }

    @Override
    public void clearDirectionalLights() {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (Light light : JMERenderer.this.lights) {
                    JMERenderer.this.rootNode.removeLight(light);
                }
                JMERenderer.this.lights.clear();
                return null;
            }
        });
    }

    @Override
    public void addSpotLight(final Graphics3DSpotLight spotLight) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (JMERenderer.this.jmeSpotLights.containsKey((Object)spotLight)) {
                    throw new RuntimeException("Spotlight is already added to graphic subsystem");
                }
                JMESpotLight jmeSpotLight = new JMESpotLight(spotLight);
                JMERenderer.this.jmeSpotLights.put((Object)spotLight, (Object)jmeSpotLight);
                JMERenderer.this.rootNode.addLight((Light)jmeSpotLight);
                return null;
            }
        });
    }

    @Override
    public void removeSpotLight(final Graphics3DSpotLight spotLight) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMESpotLight spotLightToRemove = (JMESpotLight)((Object)JMERenderer.this.jmeSpotLights.remove((Object)spotLight));
                if (spotLightToRemove != null) {
                    JMERenderer.this.rootNode.removeLight((Light)spotLightToRemove);
                }
                return null;
            }
        });
    }

    static {
        Path scsCachePath = PathTools.systemTemporaryDirectory().resolve("SCSCache");
        FileTools.ensureDirectoryExists((Path)scsCachePath, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + scsCachePath.toString());
        NativeLibraryLoader.setCustomExtractionFolder((String)scsCachePath.toString());
        if (System.getProperty("os.name").toLowerCase().contains("inux")) {
            GLFW.glfwInit();
            UIManager.getLookAndFeel();
        }
    }

    public static enum RenderType {
        CANVAS,
        AWTPANELS;

    }

    public static enum SkyboxToUse {
        JME_MOUNTAINS,
        BLUE_SKY,
        DUSK_SKY;

    }

    private static class NewRepaintManager
    extends RepaintManager
    implements CloseableAndDisposable {
        private RepaintManager oldManager;
        private Component panel;
        private JMERenderer jmeRender;

        public NewRepaintManager(JMERenderer jmeRender, Component panel, CloseableAndDisposableRegistry closeableAndDisposableRegistry) {
            this.oldManager = RepaintManager.currentManager(panel);
            this.panel = panel;
            if (closeableAndDisposableRegistry != null) {
                closeableAndDisposableRegistry.registerCloseableAndDisposable((CloseableAndDisposable)this);
            }
        }

        @Override
        public void addDirtyRegion(Applet applet, int x, int y, int w, int h) {
            if (this.oldManager == null) {
                return;
            }
            this.oldManager.addDirtyRegion(applet, x, y, w, h);
        }

        @Override
        public void addDirtyRegion(Window window, int x, int y, int w, int h) {
            if (this.oldManager == null) {
                return;
            }
            this.oldManager.addDirtyRegion(window, x, y, w, h);
        }

        @Override
        public synchronized void addInvalidComponent(JComponent invalidComponent) {
            if (this.oldManager == null) {
                return;
            }
            this.oldManager.addInvalidComponent(invalidComponent);
        }

        @Override
        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            if (this.oldManager == null) {
                return;
            }
            this.oldManager.addDirtyRegion(c, x, y, w, h);
            if (this.jmeRender == null) {
                return;
            }
            if (c == this.panel) {
                this.jmeRender.notifyRepaint();
            }
        }

        public void closeAndDispose() {
            if (this.oldManager != null) {
                this.panel = null;
                this.jmeRender = null;
            }
        }
    }
}

