/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import com.jme3.asset.AssetInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.ASCIISTLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.BinarySTLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReader;

public class STLReaderFactory {
    public static STLReader create(AssetInfo assetInfo) throws IOException {
        InputStream inputStream = assetInfo.openStream();
        if (inputStream.markSupported()) {
            return STLReaderFactory.create(inputStream);
        }
        inputStream.mark(80);
        byte[] header = new byte[80];
        byte[] nextLine = new byte[80];
        inputStream.read(header);
        inputStream.read(nextLine);
        inputStream.close();
        return STLReaderFactory.create(header, nextLine, assetInfo.openStream());
    }

    @Deprecated
    public static STLReader create(InputStream stream) throws IOException {
        stream.mark(80);
        byte[] header = new byte[80];
        byte[] nextLine = new byte[80];
        stream.read(header);
        stream.read(nextLine);
        stream.reset();
        String type = new String(header, 0, 80, "US-ASCII");
        String proof = new String(nextLine, 0, 80, "US-ASCII");
        Pattern asciiSTL = Pattern.compile("^\\s*solid.*", 32);
        Pattern asciiSTLNextLineMatcher = Pattern.compile(".*(facet.*|endso.*)", 32);
        if (asciiSTL.matcher(type).matches() && (asciiSTL.matcher(proof).matches() || asciiSTLNextLineMatcher.matcher(proof).matches())) {
            return new ASCIISTLReader(stream);
        }
        return new BinarySTLReader(stream);
    }

    private static STLReader create(byte[] header, byte[] nextLine, InputStream stream) throws IOException {
        String type = new String(header, 0, 80, "US-ASCII");
        String proof = new String(nextLine, 0, 80, "US-ASCII");
        Pattern asciiSTL = Pattern.compile("^\\s*solid.*", 32);
        Pattern asciiSTLNextLineMatcher = Pattern.compile(".*(facet.*|endso.*)", 32);
        if (asciiSTL.matcher(type).matches() && (asciiSTL.matcher(proof).matches() || asciiSTLNextLineMatcher.matcher(proof).matches())) {
            return new ASCIISTLReader(stream);
        }
        return new BinarySTLReader(stream);
    }
}

