/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;

public class JMEZBufferGrabber
extends AbstractAppState
implements SceneProcessor {
    private Renderer renderer;
    private int width;
    private int height;
    private final ViewPort viewport;
    private ByteBuffer outBuf;

    public JMEZBufferGrabber(ViewPort viewport) {
        this.viewport = viewport;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        if (!super.isInitialized()) {
            this.viewport.addProcessor((SceneProcessor)this);
        }
        super.initialize(stateManager, app);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderer = rm.getRenderer();
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.renderer != null;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.outBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
        this.width = w;
        this.height = h;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        if (out == null) {
            return;
        }
        FrameBuffer.RenderBuffer rb = out.getDepthBuffer();
        if (rb == null) {
            throw new IllegalArgumentException("Specified framebuffer does not have a depthbuffer");
        }
        this.renderer.setFrameBuffer(out);
        this.outBuf.clear();
        GL11.glReadPixels((int)0, (int)0, (int)this.width, (int)this.height, (int)6402, (int)5126, (ByteBuffer)this.outBuf);
    }

    public void cleanup() {
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public double[][] getZBuffer() {
        if (this.outBuf == null) {
            return new double[0][0];
        }
        this.outBuf.rewind();
        FloatBuffer outBufAsFloatBuffer = this.outBuf.asFloatBuffer();
        double[][] depthBuffer = new double[this.width][this.height];
        int x = 0;
        int y = 0;
        while (outBufAsFloatBuffer.hasRemaining()) {
            depthBuffer[x][y] = outBufAsFloatBuffer.get();
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return depthBuffer;
    }

    public void setProfiler(AppProfiler profiler) {
    }
}

