/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;

public class JMEMeshDataInterpreter {
    public static Mesh interpretMeshData(MeshDataHolder meshData) {
        if (meshData == null) {
            return new Mesh();
        }
        Vector3f[] vertices = JMEDataTypeUtils.vecMathTuple3fArrayToJMEVector3fArray((Tuple3DBasics[])meshData.getVertices());
        Vector2f[] textureCoords = JMEDataTypeUtils.texCoord2fArrayToJMEVector2fArray(meshData.getTexturePoints());
        Vector3f[] normals = JMEDataTypeUtils.vecMathTuple3fArrayToJMEVector3fArray((Tuple3DBasics[])meshData.getVertexNormals());
        int[] triangleIndices = meshData.getTriangleIndices();
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        if (textureCoords != null) {
            mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])textureCoords));
        }
        mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((Vector3f[])normals));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])triangleIndices));
        mesh.updateBound();
        return mesh;
    }
}

