/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.util;

import com.jme3.app.SimpleApplication;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jMonkeyEngineToolkit.Updatable;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEPointCloudGenerator;

public class JMELidarSpriteGenerator
extends Node
implements Updatable {
    private static final Point3D32 ORIGIN = new Point3D32();
    protected SimpleApplication jmeRenderer;
    protected Node thisObject = this;
    protected Geometry pointCloudGeometry;
    protected List<ColorRGBA> colors;
    protected ColorRGBA defaultColor;
    protected boolean newCloudAvailable = false;
    protected JMEPointCloudGenerator pointCloudGenerator;
    protected ArrayList<ColorRGBA> colorList = new ArrayList();
    private Random random = new Random();
    protected final AtomicReference<Point3DReadOnly[]> pointSource = new AtomicReference();
    AtomicReference<Node> newPointCloud = new AtomicReference();

    public JMELidarSpriteGenerator(SimpleApplication jmeRenderer) {
        this(jmeRenderer, null);
    }

    public JMELidarSpriteGenerator(SimpleApplication jmeRenderer, ColorRGBA colorRGBA) {
        super("JMELidarFINALVisualizer");
        this.jmeRenderer = jmeRenderer;
        this.pointCloudGenerator = new JMEPointCloudGenerator(jmeRenderer.getAssetManager());
        this.defaultColor = colorRGBA;
    }

    public void clear() {
        this.jmeRenderer.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JMELidarSpriteGenerator.this.thisObject.detachAllChildren();
                return null;
            }
        });
    }

    public List<ColorRGBA> generateColors(Point3DReadOnly[] points) {
        this.colorList.clear();
        float distance = 3.0f;
        float calcDistance = 0.0f;
        for (Point3DReadOnly current : points) {
            calcDistance = (float)ORIGIN.distance(current);
            int c = Color.HSBtoRGB(calcDistance % distance / distance, 1.0f, 1.0f);
            if (this.defaultColor == null) {
                this.colorList.add(new ColorRGBA((float)(c >> 16 & 0xFF) / 256.0f, (float)(c >> 8 & 0xFF) / 256.0f, (float)(c >> 0 & 0xFF) / 256.0f, 1.0f));
                continue;
            }
            this.colorList.add(this.defaultColor);
        }
        return this.colorList;
    }

    public void setDefaultColor(ColorRGBA color) {
        this.defaultColor = color;
    }

    public List<ColorRGBA> generateColors(int numberOfPoints) {
        this.colorList = new ArrayList();
        for (int i = 0; i < numberOfPoints; ++i) {
            this.colorList.add(new ColorRGBA(this.random.nextFloat(), this.random.nextFloat(), this.random.nextFloat(), 1.0f));
        }
        return this.colorList;
    }

    public void setResolution(float resolution) {
        this.pointCloudGenerator.setSizeCM(resolution);
    }

    public void updatePoints(Point3DReadOnly[] source) {
        this.pointSource.set(source);
        this.newCloudAvailable = true;
        this.getNextCloudReady();
    }

    public void getNextCloudReady() {
        if (this.newCloudAvailable) {
            this.newCloudAvailable = false;
            Point3DReadOnly[] pointSource = this.pointSource.get();
            if (pointSource == null) {
                return;
            }
            this.colors = this.generateColors(pointSource);
            try {
                Node pointCloud = this.pointCloudGenerator.generatePointCloudGraph(pointSource, this.colors);
                this.pointCloudGeometry = pointCloud.getChildren().size() > 0 ? (Geometry)pointCloud.getChild(0) : null;
                this.newPointCloud.set(pointCloud);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void update() {
        Node newCloud = this.newPointCloud.getAndSet(null);
        if (newCloud != null && this.getParent() != null) {
            this.thisObject.detachAllChildren();
            this.thisObject.attachChild((Spatial)newCloud);
        }
    }

    protected float getLidarResolution() {
        return 0.02f;
    }

    protected boolean allowPointCloudCollisions() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int collideWith(Collidable other, CollisionResults results) {
        Geometry geom;
        if (!this.allowPointCloudCollisions()) {
            return super.collideWith(other, results);
        }
        AtomicReference<Point3DReadOnly[]> atomicReference = this.pointSource;
        synchronized (atomicReference) {
            geom = this.pointCloudGeometry;
        }
        if (other instanceof Ray && geom != null) {
            Ray ray = (Ray)other;
            if (ray.direction != null && ray.origin != null && ray.direction.lengthSquared() != 0.0f) {
                Point3D32 origin = new Point3D32(ray.getOrigin().x, ray.getOrigin().y, ray.getOrigin().z);
                Vector3D32 dir = new Vector3D32(ray.getDirection().x, ray.getDirection().y, ray.getDirection().z);
                Point3D32 nearest = this.getNearestIntersection((Point3DReadOnly)origin, (Vector3DReadOnly)dir, this.getLidarResolution(), geom.getWorldTransform());
                if (nearest != null) {
                    CollisionResult collRes = new CollisionResult(geom, new Vector3f(nearest.getX32(), nearest.getY32(), nearest.getZ32()), (float)origin.distance((Point3DReadOnly)nearest), 0);
                    collRes.setContactNormal(new Vector3f(0.0f, 0.0f, 1.0f));
                    results.addCollision(collRes);
                    return 1;
                }
                return 0;
            }
        }
        return super.collideWith(other, results);
    }

    public Point3D32 getNearestIntersection(Point3DReadOnly origin, Vector3DReadOnly direction, double resolution, Transform pointTransform) {
        Point3DReadOnly[] points = this.pointSource.get();
        direction = new UnitVector3D((Tuple3DReadOnly)direction);
        double nearestDistance = Double.POSITIVE_INFINITY;
        Point3D32 nearestPoint = null;
        for (Point3DReadOnly p1 : points) {
            double distance;
            Vector3f p = new Vector3f(p1.getX32(), p1.getY32(), p1.getZ32());
            pointTransform.transformVector(p, p);
            float dx = origin.getX32() - p.x;
            float dy = origin.getY32() - p.y;
            float dz = origin.getZ32() - p.z;
            float dot = dx * direction.getX32() + dy * direction.getY32() + dz * direction.getZ32();
            double distanceToLine = (dx -= dot * direction.getX32()) * dx + (dy -= dot * direction.getY32()) * dy + (dz -= dot * direction.getZ32()) * dz;
            Point3D32 curpt = new Point3D32(p.x, p.y, p.z);
            if (!(distanceToLine < resolution * resolution) || !((distance = origin.distanceSquared((Point3DReadOnly)curpt)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestPoint = curpt;
        }
        return nearestPoint;
    }

    @Override
    public void simpleUpdate(float tpf) {
        this.update();
    }
}

