/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.light.SpotLight;
import com.jme3.math.Vector3f;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DSpotLight;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;

public class JMESpotLight
extends SpotLight {
    private final Graphics3DSpotLight spotLight;
    private final Vector3f jmePosition = new Vector3f();
    private final Vector3f jmeDirection = new Vector3f();
    private double innerAngle = 0.0;
    private double outerAngle = 0.0;

    public JMESpotLight(Graphics3DSpotLight spotLight) {
        this.spotLight = spotLight;
    }

    public void update() {
        JMEDataTypeUtils.packVecMathTuple3dInJMEVector3f((Tuple3DReadOnly)this.spotLight.getPosition(), this.jmePosition);
        JMEDataTypeUtils.packVecMathTuple3dInJMEVector3f((Tuple3DReadOnly)this.spotLight.getDirection(), this.jmeDirection);
        JMEGeometryUtils.transformFromZupToJMECoordinates(this.jmePosition);
        JMEGeometryUtils.transformFromZupToJMECoordinates(this.jmeDirection);
        this.setColor(JMEDataTypeUtils.colorToColorRGBA(this.spotLight.getColor()));
        this.setDirection(this.jmeDirection);
        this.setPosition(this.jmePosition);
        if (this.innerAngle != this.spotLight.getSpotInnerAngle()) {
            this.setSpotInnerAngle((float)this.spotLight.getSpotInnerAngle());
            this.innerAngle = this.spotLight.getSpotInnerAngle();
        }
        if (this.outerAngle != this.spotLight.getSpotOuterAngle()) {
            this.setSpotOuterAngle((float)this.spotLight.getSpotOuterAngle());
            this.outerAngle = this.spotLight.getSpotOuterAngle();
        }
        this.setSpotRange((float)this.spotLight.getSpotRange());
    }
}

