/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.camera;

import java.awt.image.BufferedImage;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.image.ImageCallback;
import us.ihmc.jMonkeyEngineToolkit.CameraAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraStreamer;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.log.LogTools;
import us.ihmc.tools.TimestampProvider;

public class OffscreenBufferVideoServer {
    private final ImageCallback imageCallback;
    private final CameraAdapter camera;
    private final TimestampProvider timestampProvider;

    public OffscreenBufferVideoServer(Graphics3DAdapter adapter, CameraMountList mountList, CameraConfiguration cameraConfiguration, CameraTrackingAndDollyPositionHolder cameraTrackingAndDollyPositionHolder, int width, int height, ImageCallback imageCallback, TimestampProvider timestampProvider, int framesPerSecond) {
        ViewportAdapter viewport = adapter.createNewViewport(null, false, true);
        this.camera = viewport.getCamera();
        viewport.setupOffscreenView(width, height);
        ClassicCameraController cameraController = new ClassicCameraController(adapter, viewport, cameraTrackingAndDollyPositionHolder);
        cameraController.setConfiguration(cameraConfiguration, mountList);
        viewport.setCameraController(cameraController);
        CameraUpdater cameraUpdater = new CameraUpdater();
        this.imageCallback = imageCallback;
        this.timestampProvider = timestampProvider;
        LogTools.info((String)"Starting video stream");
        viewport.getCaptureDevice().streamTo(cameraUpdater, framesPerSecond);
    }

    public void close() {
        this.imageCallback.dispose();
    }

    private class CameraUpdater
    implements CameraStreamer {
        private CameraUpdater() {
        }

        @Override
        public void updateImage(BufferedImage bufferedImage, long timeStamp, Point3DReadOnly cameraPosition, QuaternionReadOnly cameraOrientation, double fov) {
            OffscreenBufferVideoServer.this.imageCallback.onNewImage(bufferedImage, timeStamp, cameraPosition, cameraOrientation, fov);
        }

        @Override
        public Point3DReadOnly getCameraPosition() {
            return OffscreenBufferVideoServer.this.camera.getCameraPosition();
        }

        @Override
        public QuaternionReadOnly getCameraOrientation() {
            return OffscreenBufferVideoServer.this.camera.getCameraRotation();
        }

        @Override
        public double getFieldOfView() {
            return OffscreenBufferVideoServer.this.camera.getHorizontalFovInRadians();
        }

        @Override
        public boolean isReadyForNewData() {
            return OffscreenBufferVideoServer.this.imageCallback.isAvailable();
        }

        @Override
        public long getTimeStamp() {
            return OffscreenBufferVideoServer.this.timestampProvider.getTimestamp();
        }
    }
}

