/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.Triangle;

public class BinarySTLReader
implements STLReader {
    private final String name;
    private final ArrayList<Triangle> triangles = new ArrayList();

    public BinarySTLReader(InputStream stream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(stream);
        this.name = this.getHeader(stream);
        byte[] backingArray = new byte[4];
        dataInputStream.readFully(backingArray);
        ByteBuffer elementsBuffer = ByteBuffer.wrap(backingArray);
        elementsBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long numberOfTriangles = elementsBuffer.getInt() & 0xFFFFFFFF;
        if (numberOfTriangles > Integer.MAX_VALUE) {
            throw new IOException("Cannot handle more than 2147483647 elements, got " + numberOfTriangles + " elements");
        }
        int i = 0;
        while ((long)i < numberOfTriangles) {
            this.triangles.add(this.readTriangle(dataInputStream));
            ++i;
        }
        dataInputStream.close();
    }

    private Triangle readTriangle(DataInputStream dataInputStream) throws IOException {
        byte[] backingArray = new byte[50];
        dataInputStream.readFully(backingArray);
        ByteBuffer data = ByteBuffer.wrap(backingArray);
        data.order(ByteOrder.LITTLE_ENDIAN);
        Triangle triangle = new Triangle();
        float ni = data.getFloat();
        float nj = data.getFloat();
        float nk = data.getFloat();
        triangle.setNormal(ni, nj, nk);
        for (int i = 0; i < 3; ++i) {
            float vx = data.getFloat();
            float vy = data.getFloat();
            float vz = data.getFloat();
            triangle.addVertex(vx, vy, vz);
        }
        return triangle;
    }

    private String getHeader(InputStream stream) throws IOException {
        byte[] header = new byte[80];
        stream.read(header);
        String name = new String(header, 0, 80, "US-ASCII");
        return name.trim();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Triangle> getTriangles() {
        return this.triangles;
    }
}

