/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit;

import java.awt.Container;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JFrame;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapterTools;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DFrameListener;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;

public class Graphics3DWorld
implements Graphics3DFrameListener {
    private final Graphics3DAdapter graphics3dAdapter;
    private Graphics3DNode rootNode;
    private final String worldName;
    private ClassicCameraController cameraController;
    protected ViewportAdapter viewportAdapter;
    private JFrame jFrame;
    private ConcurrentLinkedQueue<Graphics3DNode> graphics3DNodesToAddPostFrame = new ConcurrentLinkedQueue();

    public Graphics3DWorld(String worldName, Graphics3DAdapter graphics3dAdapter) {
        this.graphics3dAdapter = graphics3dAdapter;
        this.worldName = worldName;
        this.init();
    }

    public Graphics3DWorld(Graphics3DAdapter graphics3dAdapter) {
        this(Graphics3DWorld.class.getSimpleName(), graphics3dAdapter);
    }

    private void init() {
        this.rootNode = new Graphics3DNode(this.worldName + "RootNode");
    }

    protected void start() {
        this.graphics3dAdapter.addRootNode(this.rootNode);
        this.viewportAdapter = Graphics3DAdapterTools.createViewport(this.graphics3dAdapter);
        this.addFrameListener(this);
    }

    public void fixCameraOnNode(Graphics3DNode node) {
        this.checkCameraIsNotNull();
        this.cameraController.setFixPosition(node.getTranslation().getX(), node.getTranslation().getY(), node.getTranslation().getZ());
    }

    public void setCameraPosition(double x, double y, double z) {
        this.checkCameraIsNotNull();
        this.cameraController.setCameraPosition(x, y, z);
    }

    private void checkCameraIsNotNull() {
        if (this.cameraController == null) {
            try {
                throw new Exception("Camera controller is null. Start gui before moving camera.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkViewportIsNotNull() {
        if (this.viewportAdapter == null) {
            try {
                throw new Exception("Viewport adapter is null. Call startWithGui or startWithoutGui first.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void startWithGui(double camX, double camY, double camZ, int windowWidth, int windowHeight) {
        this.start();
        this.cameraController = Graphics3DAdapterTools.createCameraController(this.graphics3dAdapter, this.viewportAdapter, new Vector3D(camX, camY, camZ));
        this.addChild(this.cameraController.getFixPointNode());
        this.jFrame = Graphics3DAdapterTools.createNewWindow(this.viewportAdapter, this.worldName, windowWidth, windowHeight, this.cameraController);
    }

    public void startWithGui(int windowWidth, int windowHeight) {
        this.startWithGui(0.0, -6.0, 1.0, windowWidth, windowHeight);
    }

    public void startWithGui(double camX, double camY, double camZ) {
        this.startWithGui(camX, camY, camZ, 800, 600);
    }

    public void startWithGui() {
        this.startWithGui(0.0, -6.0, 1.0, 800, 600);
    }

    public void startWithoutGui() {
        this.start();
    }

    public void keepAlive(double time) {
        ThreadTools.sleepSeconds((double)time);
    }

    public void stop() {
        this.graphics3dAdapter.closeViewport(this.viewportAdapter);
        this.graphics3dAdapter.closeAndDispose();
        if (this.jFrame != null) {
            this.jFrame.dispose();
        }
    }

    public void addFrameListener(Graphics3DFrameListener frameListener) {
        this.checkViewportIsNotNull();
        this.viewportAdapter.addFrameListener(frameListener);
    }

    public void addChild(Graphics3DNode child) {
        if (this.viewportAdapter == null) {
            this.rootNode.addChild(child);
        } else {
            this.graphics3DNodesToAddPostFrame.add(child);
        }
    }

    public void addAllChildren(Graphics3DNode ... children) {
        for (Graphics3DNode child : children) {
            this.addChild(child);
        }
    }

    public Graphics3DNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Graphics3DNode rootNode) {
        this.rootNode = rootNode;
    }

    public Graphics3DAdapter getGraphics3DAdapter() {
        return this.graphics3dAdapter;
    }

    @Override
    public void postFrame(double timePerFrame) {
        while (!this.graphics3DNodesToAddPostFrame.isEmpty()) {
            this.graphics3dAdapter.addRootNode(this.graphics3DNodesToAddPostFrame.poll());
        }
    }

    public Container getContentPane() {
        return this.jFrame.getContentPane();
    }
}

