/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.light.DirectionalLight;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shadow.DirectionalLightShadowRenderer;
import com.jme3.shadow.EdgeFilteringMode;
import com.jme3.system.JmeContext;
import com.jme3.system.awt.AwtPanel;
import com.jme3.system.awt.AwtPanelsContext;
import com.jme3.system.awt.PaintMode;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.ArrayList;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.jMonkeyEngineToolkit.ContextSwitchedListener;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DFrameListener;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.InputMapSetter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMECamera;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEFastCaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanel;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanelsContext;
import us.ihmc.jMonkeyEngineToolkit.jme.input.JMEInputManager;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;

public class JMEViewportAdapter
extends ViewportAdapter
implements InputMapSetter,
SceneProcessor {
    private JMECamera jmeCamera;
    private JMEInputManager jmeInputManager;
    private final boolean isMainViewport;
    private JmeContext context;
    private Canvas panel = null;
    private FrameBuffer frameBuffer = null;
    private ViewportType viewportType;
    private ViewPort viewPort;
    private AssetManager assetManager;
    private ArrayList<ContextSwitchedListener> contextSwitchedListeners = new ArrayList();
    private RenderManager renderManager;
    private JMEFastCaptureDevice screenShotHelper;
    private AppStateManager stateManager;
    private DirectionalLight primaryLight;
    private FilterPostProcessor fpp;
    private final JMERenderer jmeRenderer;
    private Stopwatch frameTimer = new Stopwatch().start();
    private boolean alreadyClosing = false;
    boolean addedPostProcessors = false;

    public JMEViewportAdapter(JMERenderer jmeRenderer, Node rootNode, boolean isMainViewport, ViewportType viewportType) {
        this(jmeRenderer, rootNode, isMainViewport, viewportType, false, Color.LIGHT_GRAY);
    }

    public JMEViewportAdapter(JMERenderer jmeRenderer, Node rootNode, boolean isMainViewport, ViewportType viewportType, boolean addExtraVisuals) {
        this(jmeRenderer, rootNode, isMainViewport, viewportType, addExtraVisuals, Color.LIGHT_GRAY);
    }

    public JMEViewportAdapter(JMERenderer jmeRenderer, Node rootNode, boolean isMainViewport, ViewportType viewportType, boolean addExtraVisuals, Color backgroundColor) {
        this(jmeRenderer, rootNode, isMainViewport, viewportType, addExtraVisuals, backgroundColor, true);
    }

    public JMEViewportAdapter(JMERenderer jmeRenderer, Node rootNode, boolean isMainViewport, ViewportType viewportType, boolean addExtraVisuals, Color backgroundColor, boolean flipY) {
        this.jmeRenderer = jmeRenderer;
        this.assetManager = jmeRenderer.getAssetManager();
        this.stateManager = jmeRenderer.getStateManager();
        this.context = jmeRenderer.getContext();
        this.primaryLight = jmeRenderer.getPrimaryLight();
        this.isMainViewport = isMainViewport;
        this.renderManager = jmeRenderer.getRenderManager();
        this.jmeCamera = new JMECamera(jmeRenderer.getCamera());
        this.viewPort = this.renderManager.createMainView("JMEViewport", (Camera)this.jmeCamera);
        this.viewPort.attachScene((Spatial)rootNode);
        this.viewPort.setClearFlags(true, true, true);
        this.viewPort.setBackgroundColor(JMEDataTypeUtils.colorToColorRGBA(backgroundColor));
        this.viewPort.addProcessor((SceneProcessor)this);
        this.screenShotHelper = new JMEFastCaptureDevice(this.viewPort, jmeRenderer);
        this.stateManager.attach((AppState)this.screenShotHelper);
        if (addExtraVisuals) {
            this.setupShadows(this.viewPort);
            this.setUpPostProcesses();
        }
        this.viewportType = viewportType;
        if (viewportType.equals((Object)ViewportType.MULTICAM) || viewportType.equals((Object)ViewportType.CANVAS)) {
            jmeRenderer.getContextManager().addJMEViewportAdapter(this);
            this.jmeInputManager = new JMEInputManager(jmeRenderer, rootNode, this.jmeCamera, flipY);
        }
        jmeRenderer.registerViewport(this);
    }

    @Override
    public void addFrameListener(Graphics3DFrameListener frameListener) {
        super.addFrameListener(frameListener);
        this.jmeRenderer.play();
    }

    public void setupViewport(double left, double right, double bottom, double top) {
        if (this.viewportType != ViewportType.MULTICAM) {
            throw new RuntimeException("Viewport is not setup for multicam rendering");
        }
        this.viewPort.setClearFlags(true, true, true);
        this.jmeCamera.setViewPort((float)left, (float)right, (float)bottom, (float)top);
    }

    @Override
    public Canvas getCanvas() {
        if (this.viewportType != ViewportType.CANVAS) {
            throw new RuntimeException("Viewport is not setup for canvas rendering");
        }
        if (this.panel == null) {
            if (this.context instanceof AwtPanelsContext) {
                AwtPanel awtPanel = ((AwtPanelsContext)this.context).createPanel(PaintMode.Accelerated);
                this.jmeRenderer.addRepaintListeners((Component)awtPanel);
                awtPanel.attachTo(this.isMainViewport, new ViewPort[]{this.viewPort});
                this.panel = awtPanel;
            } else if (this.context instanceof PBOAwtPanelsContext) {
                PBOAwtPanel awtPanel = ((PBOAwtPanelsContext)this.context).createPanel();
                this.jmeRenderer.addRepaintListeners(awtPanel);
                awtPanel.attachTo(this.isMainViewport, this.viewPort);
                this.panel = awtPanel;
            }
        }
        return this.panel;
    }

    @Override
    public void setupOffscreenView(int width, int height) {
        if (this.viewportType == ViewportType.CANVAS) {
            throw new RuntimeException("Viewport is setup for canvas rendering");
        }
        this.frameBuffer = new FrameBuffer(width, height, 1);
        this.viewPort.setOutputFrameBuffer(this.frameBuffer);
        this.viewPort.getCamera().resize(width, height, true);
        this.frameBuffer.setDepthBuffer(Image.Format.Depth);
        this.frameBuffer.setColorBuffer(Image.Format.RGBA8);
    }

    public void closeAndDispose() {
        if (this.alreadyClosing) {
            return;
        }
        this.alreadyClosing = true;
        this.viewPort.setEnabled(false);
        this.renderManager.removeMainView(this.viewPort);
        this.viewPort = null;
        this.renderManager = null;
        if (this.jmeCamera != null) {
            this.jmeCamera.closeAndDispose();
            this.jmeCamera = null;
        }
        this.jmeInputManager = null;
        this.context = null;
        this.panel = null;
        this.frameBuffer = null;
        this.viewportType = null;
        this.assetManager = null;
        if (this.contextSwitchedListeners != null) {
            this.contextSwitchedListeners.clear();
            this.contextSwitchedListeners = null;
        }
        if (this.screenShotHelper != null) {
            this.screenShotHelper.closeAndDispose();
            this.screenShotHelper = null;
        }
        this.stateManager = null;
        this.primaryLight = null;
        this.fpp = null;
        this.frameTimer = null;
    }

    public void closeViewportAdapter() {
        if (this.viewPort != null) {
            this.viewPort.setEnabled(false);
        }
        if (this.renderManager != null) {
            this.renderManager.removeMainView(this.viewPort);
        }
    }

    private void setupShadows(ViewPort viewPort) {
        DirectionalLightShadowRenderer dlsr = new DirectionalLightShadowRenderer(this.assetManager, 4096, 2);
        dlsr.setLight(this.primaryLight);
        dlsr.setLambda(0.8f);
        dlsr.setShadowIntensity(0.2f);
        dlsr.setEdgeFilteringMode(EdgeFilteringMode.PCF4);
        viewPort.addProcessor((SceneProcessor)dlsr);
    }

    public void setUpPostProcesses() {
        if (this.fpp == null) {
            // empty if block
        }
    }

    @Override
    public void setDefaultInputMappings() {
        this.jmeInputManager.registerWithInputManager();
    }

    @Override
    public void reset() {
        this.jmeInputManager.reset();
    }

    public void setClipDistances(double near, double far) {
    }

    public void setFieldOfView(double fieldOfView) {
    }

    @Override
    public CameraController getCameraController() {
        return this.jmeCamera.getController();
    }

    @Override
    public CaptureDevice getCaptureDevice() {
        return this.screenShotHelper;
    }

    public int getHeight() {
        return this.panel.getHeight();
    }

    public int getWidth() {
        return this.panel.getWidth();
    }

    public void setSize(int width, int height) {
        if (this.viewportType == ViewportType.CANVAS) {
            this.panel.setSize(width, height);
        } else {
            System.err.println("Resizing offscreen renderer, might crash!");
            this.setupOffscreenView(width, height);
        }
    }

    @Override
    public double getFieldOfView() {
        return 0.0;
    }

    private double convertToPhysicalDimension(int pixels) {
        double dPixels = pixels;
        double dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        return dPixels / dpi * 0.0254;
    }

    @Override
    public double getPhysicalWidth() {
        return this.convertToPhysicalDimension(this.getWidth());
    }

    @Override
    public double getPhysicalHeight() {
        return this.convertToPhysicalDimension(this.getHeight());
    }

    public void updateCamera() {
        this.jmeCamera.updateCamera();
    }

    @Override
    public void setCameraController(CameraController cameraController) {
        this.jmeCamera.setCameraController(cameraController);
    }

    @Override
    public JMECamera getCamera() {
        return this.jmeCamera;
    }

    public boolean isMainViewport() {
        return this.isMainViewport;
    }

    @Override
    public Point3D getWorldCoordinatesFromScreenCoordinates(float x, float y, double z) {
        Vector3f worldCoordinates = this.jmeCamera.getWorldCoordinates(new Vector2f(x, y), (float)z);
        JMEGeometryUtils.transformFromJMECoordinatesToZup(worldCoordinates);
        return JMEDataTypeUtils.jmeVector3fToJ3DPoint3d(worldCoordinates);
    }

    @Override
    public void addContextSwitchedListener(ContextSwitchedListener contextSwitchedListener) {
        this.contextSwitchedListeners.add(contextSwitchedListener);
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public void attachScene(Spatial scene) {
        this.viewPort.attachScene(scene);
    }

    public void detachScene(Spatial scene) {
        this.viewPort.detachScene(scene);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public boolean isInitialized() {
        return false;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        if (this.alreadyClosing) {
            return;
        }
        double timePerFrame = this.frameTimer.lap();
        for (Graphics3DFrameListener listener : this.getFrameListeners()) {
            listener.postFrame(timePerFrame);
        }
    }

    public void cleanup() {
    }

    public void setProfiler(AppProfiler profiler) {
    }

    public static enum ViewportType {
        OFFSCREEN,
        CANVAS,
        MULTICAM;

    }
}

