/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit;

import java.util.ArrayList;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.graphicsDescription.HeightMap;

public class CombinedHeightMap
implements HeightMap {
    private final ArrayList<HeightMap> heightMaps = new ArrayList();
    private BoundingBox3D boundingBox = null;

    public void addHeightMap(HeightMap heightMap) {
        this.heightMaps.add(heightMap);
        this.boundingBox = this.boundingBox == null ? heightMap.getBoundingBox() : BoundingBox3D.union((BoundingBox3DReadOnly)this.boundingBox, (BoundingBox3DReadOnly)heightMap.getBoundingBox());
    }

    public double heightAt(double x, double y, double z) {
        Double heightAt = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.heightMaps.size(); ++i) {
            double localHeightAt;
            HeightMap heightMap = this.heightMaps.get(i);
            if (!heightMap.getBoundingBox().isXYInsideInclusive(x, y) || !((localHeightAt = heightMap.heightAt(x, y, z)) > heightAt)) continue;
            heightAt = localHeightAt;
        }
        return heightAt;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

