/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.camera;

import java.util.ArrayList;
import javax.swing.JFrame;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.input.keyboard.KeyListener;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DListener;
import us.ihmc.graphicsDescription.input.mouse.MouseButton;
import us.ihmc.graphicsDescription.input.mouse.MouseListener;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountInterface;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.TrackingDollyCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.tools.inputDevices.keyboard.Key;
import us.ihmc.tools.inputDevices.keyboard.ModifierKeyInterface;

public class ClassicCameraController
implements TrackingDollyCameraController,
KeyListener,
MouseListener,
Mouse3DListener,
SelectedListener {
    public static final double MIN_FIELD_OF_VIEW = 0.001;
    public static final double MAX_FIELD_OF_VIEW = 2.0;
    private static final double MIN_CAMERA_POSITION_TO_FIX_DISTANCE = 0.1;
    public static final double CAMERA_START_X = 0.0;
    public static final double CAMERA_START_Y = -6.0;
    public static final double CAMERA_START_Z = 1.0;
    private double fieldOfView = 0.7853981633974483;
    private double clipDistanceNear = 0.1;
    private double clipDistanceFar = 1000.0;
    private double camX;
    private double camY;
    private double camZ;
    private double fixX;
    private double fixY;
    private double fixZ;
    private double zoom_factor = 1.0;
    private double rotate_factor = 1.0;
    private double rotate_camera_factor = 1.0;
    private boolean isMounted = false;
    private CameraMountInterface cameraMount;
    private boolean isTracking = true;
    private boolean isTrackingX = true;
    private boolean isTrackingY = true;
    private boolean isTrackingZ = false;
    private boolean isDolly = false;
    private boolean isDollyX = true;
    private boolean isDollyY = true;
    private boolean isDollyZ = false;
    private double trackDX = 0.0;
    private double trackDY = 0.0;
    private double trackDZ = 0.0;
    private double dollyDX = 2.0;
    private double dollyDY = 12.0;
    private double dollyDZ = 0.0;
    private ViewportAdapter viewportAdapter;
    private JFrame jFrame;
    private boolean fly = true;
    private boolean forward = false;
    private boolean backward = false;
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;
    private ArrayList<Point3D> storedCameraPositions = new ArrayList(0);
    private ArrayList<Point3D> storedFixPositions = new ArrayList(0);
    private int storedPositionIndex = 0;
    private boolean transitioning = false;
    private static double transitionTime = 500.0;
    private double camXSpeed;
    private double camYSpeed;
    private double camZSpeed;
    private double fixXSpeed;
    private double fixYSpeed;
    private double fixZSpeed;
    private long lastTransitionTime;
    private ArrayList<Point3D> keyFrameCamPos = new ArrayList(0);
    private ArrayList<Point3D> keyFrameFixPos = new ArrayList(0);
    private ArrayList<Integer> keyFrameTimes = new ArrayList(0);
    private Graphics3DNode fixPointNode = new Graphics3DNode("cameraFixPoint", new Graphics3DObject((Shape3DReadOnly)new Sphere3D(0.01), YoAppearance.RGBColor((double)1.0, (double)0.0, (double)0.0, (double)0.5)));
    private boolean toggleCameraKeyPoints = false;
    private int cameraKeyPointIndex;
    private ArrayList<Integer> cameraKeyPoints = new ArrayList(0);
    private CameraTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder;
    private Graphics3DAdapter graphics3dAdapter;
    private Vector3D v3d = new Vector3D();
    private RigidBodyTransform t3d = new RigidBodyTransform();
    private Vector3D rotVector = new Vector3D();
    private AxisAngle rotAxisAngle4d = new AxisAngle();
    private RotationMatrix rotationMatrix = new RotationMatrix();
    private Vector3D positionOffset = new Vector3D();
    private Vector3D zAxis = new Vector3D();
    private Vector3D yAxis = new Vector3D();
    private Vector3D xAxis = new Vector3D();
    private double rotateGain = 0.15;
    private double translateGain = 0.05;
    private boolean alreadyClosing = false;

    public static ClassicCameraController createClassicCameraControllerAndAddListeners(ViewportAdapter viewportAdapter, CameraTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder, Graphics3DAdapter graphics3dAdapter) {
        return ClassicCameraController.createClassicCameraControllerAndAddListeners(viewportAdapter, cameraTrackAndDollyVariablesHolder, graphics3dAdapter, null);
    }

    public static ClassicCameraController createClassicCameraControllerAndAddListeners(ViewportAdapter viewportAdapter, CameraTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder, Graphics3DAdapter graphics3dAdapter, JFrame jFrame) {
        ClassicCameraController classicCameraController = new ClassicCameraController(graphics3dAdapter, viewportAdapter, cameraTrackAndDollyVariablesHolder, jFrame);
        graphics3dAdapter.addKeyListener(classicCameraController);
        graphics3dAdapter.addMouseListener(classicCameraController);
        graphics3dAdapter.addMouse3DListener(classicCameraController);
        graphics3dAdapter.addSelectedListener(classicCameraController);
        return classicCameraController;
    }

    public ClassicCameraController(Graphics3DAdapter graphics3dAdapter, ViewportAdapter viewportAdapter, CameraTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder) {
        this(graphics3dAdapter, viewportAdapter, cameraTrackAndDollyVariablesHolder, null);
    }

    public ClassicCameraController(Graphics3DAdapter graphics3dAdapter, ViewportAdapter viewportAdapter, CameraTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder, JFrame jFrame) {
        if (graphics3dAdapter == null) {
            throw new RuntimeException("graphics3dAdapter == null");
        }
        this.graphics3dAdapter = graphics3dAdapter;
        this.viewportAdapter = viewportAdapter;
        this.jFrame = jFrame;
        this.camX = 0.0;
        this.camY = -6.0;
        this.camZ = 1.0;
        this.fixX = 0.0;
        this.fixY = 0.0;
        this.fixZ = 0.6;
        this.cameraTrackAndDollyVariablesHolder = cameraTrackAndDollyVariablesHolder;
        this.setTracking(false);
        this.setDolly(false);
    }

    public void setCameraMount(CameraMountInterface mount) {
        this.cameraMount = mount;
    }

    public CameraMountInterface getCameraMount() {
        return this.cameraMount;
    }

    public boolean isMounted() {
        return this.isMounted;
    }

    @Override
    public CameraTrackingAndDollyPositionHolder getCameraTrackAndDollyVariablesHolder() {
        return this.cameraTrackAndDollyVariablesHolder;
    }

    @Override
    public void setConfiguration(CameraConfiguration config, CameraMountList mountList) {
        if (config == null) {
            return;
        }
        this.isMounted = config.isCameraMounted();
        if (this.isMounted && mountList != null) {
            this.cameraMount = mountList.getCameraMount(config.getCameraMountName());
        }
        this.camX = config.camX;
        this.camY = config.camY;
        this.camZ = config.camZ;
        this.fixX = config.fixX;
        this.fixY = config.fixY;
        this.fixZ = config.fixZ;
        this.isTracking = config.isTracking;
        this.isTrackingX = config.isTrackingX;
        this.isTrackingY = config.isTrackingY;
        this.isTrackingZ = config.isTrackingZ;
        this.isDolly = config.isDolly;
        this.isDollyX = config.isDollyX;
        this.isDollyY = config.isDollyY;
        this.isDollyZ = config.isDollyZ;
        this.trackDX = config.trackDX;
        this.trackDY = config.trackDY;
        this.trackDZ = config.trackDZ;
        this.dollyDX = config.dollyDX;
        this.dollyDY = config.dollyDY;
        this.dollyDZ = config.dollyDZ;
        this.setFieldOfView(config.fieldOfView);
        this.clipDistanceFar = config.clipDistanceFar;
        this.clipDistanceNear = config.clipDistanceNear;
    }

    @Override
    public boolean isTracking() {
        return this.isTracking;
    }

    @Override
    public boolean isTrackingX() {
        return this.isTrackingX;
    }

    @Override
    public boolean isTrackingY() {
        return this.isTrackingY;
    }

    @Override
    public boolean isTrackingZ() {
        return this.isTrackingZ;
    }

    @Override
    public boolean isDolly() {
        return this.isDolly;
    }

    @Override
    public boolean isDollyX() {
        return this.isDollyX;
    }

    @Override
    public boolean isDollyY() {
        return this.isDollyY;
    }

    @Override
    public boolean isDollyZ() {
        return this.isDollyZ;
    }

    @Override
    public void setTracking(boolean track, boolean trackX, boolean trackY, boolean trackZ) {
        this.setTracking(track);
        this.setTrackingX(trackX);
        this.setTrackingY(trackY);
        this.setTrackingZ(trackZ);
    }

    @Override
    public void setDolly(boolean dolly, boolean dollyX, boolean dollyY, boolean dollyZ) {
        this.setDolly(dolly);
        this.setDollyX(dollyX);
        this.setDollyY(dollyY);
        this.setDollyZ(dollyZ);
    }

    @Override
    public void setTrackingOffsets(double dx, double dy, double dz) {
        this.trackDX = dx;
        this.trackDY = dy;
        this.trackDZ = dz;
    }

    @Override
    public void setDollyOffsets(double dx, double dy, double dz) {
        this.dollyDX = dx;
        this.dollyDY = dy;
        this.dollyDZ = dz;
    }

    @Override
    public void setTracking(boolean track) {
        this.isTracking = track;
    }

    @Override
    public void setTrackingX(boolean trackX) {
        this.isTrackingX = trackX;
    }

    @Override
    public void setTrackingY(boolean trackY) {
        this.isTrackingY = trackY;
    }

    @Override
    public void setTrackingZ(boolean trackZ) {
        this.isTrackingZ = trackZ;
    }

    @Override
    public void setDolly(boolean dolly) {
        this.isDolly = dolly;
    }

    @Override
    public void setDollyX(boolean dollyX) {
        this.isDollyX = dollyX;
    }

    @Override
    public void setDollyY(boolean dollyY) {
        this.isDollyY = dollyY;
    }

    @Override
    public void setDollyZ(boolean dollyZ) {
        this.isDollyZ = dollyZ;
    }

    @Override
    public double getTrackingXOffset() {
        return this.trackDX;
    }

    @Override
    public double getTrackingYOffset() {
        return this.trackDY;
    }

    @Override
    public double getTrackingZOffset() {
        return this.trackDZ;
    }

    @Override
    public double getDollyXOffset() {
        return this.dollyDX;
    }

    @Override
    public double getDollyYOffset() {
        return this.dollyDY;
    }

    @Override
    public double getDollyZOffset() {
        return this.dollyDZ;
    }

    @Override
    public void setTrackingXOffset(double dx) {
        this.trackDX = dx;
    }

    @Override
    public void setTrackingYOffset(double dy) {
        this.trackDY = dy;
    }

    @Override
    public void setTrackingZOffset(double dz) {
        this.trackDZ = dz;
    }

    @Override
    public void setDollyXOffset(double dx) {
        this.dollyDX = dx;
    }

    @Override
    public void setDollyYOffset(double dy) {
        this.dollyDY = dy;
    }

    @Override
    public void setDollyZOffset(double dz) {
        this.dollyDZ = dz;
    }

    @Override
    public void update() {
        double fieldOfView;
        if (this.graphics3dAdapter.getContextManager().getCurrentViewport() != this.viewportAdapter) {
            this.forward = false;
            this.backward = false;
            this.left = false;
            this.right = false;
            this.up = false;
            this.down = false;
        }
        if (this.isTracking) {
            double trackZ;
            double trackY;
            double trackX;
            if (this.isTrackingX && !Double.isNaN(trackX = this.cameraTrackAndDollyVariablesHolder.getTrackingX())) {
                this.fixX = trackX + this.trackDX;
            }
            if (this.isTrackingY && !Double.isNaN(trackY = this.cameraTrackAndDollyVariablesHolder.getTrackingY())) {
                this.fixY = trackY + this.trackDY;
            }
            if (this.isTrackingZ && !Double.isNaN(trackZ = this.cameraTrackAndDollyVariablesHolder.getTrackingZ())) {
                this.fixZ = trackZ + this.trackDZ;
            }
        }
        if (this.isDolly) {
            double dollyZ;
            double dollyY;
            double dollyX = this.cameraTrackAndDollyVariablesHolder.getDollyX();
            if (this.isDollyX && !Double.isNaN(dollyX)) {
                this.camX = dollyX + this.dollyDX;
            }
            if (this.isDollyY && !Double.isNaN(dollyY = this.cameraTrackAndDollyVariablesHolder.getDollyY())) {
                this.camY = dollyY + this.dollyDY;
            }
            if (this.isDollyZ && !Double.isNaN(dollyZ = this.cameraTrackAndDollyVariablesHolder.getDollyZ())) {
                this.camZ = dollyZ + this.dollyDZ;
            }
        }
        if (!Double.isNaN(fieldOfView = this.cameraTrackAndDollyVariablesHolder.getFieldOfView())) {
            this.setFieldOfView(fieldOfView);
        }
        if (this.fly && !this.isTracking && !this.isDolly && !this.transitioning) {
            if (this.forward) {
                this.moveCameraForward(-0.5);
            }
            if (this.backward) {
                this.moveCameraForward(0.5);
            }
            if (this.left) {
                this.pan(20.0, 0.0);
            }
            if (this.right) {
                this.pan(-20.0, 0.0);
            }
            if (this.up) {
                this.pan(0.0, 20.0);
            }
            if (this.down) {
                this.pan(0.0, -20.0);
            }
        }
        if (this.transitioning && !this.isTracking && !this.isDolly) {
            int numberOfDimensionsThatHaveTransitioned = 0;
            double elapsedTransitionTime = System.currentTimeMillis() - this.lastTransitionTime;
            this.lastTransitionTime = System.currentTimeMillis();
            if (Math.abs(this.camX - this.storedCameraPositions.get(this.storedPositionIndex).getX()) <= Math.abs(this.camXSpeed * elapsedTransitionTime)) {
                this.camX = this.storedCameraPositions.get(this.storedPositionIndex).getX();
                ++numberOfDimensionsThatHaveTransitioned;
            } else {
                this.camX += this.camXSpeed * elapsedTransitionTime;
            }
            if (Math.abs(this.camY - this.storedCameraPositions.get(this.storedPositionIndex).getY()) <= Math.abs(this.camYSpeed * elapsedTransitionTime)) {
                this.camY = this.storedCameraPositions.get(this.storedPositionIndex).getY();
                ++numberOfDimensionsThatHaveTransitioned;
            } else {
                this.camY += this.camYSpeed * elapsedTransitionTime;
            }
            if (Math.abs(this.camZ - this.storedCameraPositions.get(this.storedPositionIndex).getZ()) <= Math.abs(this.camZSpeed * elapsedTransitionTime)) {
                this.camZ = this.storedCameraPositions.get(this.storedPositionIndex).getZ();
                ++numberOfDimensionsThatHaveTransitioned;
            } else {
                this.camZ += this.camZSpeed * elapsedTransitionTime;
            }
            if (Math.abs(this.fixX - this.storedFixPositions.get(this.storedPositionIndex).getX()) <= Math.abs(this.fixXSpeed * elapsedTransitionTime)) {
                this.fixX = this.storedFixPositions.get(this.storedPositionIndex).getX();
                ++numberOfDimensionsThatHaveTransitioned;
            } else {
                this.fixX += this.fixXSpeed * elapsedTransitionTime;
            }
            if (Math.abs(this.fixY - this.storedFixPositions.get(this.storedPositionIndex).getY()) <= Math.abs(this.fixYSpeed * elapsedTransitionTime)) {
                this.fixY = this.storedFixPositions.get(this.storedPositionIndex).getY();
                ++numberOfDimensionsThatHaveTransitioned;
            } else {
                this.fixY += this.fixYSpeed * elapsedTransitionTime;
            }
            if (Math.abs(this.fixZ - this.storedFixPositions.get(this.storedPositionIndex).getZ()) <= Math.abs(this.fixZSpeed * elapsedTransitionTime)) {
                this.fixZ = this.storedFixPositions.get(this.storedPositionIndex).getZ();
                ++numberOfDimensionsThatHaveTransitioned;
            } else {
                this.fixZ += this.fixZSpeed * elapsedTransitionTime;
            }
            if (numberOfDimensionsThatHaveTransitioned == 6) {
                this.transitioning = false;
            }
        }
    }

    public void addKeyFrame(int time) {
        this.addKeyFrame(this.keyFrameCamPos.size(), time);
    }

    public void addKeyFrame(int i, int time) {
        this.keyFrameCamPos.add(i, new Point3D(this.camX, this.camY, this.camZ));
        this.keyFrameFixPos.add(i, new Point3D(this.fixX, this.fixY, this.fixZ));
        this.keyFrameTimes.add(i, time);
    }

    public int removeKeyFrameByTime(int time) {
        for (int i = 0; i < this.keyFrameTimes.size(); ++i) {
            if (this.keyFrameTimes.get(i) != time) continue;
            this.removeKeyFrameByIndex(i);
            return i;
        }
        return -1;
    }

    public void removeKeyFrameByIndex(int i) {
        if (i >= 0 && i < this.keyFrameTimes.size()) {
            this.keyFrameTimes.remove(i);
            this.keyFrameCamPos.remove(i);
            this.keyFrameFixPos.remove(i);
        }
    }

    @Override
    public void setKeyFrameTime(int time) {
        for (int i = this.keyFrameTimes.size() - 1; i >= 0; --i) {
            if (time < this.keyFrameTimes.get(i)) continue;
            if (this.keyFrameTimes.size() <= i + 1) break;
            double elapsedTime = time - this.keyFrameTimes.get(i);
            double totalTime = this.keyFrameTimes.get(i + 1) - this.keyFrameTimes.get(i);
            this.camX = this.keyFrameCamPos.get(i).getX() + (this.keyFrameCamPos.get(i + 1).getX() - this.keyFrameCamPos.get(i).getX()) * elapsedTime / totalTime;
            this.camY = this.keyFrameCamPos.get(i).getY() + (this.keyFrameCamPos.get(i + 1).getY() - this.keyFrameCamPos.get(i).getY()) * elapsedTime / totalTime;
            this.camZ = this.keyFrameCamPos.get(i).getZ() + (this.keyFrameCamPos.get(i + 1).getZ() - this.keyFrameCamPos.get(i).getZ()) * elapsedTime / totalTime;
            this.fixX = this.keyFrameFixPos.get(i).getX() + (this.keyFrameFixPos.get(i + 1).getX() - this.keyFrameFixPos.get(i).getX()) * elapsedTime / totalTime;
            this.fixY = this.keyFrameFixPos.get(i).getY() + (this.keyFrameFixPos.get(i + 1).getY() - this.keyFrameFixPos.get(i).getY()) * elapsedTime / totalTime;
            this.fixZ = this.keyFrameFixPos.get(i).getZ() + (this.keyFrameFixPos.get(i + 1).getZ() - this.keyFrameFixPos.get(i).getZ()) * elapsedTime / totalTime;
            break;
        }
    }

    public void gotoKey(int index) {
        if (index >= 0 && index < this.keyFrameCamPos.size()) {
            this.storedPositionIndex = index;
            this.camX = this.keyFrameCamPos.get(index).getX();
            this.camY = this.keyFrameCamPos.get(index).getY();
            this.camZ = this.keyFrameCamPos.get(index).getZ();
            this.fixX = this.keyFrameFixPos.get(index).getX();
            this.fixY = this.keyFrameFixPos.get(index).getY();
            this.fixZ = this.keyFrameFixPos.get(index).getZ();
        }
    }

    public ArrayList<Integer> getCameraKeyPoints() {
        return this.cameraKeyPoints;
    }

    @Override
    public double getFixX() {
        return this.fixX;
    }

    @Override
    public double getFixY() {
        return this.fixY;
    }

    @Override
    public double getFixZ() {
        return this.fixZ;
    }

    @Override
    public double getCamX() {
        return this.camX;
    }

    @Override
    public double getCamY() {
        return this.camY;
    }

    @Override
    public double getCamZ() {
        return this.camZ;
    }

    @Override
    public void setFixX(double fx) {
        this.fixX = fx;
    }

    @Override
    public void setFixY(double fy) {
        this.fixY = fy;
    }

    @Override
    public void setFixZ(double fz) {
        this.fixZ = fz;
    }

    @Override
    public void setCamX(double cx) {
        this.camX = cx;
    }

    @Override
    public void setCamY(double cy) {
        this.camY = cy;
    }

    @Override
    public void setCamZ(double cz) {
        this.camZ = cz;
    }

    @Override
    public void setFixPosition(double fx, double fy, double fz) {
        this.fixX = fx;
        this.fixY = fy;
        this.fixZ = fz;
    }

    @Override
    public void setCameraPosition(double cx, double cy, double cz) {
        this.camX = cx;
        this.camY = cy;
        this.camZ = cz;
    }

    public void doMouseDraggedLeft(double dx, double dy) {
        double delX0 = this.camX - this.fixX;
        double delY0 = this.camY - this.fixY;
        double delZ0 = this.camZ - this.fixZ;
        this.v3d.set(delX0, delY0, delZ0);
        this.t3d.setRotationYawAndZeroTranslation(-dx * this.rotate_factor);
        this.t3d.transform((Vector3DBasics)this.v3d);
        if (!this.isDolly || !this.isDollyX && !this.isDollyY) {
            this.camX = this.v3d.getX() + this.fixX;
            this.camY = this.v3d.getY() + this.fixY;
        }
        delX0 = this.camX - this.fixX;
        delY0 = this.camY - this.fixY;
        delZ0 = this.camZ - this.fixZ;
        this.rotVector.cross((Tuple3DReadOnly)new Vector3D(0.0, 0.0, -1.0), (Tuple3DReadOnly)this.v3d);
        this.rotAxisAngle4d.set((Vector3DReadOnly)this.rotVector, dy * this.rotate_factor / 4.0);
        this.t3d.setRotationAndZeroTranslation((Orientation3DReadOnly)this.rotAxisAngle4d);
        this.t3d.transform((Vector3DBasics)this.v3d);
        if (this.v3d.getX() * delX0 > 0.0 && this.v3d.getY() * delY0 > 0.0) {
            if (!this.isDolly || !this.isDollyX && !this.isDollyY) {
                this.camX = this.v3d.getX() + this.fixX;
                this.camY = this.v3d.getY() + this.fixY;
            }
            if (!this.isDolly || !this.isDollyZ) {
                this.camZ = this.v3d.getZ() + this.fixZ;
            }
        }
    }

    public void rotateAroundFix(double dx, double dy) {
        double distanceFromCameraToFix = Math.sqrt(Math.pow(this.camX - this.fixX, 2.0) + Math.pow(this.camY - this.fixY, 2.0) + Math.pow(this.camZ - this.fixZ, 2.0));
        if (distanceFromCameraToFix > 1.0) {
            dx /= distanceFromCameraToFix;
            dy /= distanceFromCameraToFix;
        }
        double delX0 = this.camX - this.fixX;
        double delY0 = this.camY - this.fixY;
        double delZ0 = this.camZ - this.fixZ;
        this.v3d.set(delX0, delY0, delZ0);
        this.t3d.setRotationYawAndZeroTranslation(-dx * this.rotate_factor);
        this.t3d.transform((Vector3DBasics)this.v3d);
        if (!this.isDolly || !this.isDollyX && !this.isDollyY) {
            this.camX = this.v3d.getX() + this.fixX;
            this.camY = this.v3d.getY() + this.fixY;
        }
        delX0 = this.camX - this.fixX;
        delY0 = this.camY - this.fixY;
        delZ0 = this.camZ - this.fixZ;
        this.rotVector.cross((Tuple3DReadOnly)new Vector3D(0.0, 0.0, -1.0), (Tuple3DReadOnly)this.v3d);
        this.rotAxisAngle4d.set((Vector3DReadOnly)this.rotVector, dy * this.rotate_factor / 4.0);
        this.t3d.setRotationAndZeroTranslation((Orientation3DReadOnly)this.rotAxisAngle4d);
        this.t3d.transform((Vector3DBasics)this.v3d);
        if (this.v3d.getX() * delX0 > 0.0 && this.v3d.getY() * delY0 > 0.0) {
            if (!this.isDolly || !this.isDollyX && !this.isDollyY) {
                this.camX = this.v3d.getX() + this.fixX;
                this.camY = this.v3d.getY() + this.fixY;
            }
            if (!this.isDolly || !this.isDollyZ) {
                this.camZ = this.v3d.getZ() + this.fixZ;
            }
        }
    }

    public void doMouseDraggedRight(double dx, double dy) {
        double delX0 = this.camX - this.fixX;
        double delY0 = this.camY - this.fixY;
        double delZ0 = this.camZ - this.fixZ;
        this.v3d.set(delX0, delY0, delZ0);
        this.t3d.setRotationYawAndZeroTranslation(-dx * this.rotate_camera_factor);
        this.t3d.transform((Vector3DBasics)this.v3d);
        if (!this.isTracking || !this.isTrackingX && !this.isTrackingY) {
            this.fixX = this.camX - this.v3d.getX();
            this.fixY = this.camY - this.v3d.getY();
        }
        delX0 = this.camX - this.fixX;
        delY0 = this.camY - this.fixY;
        delZ0 = this.camZ - this.fixZ;
        this.rotVector.set(-1.0, 0.0, 0.0);
        this.rotVector.cross((Tuple3DReadOnly)new Vector3D(0.0, 0.0, -1.0), (Tuple3DReadOnly)this.v3d);
        this.rotAxisAngle4d.set((Vector3DReadOnly)this.rotVector, dy * this.rotate_camera_factor / 4.0);
        this.t3d.setRotationAndZeroTranslation((Orientation3DReadOnly)this.rotAxisAngle4d);
        this.t3d.transform((Vector3DBasics)this.v3d);
        if (this.v3d.getX() * delX0 > 0.0 && this.v3d.getY() * delY0 > 0.0) {
            if (!this.isTracking || !this.isTrackingX && !this.isTrackingY) {
                this.fixX = this.camX - this.v3d.getX();
                this.fixY = this.camY - this.v3d.getY();
            }
            if (!this.isTracking || !this.isTrackingZ) {
                this.fixZ = this.camZ - this.v3d.getZ();
            }
        }
    }

    @Override
    public void setFieldOfView(double fov) {
        this.fieldOfView = fov;
        if (this.fieldOfView < 0.001) {
            this.fieldOfView = 0.001;
        }
        if (this.fieldOfView > 2.0) {
            this.fieldOfView = 2.0;
        }
    }

    public void doMouseDraggedMiddle(double dx, double dy) {
        if (this.isMounted && this.viewportAdapter != null) {
            this.cameraMount.zoom(dy * 0.1);
        } else {
            Vector3D v3d = new Vector3D(this.camX - this.fixX, this.camY - this.fixY, this.camZ - this.fixZ);
            Vector3D offsetVec = new Vector3D((Tuple3DReadOnly)v3d);
            offsetVec.scale(dy * this.zoom_factor);
            if (!this.isDolly || !this.isDollyX && !this.isDollyY) {
                this.camX += offsetVec.getX();
                this.camY += offsetVec.getY();
            }
            if (!this.isDolly || !this.isDollyZ) {
                this.camZ += offsetVec.getZ();
            }
            v3d.set(this.camX - this.fixX, this.camY - this.fixY, this.camZ - this.fixZ);
            if (v3d.length() < 0.1) {
                v3d.normalize();
                v3d.scale(0.1);
                this.camX = v3d.getX() + this.fixX;
                this.camY = v3d.getY() + this.fixY;
                this.camZ = v3d.getZ() + this.fixZ;
            }
        }
    }

    private void moveCameraForward(double distance) {
        double angleXY = Math.atan2(this.camY - this.fixY, this.camX - this.fixX);
        double angleZ = Math.atan2(this.camZ - this.fixZ, Math.hypot(this.camY - this.fixY, this.camX - this.fixX));
        double distXY = distance * Math.cos(angleZ);
        this.camX += distXY * Math.cos(angleXY);
        this.camY += distXY * Math.sin(angleXY);
        this.camZ += distance * Math.sin(angleZ);
        if (Math.sqrt(Math.pow(this.camX - this.fixX, 2.0) + Math.pow(this.camY - this.fixY, 2.0) + Math.pow(this.camY - this.fixY, 2.0)) < 1.0) {
            this.fixX += distXY * Math.cos(angleXY);
            this.fixY += distXY * Math.sin(angleXY);
            this.fixZ += distance * Math.sin(angleZ);
        }
    }

    public void pan(double dx, double dy) {
        double distanceFromCameraToFix = Math.sqrt(Math.pow(this.camX - this.fixX, 2.0) + Math.pow(this.camY - this.fixY, 2.0) + Math.pow(this.camZ - this.fixZ, 2.0));
        dx *= distanceFromCameraToFix / this.viewportAdapter.getPhysicalWidth() * 2.3E-4;
        dy *= distanceFromCameraToFix / this.viewportAdapter.getPhysicalHeight() * 7.0E-5;
        double theta = 1.5707963267948966 + Math.atan2(this.camZ - this.fixZ, Math.hypot(this.camX - this.fixX, this.camY - this.fixY));
        if (!this.isTracking || !this.isTrackingZ) {
            this.camZ += dy * Math.sin(theta);
            this.fixZ += dy * Math.sin(theta);
        }
        double d = dy * Math.cos(theta);
        theta = Math.atan2(this.camY - this.fixY, this.camX - this.fixX);
        if (!this.isTracking || !this.isTrackingY) {
            this.camY += d * Math.sin(theta);
            this.fixY += d * Math.sin(theta);
        }
        if (!this.isTracking || !this.isTrackingX) {
            this.camX += d * Math.cos(theta);
            this.fixX += d * Math.cos(theta);
        }
        theta = 1.5707963267948966 + Math.atan2(this.camY - this.fixY, this.camX - this.fixX);
        if (!this.isTracking || !this.isTrackingY) {
            this.camY -= dx * Math.sin(theta);
            this.fixY -= dx * Math.sin(theta);
        }
        if (!this.isTracking || !this.isTrackingX) {
            this.camX -= dx * Math.cos(theta);
            this.fixX -= dx * Math.cos(theta);
        }
    }

    public void translateFix(double dx, double dy, double dz) {
        double yTiltAngle = Math.atan2(this.camY - this.fixY, this.camX - this.fixX);
        if (!this.isTracking || !this.isTrackingZ) {
            this.camZ += dz;
            this.fixZ += dz;
        }
        if (!this.isTracking || !this.isTrackingY) {
            this.camY += dy * Math.sin(yTiltAngle);
            this.fixY += dy * Math.sin(yTiltAngle);
        }
        if (!this.isTracking || !this.isTrackingX) {
            this.camX += dy * Math.cos(yTiltAngle);
            this.fixX += dy * Math.cos(yTiltAngle);
        }
        double xTiltAngle = yTiltAngle + 1.5707963267948966;
        if (!this.isTracking || !this.isTrackingY) {
            this.camY -= dx * Math.sin(xTiltAngle);
            this.fixY -= dx * Math.sin(xTiltAngle);
        }
        if (!this.isTracking || !this.isTrackingX) {
            this.camX -= dx * Math.cos(xTiltAngle);
            this.fixX -= dx * Math.cos(xTiltAngle);
        }
    }

    private void initTransition() {
        this.camXSpeed = -(this.camX - this.storedCameraPositions.get(this.storedPositionIndex).getX()) / transitionTime;
        this.camYSpeed = -(this.camY - this.storedCameraPositions.get(this.storedPositionIndex).getY()) / transitionTime;
        this.camZSpeed = -(this.camZ - this.storedCameraPositions.get(this.storedPositionIndex).getZ()) / transitionTime;
        this.fixXSpeed = -(this.fixX - this.storedFixPositions.get(this.storedPositionIndex).getX()) / transitionTime;
        this.fixYSpeed = -(this.fixY - this.storedFixPositions.get(this.storedPositionIndex).getY()) / transitionTime;
        this.fixZSpeed = -(this.fixZ - this.storedFixPositions.get(this.storedPositionIndex).getZ()) / transitionTime;
        this.transitioning = true;
        this.lastTransitionTime = System.currentTimeMillis();
    }

    @Override
    public void toggleCameraKeyMode() {
        this.setUseCameraKeyPoints(!this.useKeyCameraPoints());
    }

    public boolean getCameraKeyMode() {
        return this.toggleCameraKeyPoints;
    }

    @Override
    public void setUseCameraKeyPoints(boolean use) {
        this.toggleCameraKeyPoints = use;
    }

    @Override
    public boolean useKeyCameraPoints() {
        return this.toggleCameraKeyPoints;
    }

    @Override
    public boolean setCameraKeyPoint(int time) {
        boolean added = false;
        for (int i = 0; i < this.cameraKeyPoints.size(); ++i) {
            if (this.cameraKeyPoints.get(i) == time) {
                this.addKeyFrame(this.removeKeyFrameByTime(time), time);
                return false;
            }
            if (this.cameraKeyPoints.get(i) <= time) continue;
            this.cameraKeyPoints.add(time);
            this.addKeyFrame(1, time);
            return true;
        }
        if (!added) {
            this.cameraKeyPoints.add(time);
            this.addKeyFrame(time);
        }
        return true;
    }

    @Override
    public void nextCameraKeyPoint(int time) {
        ++this.cameraKeyPointIndex;
        if (this.cameraKeyPointIndex >= this.cameraKeyPoints.size()) {
            this.cameraKeyPointIndex = 0;
        }
        this.toggleCameraKeyPoints = false;
        this.gotoKey(this.cameraKeyPointIndex);
    }

    @Override
    public void previousCameraKeyPoint(int time) {
        --this.cameraKeyPointIndex;
        if (this.cameraKeyPointIndex < 0) {
            this.cameraKeyPointIndex = this.cameraKeyPoints.size() - 1;
        }
        this.toggleCameraKeyPoints = false;
        this.gotoKey(this.cameraKeyPointIndex);
    }

    @Override
    public void removeCameraKeyPoint(int time) {
        this.cameraKeyPoints.remove(this.cameraKeyPointIndex);
        this.removeKeyFrameByIndex(this.cameraKeyPointIndex);
    }

    @Override
    public double getTrackXVar() {
        return this.cameraTrackAndDollyVariablesHolder.getTrackingX();
    }

    @Override
    public double getTrackYVar() {
        return this.cameraTrackAndDollyVariablesHolder.getTrackingY();
    }

    @Override
    public double getTrackZVar() {
        return this.cameraTrackAndDollyVariablesHolder.getTrackingZ();
    }

    @Override
    public double getDollyXVar() {
        return this.cameraTrackAndDollyVariablesHolder.getDollyX();
    }

    @Override
    public double getDollyYVar() {
        return this.cameraTrackAndDollyVariablesHolder.getDollyY();
    }

    @Override
    public double getDollyZVar() {
        return this.cameraTrackAndDollyVariablesHolder.getDollyZ();
    }

    public void nextStoredPosition() {
        if (this.storedCameraPositions.size() > 0) {
            ++this.storedPositionIndex;
            if (this.storedPositionIndex >= this.storedCameraPositions.size()) {
                this.storedPositionIndex = 0;
            }
            this.initTransition();
        }
    }

    public void previousStoredPosition() {
        if (this.storedCameraPositions.size() > 0) {
            --this.storedPositionIndex;
            if (this.storedPositionIndex < 0) {
                this.storedPositionIndex = this.storedCameraPositions.size() - 1;
            }
            this.initTransition();
        }
    }

    public void storePosition() {
        this.storedCameraPositions.add(new Point3D(this.getCamX(), this.getCamY(), this.getCamZ()));
        this.storedFixPositions.add(new Point3D(this.getFixX(), this.getFixY(), this.getFixZ()));
    }

    @Override
    public void reset() {
    }

    @Override
    public void computeTransform(RigidBodyTransform currXform) {
        this.update();
        CameraMountInterface cameraMount = this.getCameraMount();
        if (this.isMounted() && cameraMount != null) {
            cameraMount.getTransformToCamera(currXform);
            return;
        }
        this.positionOffset.set(this.getCamX(), this.getCamY(), this.getCamZ());
        this.xAxis.set(this.getFixX(), this.getFixY(), this.getFixZ());
        this.fixPointNode.translateTo(this.getFixX(), this.getFixY(), this.getFixZ());
        this.xAxis.sub((Tuple3DReadOnly)this.positionOffset);
        this.xAxis.normalize();
        this.zAxis.set(0.0, 0.0, 1.0);
        this.yAxis.cross((Tuple3DReadOnly)this.zAxis, (Tuple3DReadOnly)this.xAxis);
        this.yAxis.normalize();
        this.zAxis.cross((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis);
        this.rotationMatrix.setColumns((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
        currXform.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.rotationMatrix);
        currXform.getTranslation().set((Tuple3DReadOnly)this.positionOffset);
        currXform.getRotation().normalize();
    }

    private boolean shouldAcceptDeviceInput() {
        if (this.alreadyClosing || this.graphics3dAdapter.getContextManager().getCurrentViewport() != this.viewportAdapter) {
            return false;
        }
        return this.jFrame == null || this.jFrame.isActive();
    }

    public void keyPressed(Key key) {
        if (this.shouldAcceptDeviceInput()) {
            switch (key) {
                case W: {
                    this.forward = true;
                    break;
                }
                case S: {
                    this.backward = true;
                    break;
                }
                case A: {
                    this.left = true;
                    break;
                }
                case D: {
                    this.right = true;
                    break;
                }
                case Q: {
                    this.up = true;
                    break;
                }
                case Z: {
                    this.down = true;
                    break;
                }
            }
        }
    }

    public void keyReleased(Key key) {
        if (this.shouldAcceptDeviceInput()) {
            switch (key) {
                case W: {
                    this.forward = false;
                    break;
                }
                case S: {
                    this.backward = false;
                    break;
                }
                case A: {
                    this.left = false;
                    break;
                }
                case D: {
                    this.right = false;
                    break;
                }
                case Q: {
                    this.up = false;
                    break;
                }
                case Z: {
                    this.down = false;
                    break;
                }
                case RIGHT: {
                    this.nextStoredPosition();
                    break;
                }
                case LEFT: {
                    this.previousStoredPosition();
                    break;
                }
                case K: {
                    this.storePosition();
                    break;
                }
            }
        }
    }

    public void selected(Graphics3DNode graphics3dNode, ModifierKeyInterface modifierKeyInterface, Point3DReadOnly location, Point3DReadOnly cameraLocation, QuaternionReadOnly cameraRotation) {
        if (this.shouldAcceptDeviceInput() && modifierKeyInterface.isKeyPressed(Key.SHIFT)) {
            if (!this.isTracking() || !this.isTrackingX()) {
                this.setFixX(location.getX());
            }
            if (!this.isTracking() || !this.isTrackingY()) {
                this.setFixY(location.getY());
            }
            if (!this.isTracking() || !this.isTrackingZ()) {
                this.setFixZ(location.getZ());
            }
        }
    }

    public void mouseDragged(MouseButton mouseButton, double dx, double dy) {
        if (this.shouldAcceptDeviceInput()) {
            switch (mouseButton) {
                case LEFT: {
                    this.doMouseDraggedLeft(dx, dy);
                    break;
                }
                case RIGHT: {
                    this.doMouseDraggedRight(dx, dy);
                    break;
                }
                case MIDDLE: {
                    this.doMouseDraggedMiddle(dx, dy);
                    break;
                }
                case LEFTRIGHT: {
                    this.pan(dx, dy);
                }
            }
        }
    }

    public void mouseDragged(double dx, double dy, double dz, double drx, double dry, double drz) {
        if (this.shouldAcceptDeviceInput()) {
            this.rotateAroundFix(-drz * this.rotateGain, -drx * this.rotateGain);
            this.translateFix(-dx * this.translateGain, -dy * this.translateGain, dz * this.translateGain);
        }
    }

    @Override
    public double getClipNear() {
        if (this.isMounted) {
            return this.cameraMount.getClipDistanceNear();
        }
        return this.clipDistanceNear;
    }

    @Override
    public double getClipFar() {
        if (this.isMounted) {
            return this.cameraMount.getClipDistanceFar();
        }
        return this.clipDistanceFar;
    }

    @Override
    public double getHorizontalFieldOfViewInRadians() {
        if (this.isMounted) {
            return this.cameraMount.getFieldOfView();
        }
        return this.fieldOfView;
    }

    @Override
    public void setClipDistanceNear(double near) {
        this.clipDistanceNear = near;
    }

    @Override
    public void setClipDistanceFar(double far) {
        this.clipDistanceFar = far;
    }

    @Override
    public void copyPositionTrackingDollyConfiguration(TrackingDollyCameraController otherCamera) {
        this.setTracking(otherCamera.isTracking(), otherCamera.isTrackingX(), otherCamera.isTrackingY(), otherCamera.isTrackingZ());
        this.setDolly(otherCamera.isDolly(), otherCamera.isDollyX(), otherCamera.isDollyY(), otherCamera.isDollyZ());
        this.setCameraPosition(otherCamera.getCamX(), otherCamera.getCamY(), otherCamera.getCamZ());
        this.setFixPosition(otherCamera.getFixX(), otherCamera.getFixY(), otherCamera.getFixZ());
        this.setDollyOffsets(otherCamera.getDollyXOffset(), otherCamera.getDollyYOffset(), otherCamera.getDollyZOffset());
        this.setTrackingOffsets(otherCamera.getTrackingXOffset(), otherCamera.getTrackingYOffset(), otherCamera.getTrackingZOffset());
        if (otherCamera instanceof ClassicCameraController) {
            ClassicCameraController classicOtherCamera = (ClassicCameraController)otherCamera;
            this.keyFrameCamPos = classicOtherCamera.keyFrameCamPos;
            this.keyFrameFixPos = classicOtherCamera.keyFrameFixPos;
            this.keyFrameTimes = classicOtherCamera.keyFrameTimes;
            this.toggleCameraKeyPoints = classicOtherCamera.toggleCameraKeyPoints;
            this.cameraKeyPointIndex = classicOtherCamera.cameraKeyPointIndex;
            this.cameraKeyPoints = classicOtherCamera.cameraKeyPoints;
            System.out.println("Copying camera keys");
        }
    }

    @Override
    public void closeAndDispose() {
        if (this.alreadyClosing) {
            return;
        }
        this.alreadyClosing = true;
        this.cameraMount = null;
        this.viewportAdapter = null;
        if (this.cameraTrackAndDollyVariablesHolder != null) {
            this.cameraTrackAndDollyVariablesHolder.closeAndDispose();
            this.cameraTrackAndDollyVariablesHolder = null;
        }
        this.graphics3dAdapter = null;
    }

    public Graphics3DNode getFixPointNode() {
        return this.fixPointNode;
    }
}

