/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.util.concurrent.LinkedBlockingQueue;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.GPULidar;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DFrameListener;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.Graphics3DLidarScan;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestListener;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestParameters;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestScan;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.RayTracingLidar;

public class JMEGPULidarTestEnviroment
implements Graphics3DFrameListener {
    private LidarTestParameters params;
    private Graphics3DWorld world;
    private Graphics3DNode lidarNode;
    private Graphics3DNode sphereNode;
    private Graphics3DNode wallNode;
    private Node jmeSphereNode;
    private Graphics3DLidarScan gpuLidarVisualization;
    private Graphics3DLidarScan traceLidarVisualization;
    private GPULidar gpuLidar;
    private RayTracingLidar rayTracingLidar;
    private LinkedBlockingQueue<LidarTestScan> gpuLidarScanBuffer = new LinkedBlockingQueue();
    private LidarTestListener testListener;
    private LidarTestScan gpuScan;
    private LidarTestScan traceScan;

    public void testAutomatically(LidarTestParameters params, LidarTestListener testListener) {
        this.params = params;
        this.testListener = testListener;
        this.createWorld();
        this.testWithoutGui();
        this.startGpuLidar();
    }

    public void testManually(LidarTestParameters params, LidarTestListener testListener) {
        this.params = params;
        this.testListener = testListener;
        this.createWorld();
        this.testWithGui();
        this.startGpuLidar();
    }

    private void createWorld() {
        this.world = new Graphics3DWorld("LidarTest", (Graphics3DAdapter)new JMEGraphics3DAdapter());
        this.sphereNode = new Graphics3DNode("sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D(5.0), YoAppearance.Glass()));
        this.wallNode = new Graphics3DNode("wall", new Graphics3DObject());
        this.wallNode.getGraphics3DObject().addCube(0.01, 10.0, 10.0, YoAppearance.Glass());
        this.wallNode.rotate(0.39269908169872414, Axis3D.Z);
        this.wallNode.translate(5.0, 0.0, -5.0);
        Geometry geometry = new Geometry("jmeSphereGeo", (Mesh)new Sphere(200, 200, 5.0f, false, true));
        Material material = new Material(((JMEGraphics3DAdapter)this.world.getGraphics3DAdapter()).getRenderer().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        material.setColor("Color", new ColorRGBA(0.0f, 1.0f, 0.0f, 0.5f));
        material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geometry.setMaterial(material);
        geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.jmeSphereNode = new Node("jmeSphereNode");
        this.jmeSphereNode.move(1.5f, 2.5f, -0.5f);
        this.jmeSphereNode.attachChild((Spatial)geometry);
        ((JMEGraphics3DAdapter)this.world.getGraphics3DAdapter()).getRenderer().getZUpNode().attachChild((Spatial)this.jmeSphereNode);
        this.lidarNode = new Graphics3DNode("lidar", new Graphics3DObject());
        this.lidarNode.getGraphics3DObject().addModelFile("models/hokuyo.dae", YoAppearance.Black());
        this.gpuLidarVisualization = new Graphics3DLidarScan(this.world, "gpuLidar", this.params, YoAppearance.Red());
        this.traceLidarVisualization = new Graphics3DLidarScan(this.world, "traceLidar", this.params, YoAppearance.Blue());
        this.rayTracingLidar = new RayTracingLidar(this.world, this.params, 0);
        this.rayTracingLidar.addCollisionNodes(this.jmeSphereNode.getName());
        this.rayTracingLidar.addCollisionNodes(this.wallNode.getName());
        this.world.addChild(this.lidarNode);
        this.world.addChild(this.wallNode);
    }

    private void testWithGui() {
        this.world.startWithGui(10.0, -20.0, 20.0, 1800, 1080);
        this.world.addFrameListener((Graphics3DFrameListener)this);
        this.world.fixCameraOnNode(this.sphereNode);
    }

    private void testWithoutGui() {
        this.world.startWithoutGui();
        this.world.addFrameListener((Graphics3DFrameListener)this);
    }

    private void startGpuLidar() {
        this.gpuLidar = this.world.getGraphics3DAdapter().createGPULidar(this.params.getScansPerSweep(), this.params.getScanHeight(), this.params.getFieldOfView(), this.params.getMinRange(), this.params.getMaxRange());
        this.gpuLidar.addGPULidarListener((scan, currentTransform, time) -> this.gpuLidarScanBuffer.add(new LidarTestScan(this.params, currentTransform, currentTransform, scan, 0)));
        this.gpuLidar.setTransformFromWorld(this.lidarNode.getTransform(), 0.0);
    }

    public void postFrame(double timePerFrame) {
        if (this.gpuLidarScanBuffer == null) {
            return;
        }
        while (!this.gpuLidarScanBuffer.isEmpty()) {
            this.gpuScan = this.gpuLidarScanBuffer.poll();
            this.gpuLidarVisualization.update(this.gpuScan);
            this.traceScan = this.rayTracingLidar.scan(this.gpuScan.getStartTransform());
            this.traceLidarVisualization.update(this.traceScan);
        }
        this.params.rotate(timePerFrame);
        if (this.params.testIsOver()) {
            this.testListener.stop();
        }
        this.lidarNode.rotate(this.params.getRotationSpeed() * timePerFrame, Axis3D.X);
        this.gpuLidar.setTransformFromWorld(this.lidarNode.getTransform(), 0.0);
        if (this.gpuScan != null && this.traceScan != null && this.testListener != null) {
            this.testListener.notify(this.gpuScan, this.traceScan);
        }
    }

    public Graphics3DWorld getWorld() {
        return this.world;
    }
}

