/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import us.ihmc.euclid.Axis3D;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphicsObject;

public class JMEChangeMeshTester
extends SimpleApplication {
    Graphics3DAddMeshDataInstruction instruction;
    private Node node;
    int counter = 0;

    public void simpleInitApp() {
        Graphics3DObject graphics = new Graphics3DObject();
        graphics.setChangeable(true);
        graphics.rotate(1.5707963267948966, Axis3D.Z);
        int resolution = 24;
        this.instruction = new Graphics3DAddMeshDataInstruction(MeshDataGenerator.Ellipsoid((double)1.0, (double)1.0, (double)1.0, (int)resolution, (int)resolution), YoAppearance.Red());
        JMEGraphicsObject graphicsObject = new JMEGraphicsObject((Application)this, this.assetManager, graphics);
        this.node = graphicsObject.getNode();
        this.rootNode.attachChild((Spatial)this.node);
        this.flyCam.setDragToRotate(true);
        this.setupLighting();
    }

    private DirectionalLight setupDirectionalLight(Vector3f direction) {
        DirectionalLight d2 = new DirectionalLight();
        d2.setColor(ColorRGBA.White.mult(0.6f));
        Vector3f lightDirection2 = direction.normalizeLocal();
        d2.setDirection(lightDirection2);
        return d2;
    }

    private void setupLighting() {
        DirectionalLight primaryLight = this.setupDirectionalLight(new Vector3f(-0.5f, -8.0f, -2.0f));
        this.rootNode.addLight((Light)primaryLight);
        DirectionalLight d2 = this.setupDirectionalLight(new Vector3f(1.0f, -1.0f, 1.0f));
        this.rootNode.addLight((Light)d2);
        DirectionalLight d3 = this.setupDirectionalLight(new Vector3f(1.0f, -1.0f, -1.0f));
        this.rootNode.addLight((Light)d3);
        DirectionalLight d4 = this.setupDirectionalLight(new Vector3f(-1.0f, -1.0f, 1.0f));
        this.rootNode.addLight((Light)d4);
        AmbientLight a1 = new AmbientLight();
        a1.setColor(ColorRGBA.White.mult(0.4f));
        this.rootNode.addLight((Light)a1);
    }

    public void simpleUpdate(float tpf) {
        if (this.counter % 1000 == 0) {
            this.instruction.setMesh(MeshDataGenerator.Cube((double)1.0, (double)1.0, (double)1.0, (boolean)false, null));
            this.instruction.setAppearance(YoAppearance.Yellow());
        } else if (this.counter % 500 == 0) {
            this.instruction.setMesh(MeshDataGenerator.Sphere((double)1.0, (int)15, (int)15));
            this.instruction.setAppearance(YoAppearance.Green());
        }
        ++this.counter;
    }

    public static void main(String[] args) {
        JMEChangeMeshTester jmeChangeMeshTester = new JMEChangeMeshTester();
        AppSettings appSettings = new AppSettings(true);
        appSettings.setResolution(800, 600);
        jmeChangeMeshTester.setSettings(appSettings);
        jmeChangeMeshTester.setShowSettings(false);
        jmeChangeMeshTester.setPauseOnLostFocus(false);
        jmeChangeMeshTester.start();
    }
}

