/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.asset.AssetManager;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.awt.AwtPanelsContext;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEAppearanceMaterial;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JME3DLoaderUtils;
import us.ihmc.jMonkeyEngineToolkit.utils.GraphicsDemoTools;

public class JMEBufferedImageAppearanceTester
extends JMERenderer {
    int counter = 0;
    Geometry footIconGeometryLeft;
    public int index = 0;

    public JMEBufferedImageAppearanceTester() {
        super(JMERenderer.RenderType.AWTPANELS);
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.footIconGeometryLeft = JME3DLoaderUtils.extractFirstGeometry((String)((Object)((Object)this)).getClass().getResource("Models/LeftFootPathIcon.obj").getFile(), (AssetManager)this.assetManager, (Graphics3DNodeType)Graphics3DNodeType.VISUALIZATION);
        Node rotation = new Node();
        rotation.rotate(1.5707964f, 0.0f, 0.0f);
        rotation.attachChild((Spatial)this.footIconGeometryLeft);
        this.getZUpNode().attachChild((Spatial)rotation);
    }

    public void simpleUpdate(float tpf) {
        super.simpleUpdate(tpf);
        if (this.counter % 100 == 0) {
            double footWidth = 0.1;
            double footHeight = 0.25;
            double footEdgeStart = 0.007;
            double footEdgeEnd = 0.055;
            int width = 100;
            int height = (int)(footWidth / footHeight * 100.0);
            BufferedImage appearance = new BufferedImage(width, height, 6);
            Graphics2D g = (Graphics2D)appearance.getGraphics();
            g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.4f));
            g.fillRect(0, 0, width, height);
            g.setColor(Color.black);
            Font font = new Font("Arial", 0, 18);
            FontMetrics metrics = g.getFontMetrics(font);
            String text = String.valueOf(this.index);
            Rectangle2D bounds = metrics.getStringBounds(text, g);
            int xStart = (int)((double)height * (footEdgeStart / footWidth));
            int xEnd = (int)((double)height * (footEdgeEnd / footWidth));
            int y = (xEnd - xStart - (int)bounds.getWidth()) / 2 + xStart;
            int x = (width - (int)bounds.getHeight()) / 2;
            g.translate(x, y);
            g.rotate(1.5707963267948966);
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString(text, 0, 0);
            g.dispose();
            this.footIconGeometryLeft.setMaterial(JMEAppearanceMaterial.createMaterialFromBufferedImage((AssetManager)this.assetManager, (BufferedImage)appearance));
            this.footIconGeometryLeft.setQueueBucket(RenderQueue.Bucket.Opaque);
            ++this.index;
        }
        ++this.counter;
    }

    public static void main(String[] args) {
        JMEBufferedImageAppearanceTester jmeChangeAppearanceTester = new JMEBufferedImageAppearanceTester();
        AppSettings appSettings = new AppSettings(true);
        appSettings.setCustomRenderer(AwtPanelsContext.class);
        appSettings.setResolution(800, 600);
        jmeChangeAppearanceTester.setSettings(appSettings);
        jmeChangeAppearanceTester.setShowSettings(false);
        jmeChangeAppearanceTester.setPauseOnLostFocus(false);
        GraphicsDemoTools.PanBackAndForthTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder = new GraphicsDemoTools.PanBackAndForthTrackingAndDollyPositionHolder(0.0, 2.0, 0.2);
        ViewportAdapter viewportAdapter = jmeChangeAppearanceTester.createNewViewport(null, false, false);
        ClassicCameraController classicCameraController = ClassicCameraController.createClassicCameraControllerAndAddListeners((ViewportAdapter)viewportAdapter, (CameraTrackingAndDollyPositionHolder)cameraTrackAndDollyVariablesHolder, (Graphics3DAdapter)jmeChangeAppearanceTester);
        viewportAdapter.setCameraController((CameraController)classicCameraController);
        Canvas canvas = viewportAdapter.getCanvas();
        JMEBufferedImageAppearanceTester.createNewWindow(canvas);
    }

    private static void createNewWindow(Canvas canvas) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        JFrame jFrame = new JFrame("Example One");
        jFrame.setDefaultCloseOperation(3);
        Container contentPane = jFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", panel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setSize(800, 600);
    }
}

