/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.util;

import com.jme3.app.SimpleApplication;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMELidarSpriteGenerator;
import us.ihmc.robotics.Assert;

@Tag(value="jme")
public class JMELidarSpriteGeneratorTest {
    private JMELidarSpriteGenerator createUI(float[][] data) {
        JMERenderer ui = new JMERenderer(JMERenderer.RenderType.CANVAS);
        JMELidarSpriteGenerator result = new JMELidarSpriteGenerator((SimpleApplication)ui);
        ui.getZUpNode().attachChild((Spatial)result);
        Point3D32[] points = new Point3D32[data.length];
        for (int i = 0; i < data.length; ++i) {
            points[i] = new Point3D32(data[i][0], data[i][1], data[i][2]);
        }
        result.updatePoints((Point3DReadOnly[])points);
        return result;
    }

    @Disabled
    @Test
    public void testCollideWithSimple() {
        JMELidarSpriteGenerator generator = this.createUI(new float[][]{{0.0f, 0.0f, 0.0f}});
        Ray ray = new Ray();
        ray.origin = new Vector3f(1.0f, 1.0f, 1.0f);
        ray.direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        CollisionResults results = new CollisionResults();
        if (generator.collideWith((Collidable)ray, results) == 0) {
            Assert.fail("Collide with failed");
        }
        Assert.assertEquals(results.size(), 1L);
        Assert.assertTrue((double)results.getCollision(0).getContactPoint().distance(new Vector3f(0.0f, 0.0f, 0.0f)) < 1.0E-6);
        Assert.assertEquals((double)results.getCollision(0).getDistance(), (double)ray.origin.length(), 1.0E-6);
    }

    @Test
    public void testEmptyCollide() {
        JMELidarSpriteGenerator generator = this.createUI(new float[0][]);
        Ray ray = new Ray();
        CollisionResults results = new CollisionResults();
        Assert.assertEquals(generator.collideWith((Collidable)ray, results), 0L);
    }

    @Disabled
    @Test
    public void testMultiplePointsOneLine() {
        JMELidarSpriteGenerator generator = this.createUI(new float[][]{{0.0f, 0.0f, 0.0f}, {-1.0f, -1.0f, -1.0f}, {0.5f, 0.5f, 0.5f}, {-0.5f, -0.5f, -0.5f}});
        Ray ray = new Ray();
        ray.setOrigin(new Vector3f(1.0f, 1.0f, 1.0f));
        ray.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f));
        CollisionResults results = new CollisionResults();
        if (generator.collideWith((Collidable)ray, results) == 0) {
            Assert.fail("Collide with failed");
        }
        Assert.assertEquals(1L, results.size());
        Assert.assertTrue((double)results.getCollision(0).getContactPoint().distance(new Vector3f(0.5f, 0.5f, 0.5f)) < 1.0E-6);
    }

    @Test
    public void testMultiplePointsNoMatch() {
        JMELidarSpriteGenerator generator = this.createUI(new float[][]{{10.0f, 10.0f, 100.0f}, {-100.0f, -10.0f, -10.0f}, {0.5f, 5.5f, 0.5f}, {-0.5f, -0.5f, -50.5f}});
        Ray ray = new Ray();
        ray.origin = new Vector3f(1.0f, 1.0f, 1.0f);
        ray.direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        ThreadTools.sleep((long)500L);
        CollisionResults results = new CollisionResults();
        Assert.assertEquals(generator.collideWith((Collidable)ray, results), 0L);
    }
}

