/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.util;

import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;
import us.ihmc.robotics.Assert;

public class JMEGeometryUtilsTest {
    @Test
    public void testGetInverse() {
        Random random = new Random(100L);
        for (int i = 0; i < 100; ++i) {
            RigidBodyTransform transform3D = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Transform transform = JMEGeometryUtils.transformFromZupToJMECoordinates((RigidBodyTransform)transform3D);
            Transform transformInverse = JMEGeometryUtils.getInverse((Transform)transform);
            transform = transform.combineWithParent(transformInverse);
            Assert.assertTrue(JMEGeometryUtils.epsilonEquals((Transform)Transform.IDENTITY, (Transform)transform, (double)1.0E-6));
        }
    }

    @Test
    public void testTransformFromJMECoordinatesToZup() {
        Transform transform3D = new Transform();
        transform3D.set(Transform.IDENTITY);
        transform3D.setTranslation(new Vector3f(1.0f, 0.0f, 0.0f));
        RigidBodyTransform transform = JMEGeometryUtils.transformFromJMECoordinatesToZup((Transform)transform3D);
        Vector3D originalVector = new Vector3D(1.0, 0.0, 0.0);
        Vector3D originalVectorTransformedToZup = new Vector3D();
        transform.transform((Vector3DReadOnly)originalVector, (Vector3DBasics)originalVectorTransformedToZup);
        Vector3D expectedAnswer = new Vector3D(0.0, 1.0, 0.0);
        Assert.assertTrue(expectedAnswer.epsilonEquals((EuclidGeometry)originalVectorTransformedToZup, 1.0E-6));
        originalVector = new Vector3D(0.0, 1.0, 0.0);
        originalVectorTransformedToZup = new Vector3D();
        transform.transform((Vector3DReadOnly)originalVector, (Vector3DBasics)originalVectorTransformedToZup);
        expectedAnswer = new Vector3D(0.0, 0.0, 1.0);
        Assert.assertTrue(expectedAnswer.epsilonEquals((EuclidGeometry)originalVectorTransformedToZup, 1.0E-6));
        originalVector = new Vector3D(0.0, 0.0, 1.0);
        originalVectorTransformedToZup = new Vector3D();
        transform.transform((Vector3DReadOnly)originalVector, (Vector3DBasics)originalVectorTransformedToZup);
        expectedAnswer = new Vector3D(1.0, 0.0, 0.0);
        Assert.assertTrue(expectedAnswer.epsilonEquals((EuclidGeometry)originalVectorTransformedToZup, 1.0E-6));
    }

    @Test
    public void testTransformFromJMECoordinatesToZupWithItsInverse() {
        Random random = new Random(100L);
        for (int i = 0; i < 100; ++i) {
            RigidBodyTransform transform3Doriginal = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Transform transform3d = JMEGeometryUtils.transformFromZupToJMECoordinates((RigidBodyTransform)transform3Doriginal);
            RigidBodyTransform transform3backToOriginal = JMEGeometryUtils.transformFromJMECoordinatesToZup((Transform)transform3d);
            Assert.assertTrue(transform3backToOriginal.epsilonEquals((EuclidGeometry)transform3Doriginal, 1.0E-6));
        }
    }

    @Test
    public void testTransformFromJMECoordinatesToZupWith90RotAboutX() {
        Transform transform = new Transform();
        transform.set(Transform.IDENTITY);
        com.jme3.math.Quaternion quat = new com.jme3.math.Quaternion();
        quat.fromAngleAxis(1.5707964f, new Vector3f(1.0f, 0.0f, 0.0f));
        transform.setRotation(quat);
        RigidBodyTransform transform3D = JMEGeometryUtils.transformFromJMECoordinatesToZup((Transform)transform);
        AxisAngle axisAngleTransformed = new AxisAngle();
        Quaternion quat4d = new Quaternion();
        quat4d.set((Orientation3DReadOnly)transform3D.getRotation());
        axisAngleTransformed.set((Orientation3DReadOnly)quat4d);
        Vector3D originalVector = new Vector3D(1.0, 0.0, 0.0);
        Vector3D originalVectorTransformedToZup = new Vector3D();
        transform3D.transform((Vector3DReadOnly)originalVector, (Vector3DBasics)originalVectorTransformedToZup);
        Vector3D expectedAnswer = new Vector3D(0.0, 1.0, 0.0);
        Assert.assertTrue(expectedAnswer.epsilonEquals((EuclidGeometry)originalVectorTransformedToZup, 1.0E-6));
        originalVector = new Vector3D(0.0, 1.0, 0.0);
        originalVectorTransformedToZup = new Vector3D();
        transform3D.transform((Vector3DReadOnly)originalVector, (Vector3DBasics)originalVectorTransformedToZup);
        expectedAnswer = new Vector3D(1.0, 0.0, 0.0);
        Assert.assertTrue(expectedAnswer.epsilonEquals((EuclidGeometry)originalVectorTransformedToZup, 1.0E-6));
        originalVector = new Vector3D(0.0, 0.0, 1.0);
        originalVectorTransformedToZup = new Vector3D();
        transform3D.transform((Vector3DReadOnly)originalVector, (Vector3DBasics)originalVectorTransformedToZup);
        expectedAnswer = new Vector3D(0.0, 0.0, -1.0);
        Assert.assertTrue(expectedAnswer.epsilonEquals((EuclidGeometry)originalVectorTransformedToZup, 1.0E-6));
    }

    @Test
    public void testTransformFromZupToJMECoordinates() {
        Vector3f pointOriginal = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromZupToJMECoordinates((Vector3f)pointTransformed);
        Vector3f expectedAnswer = new Vector3f(0.0f, 0.0f, 1.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
        pointOriginal = new Vector3f(0.0f, 1.0f, 0.0f);
        pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromZupToJMECoordinates((Vector3f)pointTransformed);
        expectedAnswer = new Vector3f(1.0f, 0.0f, 0.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
        pointOriginal = new Vector3f(0.0f, 0.0f, 1.0f);
        pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromZupToJMECoordinates((Vector3f)pointTransformed);
        expectedAnswer = new Vector3f(0.0f, 1.0f, 0.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
    }

    @Test
    public void testTransformFromJMECoordinatesToZupPoint() {
        Vector3f pointOriginal = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromJMECoordinatesToZup((Vector3f)pointTransformed);
        Vector3f expectedAnswer = new Vector3f(0.0f, 1.0f, 0.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
        pointOriginal = new Vector3f(0.0f, 1.0f, 0.0f);
        pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromJMECoordinatesToZup((Vector3f)pointTransformed);
        expectedAnswer = new Vector3f(0.0f, 0.0f, 1.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
        pointOriginal = new Vector3f(0.0f, 0.0f, 1.0f);
        pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromJMECoordinatesToZup((Vector3f)pointTransformed);
        expectedAnswer = new Vector3f(1.0f, 0.0f, 0.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
    }

    @Test
    public void testTransformFromZupToJMECoordinatesQuaternion() {
        Random random = new Random(100L);
        for (int i = 0; i < 100; ++i) {
            AxisAngle axisAngle4d = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            Quaternion quat4d = new Quaternion();
            quat4d.set((Orientation3DReadOnly)axisAngle4d);
        }
    }

    @Test
    public void testRotationsFromAndToJMEToZupCoordinates() {
        com.jme3.math.Quaternion quaternion = JMEGeometryUtils.getRotationFromJMEToZupCoordinates();
        Quaternion quat4d = JMEDataTypeUtils.jMEQuaternionToVecMathQuat4d((com.jme3.math.Quaternion)quaternion);
        RotationMatrix matrix3d = new RotationMatrix();
        matrix3d.set((Orientation3DReadOnly)quat4d);
        Vector3f pointOriginal = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromZupToJMECoordinates((Vector3f)pointTransformed);
        Vector3f expectedAnswer = new Vector3f(0.0f, 0.0f, 1.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
        pointOriginal = new Vector3f(0.0f, 1.0f, 0.0f);
        pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromZupToJMECoordinates((Vector3f)pointTransformed);
        expectedAnswer = new Vector3f(1.0f, 0.0f, 0.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
        pointOriginal = new Vector3f(0.0f, 0.0f, 1.0f);
        pointTransformed = new Vector3f(pointOriginal);
        JMEGeometryUtils.transformFromZupToJMECoordinates((Vector3f)pointTransformed);
        expectedAnswer = new Vector3f(0.0f, 1.0f, 0.0f);
        Assert.assertTrue(JMEGeometryUtilsTest.areVectorsEqual(expectedAnswer, pointTransformed));
    }

    private static boolean areVectorsEqual(Vector3f vector3fa, Vector3f vector3fb) {
        if ((double)Math.abs(vector3fa.getX() - vector3fb.getX()) > 1.0E-6) {
            return false;
        }
        if ((double)Math.abs(vector3fa.getY() - vector3fb.getY()) > 1.0E-6) {
            return false;
        }
        return !((double)Math.abs(vector3fa.getZ() - vector3fb.getZ()) > 1.0E-6);
    }
}

