/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestParameters;

public class LidarTestScan {
    public LidarTestParameters params;
    public RigidBodyTransform worldTransformStart;
    public RigidBodyTransform worldTransformEnd;
    public RigidBodyTransform localTransformStart;
    public RigidBodyTransform localTransformEnd;
    public RigidBodyTransform averageTransform;
    public float[] ranges;
    public int sensorId;

    public LidarTestScan() {
    }

    public LidarTestScan(LidarTestParameters params, float[] ranges, int sensorId) {
        this.params = params;
        this.ranges = ranges;
        this.sensorId = sensorId;
    }

    public LidarTestScan(LidarTestParameters params, RigidBodyTransform start, RigidBodyTransform end, float[] ranges, int sensorId) {
        this.params = params;
        this.setWorldTransforms(start, end);
        this.ranges = ranges;
        this.sensorId = sensorId;
    }

    public LidarTestScan(LidarTestParameters params, RigidBodyTransform start, RigidBodyTransform end, float[] ranges) {
        this.params = params;
        this.setWorldTransforms(start, end);
        this.ranges = ranges;
        this.sensorId = 0;
    }

    public ArrayList<Point3D> getAllPoints() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        for (int i = 0; i < this.ranges.length; ++i) {
            points.add(this.getPoint(i, this.ranges[i]));
        }
        return points;
    }

    public ArrayList<Point3D32> getAllPoints3f() {
        ArrayList<Point3D32> points = new ArrayList<Point3D32>();
        for (int i = 0; i < this.ranges.length; ++i) {
            points.add(this.getPoint3f(i, this.ranges[i]));
        }
        return points;
    }

    public int size() {
        return this.ranges.length;
    }

    public Point3D getPoint(int index) {
        return this.getPoint(index, this.ranges[index]);
    }

    public Point3D32 getPoint3f(int index) {
        return this.getPoint3f(index, this.ranges[index]);
    }

    public LineSegment3D getLineSegment(int index) {
        return this.getLineSegment(index, this.ranges[index]);
    }

    public float getRange(int i) {
        return this.ranges[i];
    }

    public float[] getRanges() {
        return this.ranges;
    }

    public LidarTestScan getCopy() {
        return new LidarTestScan(this.getParams(), (float[])this.ranges.clone(), this.sensorId);
    }

    public int getSensorId() {
        return this.sensorId;
    }

    public LidarTestScan flipNew() {
        float[] flippedRanges = Arrays.copyOf(this.ranges, this.ranges.length);
        ArrayUtils.reverse((float[])flippedRanges);
        return new LidarTestScan(this.getParams(), this.getEndTransform(), this.getStartTransform(), flippedRanges, this.sensorId);
    }

    public LidarTestParameters getParams() {
        return this.params;
    }

    public void setWorldTransforms(RigidBodyTransform start, RigidBodyTransform end) {
        this.worldTransformStart = start;
        this.worldTransformEnd = end;
        QuaternionBasedTransform start2 = new QuaternionBasedTransform((RigidBodyTransformReadOnly)start);
        QuaternionBasedTransform end2 = new QuaternionBasedTransform((RigidBodyTransformReadOnly)end);
        QuaternionBasedTransform interpolated = new QuaternionBasedTransform();
        interpolated.interpolate(start2, end2, 0.5);
        this.averageTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)interpolated);
    }

    public LidarTestParameters getScanParameters() {
        return this.params;
    }

    public RigidBodyTransform getStartTransform() {
        return this.worldTransformStart;
    }

    public RigidBodyTransform getEndTransform() {
        return this.worldTransformEnd;
    }

    public RigidBodyTransform getAverageTransform() {
        return this.averageTransform;
    }

    public Line3D getRay(int index) {
        LineSegment3D unitSegment = this.getLineSegment(index, 1.0f);
        return new Line3D((Point3DReadOnly)unitSegment.getFirstEndpoint(), (Vector3DReadOnly)unitSegment.getDirection(true));
    }

    protected Point3D getPoint(int index, float range) {
        Point3D p = new Point3D((double)range, 0.0, 0.0);
        RigidBodyTransform transform = new RigidBodyTransform();
        this.getInterpolatedTransform(index, transform);
        transform.multiply((RigidBodyTransformReadOnly)this.getSweepTransform(index));
        transform.transform((Point3DBasics)p);
        return p;
    }

    protected Point3D32 getPoint3f(int index, float range) {
        Point3D32 p = new Point3D32(range, 0.0f, 0.0f);
        RigidBodyTransform transform = new RigidBodyTransform();
        this.getInterpolatedTransform(index, transform);
        transform.multiply((RigidBodyTransformReadOnly)this.getSweepTransform(index));
        transform.transform((Point3DBasics)p);
        return p;
    }

    protected LineSegment3D getLineSegment(int index, float range) {
        Vector3D origin = new Vector3D();
        RigidBodyTransform transform = new RigidBodyTransform();
        this.getInterpolatedTransform(index, transform);
        origin.set((Tuple3DReadOnly)transform.getTranslation());
        return new LineSegment3D((Point3DReadOnly)new Point3D((Tuple3DReadOnly)origin), (Point3DReadOnly)this.getPoint(index, range));
    }

    public void getInterpolatedTransform(int index, RigidBodyTransform target) {
        QuaternionBasedTransform start2 = new QuaternionBasedTransform((RigidBodyTransformReadOnly)this.worldTransformStart);
        QuaternionBasedTransform end2 = new QuaternionBasedTransform((RigidBodyTransformReadOnly)this.worldTransformEnd);
        QuaternionBasedTransform interpolated = new QuaternionBasedTransform();
        interpolated.interpolate(start2, end2, (double)index / (double)(this.params.getScansPerSweep() - 1));
        target.set((RigidBodyTransformReadOnly)interpolated);
    }

    public RigidBodyTransform getSweepTransform(int i) {
        if (i >= this.params.getScansPerSweep() * this.params.getScanHeight()) {
            throw new IndexOutOfBoundsException("Index " + i + " greater than or equal to pointsPerSweep " + this.params.getScansPerSweep() + " * scanHeight " + this.params.getScanHeight());
        }
        double yawPerIndex = (this.params.getLidarSweepEndAngle() - this.params.getLidarSweepStartAngle()) / (double)(this.params.getScansPerSweep() - 1);
        double pitchPerIndex = (this.params.getLidarPitchMaxAngle() - this.params.getLidarPitchMinAngle()) / (double)(this.params.getScanHeight() - 1);
        RigidBodyTransform sweepTransform = new RigidBodyTransform();
        if (this.params.getScansPerSweep() > 1) {
            sweepTransform.setRotationYawAndZeroTranslation(this.params.getLidarSweepStartAngle() + yawPerIndex * (double)(i % this.params.getScansPerSweep()));
        }
        if (this.params.getScanHeight() > 1) {
            sweepTransform.setRotationPitchAndZeroTranslation(this.params.getLidarPitchMinAngle() + pitchPerIndex * (double)(i / this.params.getScansPerSweep()));
        }
        return sweepTransform;
    }

    public boolean epsilonEquals(LidarTestScan other, double transformEpsilon, float rangesEpsilon) {
        if (!this.worldTransformStart.epsilonEquals(other.worldTransformStart, transformEpsilon)) {
            return false;
        }
        if (!this.worldTransformEnd.epsilonEquals(other.worldTransformEnd, transformEpsilon)) {
            return false;
        }
        for (int i = 0; i < this.size() && i < other.size(); ++i) {
            double value = this.getRange(i);
            double value1 = other.getRange(i);
            if (!(value > 0.0) || !(value < Double.POSITIVE_INFINITY) || !(value1 > 0.0) || !(value1 < Double.POSITIVE_INFINITY) || EuclidCoreTools.epsilonEquals((double)this.ranges[i], (double)other.ranges[i], (double)rangesEpsilon)) continue;
            return false;
        }
        return true;
    }
}

