/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.ModelKey;
import com.jme3.asset.plugins.UrlAssetInfo;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.NormalCalculator;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReaderFactory;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.Triangle;
import us.ihmc.robotics.Assert;

@Tag(value="jme")
public class NormalCalculatorTest {
    @Test
    public void testNormalsBasedOnTeapot() throws IOException {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
        world.startWithGui();
        ThreadTools.sleep((long)2L);
        AssetManager assetManager = world.getGraphics3DAdapter().getRenderer().getAssetManager();
        ModelKey modelKey = new ModelKey("teapotBinary.STL");
        UrlAssetInfo urlAssetInfo = UrlAssetInfo.create((AssetManager)assetManager, (AssetKey)modelKey, (URL)this.getClass().getClassLoader().getResource("teapotBinary.STL"));
        STLReader reader = STLReaderFactory.create((AssetInfo)urlAssetInfo);
        for (Triangle triangle : reader.getTriangles()) {
            float[] normal = triangle.getNormal();
            float[] calculatedNormal = new float[3];
            NormalCalculator.calculateNormal((float[])calculatedNormal, (List)triangle.getVertices());
            Assert.assertTrue(NormalCalculator.compareNormal((float[])normal, (float[])calculatedNormal, (float)0.01f));
        }
        ThreadTools.sleep((long)3L);
        world.stop();
    }
}

