/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.ModelKey;
import com.jme3.asset.plugins.UrlAssetInfo;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.ASCIISTLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.BinarySTLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReaderFactory;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.Triangle;
import us.ihmc.robotics.Assert;

@Tag(value="jme")
public class STLReaderTest {
    @Disabled
    @Test
    public void testASCIILoad() throws IOException {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(20L), () -> {
            JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
            world.startWithGui();
            ThreadTools.sleep((long)2L);
            AssetManager assetManager = world.getGraphics3DAdapter().getRenderer().getAssetManager();
            ModelKey modelKey = new ModelKey("testASCIISTL.STL");
            UrlAssetInfo urlAssetInfo = UrlAssetInfo.create((AssetManager)assetManager, (AssetKey)modelKey, (URL)this.getClass().getClassLoader().getResource("testASCIISTL.STL"));
            STLReader reader = STLReaderFactory.create((AssetInfo)urlAssetInfo);
            Assert.assertEquals(reader.getClass(), ASCIISTLReader.class);
            this.checkData(reader);
            ThreadTools.sleep((long)3L);
            world.stop();
        });
    }

    @Test
    public void testBinaryLoad() throws IOException {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(20L), () -> {
            JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
            world.startWithGui();
            ThreadTools.sleep((long)2L);
            AssetManager assetManager = world.getGraphics3DAdapter().getRenderer().getAssetManager();
            ModelKey modelKey = new ModelKey("testBinarySTL.STL");
            UrlAssetInfo urlAssetInfo = UrlAssetInfo.create((AssetManager)assetManager, (AssetKey)modelKey, (URL)this.getClass().getClassLoader().getResource("testBinarySTL.STL"));
            STLReader reader = STLReaderFactory.create((AssetInfo)urlAssetInfo);
            Assert.assertEquals(reader.getClass(), BinarySTLReader.class);
            this.checkData(reader);
            ThreadTools.sleep((long)3L);
            world.stop();
        });
    }

    private void checkData(STLReader reader) {
        Assert.assertEquals("TEST_CASE", reader.getName());
        List triangles = reader.getTriangles();
        Assert.assertEquals(3L, triangles.size());
        Triangle triangle = (Triangle)triangles.get(0);
        Assert.assertEquals(1000.0, (double)triangle.getNormal()[0], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getNormal()[1], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getNormal()[2], 1.0E-7);
        Assert.assertEquals(0.01, (double)triangle.getVertex(0)[0], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getVertex(0)[1], 1.0E-7);
        Assert.assertEquals(2000.0, (double)triangle.getVertex(0)[2], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getVertex(1)[0], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getVertex(1)[1], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getVertex(1)[2], 1.0E-7);
        Assert.assertEquals(2.0E-5, (double)triangle.getVertex(2)[0], 1.0E-7);
        Assert.assertEquals(9.0, (double)triangle.getVertex(2)[1], 1.0E-7);
        Assert.assertEquals(2.0, (double)triangle.getVertex(2)[2], 1.0E-7);
        triangle = (Triangle)triangles.get(1);
        Assert.assertEquals(0.0, (double)triangle.getNormal()[0], 1.0E-7);
        Assert.assertEquals(100.0, (double)triangle.getNormal()[1], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getNormal()[2], 1.0E-7);
        Assert.assertEquals(0.01, (double)triangle.getVertex(0)[0], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getVertex(0)[1], 1.0E-7);
        Assert.assertEquals(2000.0, (double)triangle.getVertex(0)[2], 1.0E-7);
        Assert.assertEquals(1.0, (double)triangle.getVertex(1)[0], 1.0E-7);
        Assert.assertEquals(2.0, (double)triangle.getVertex(1)[1], 1.0E-7);
        Assert.assertEquals(3.0, (double)triangle.getVertex(1)[2], 1.0E-7);
        Assert.assertEquals(3.0, (double)triangle.getVertex(2)[0], 1.0E-7);
        Assert.assertEquals(4.0, (double)triangle.getVertex(2)[1], 1.0E-7);
        Assert.assertEquals(5.0, (double)triangle.getVertex(2)[2], 1.0E-7);
        triangle = (Triangle)triangles.get(2);
        Assert.assertEquals(0.0, (double)triangle.getNormal()[0], 1.0E-7);
        Assert.assertEquals(1000.0, (double)triangle.getNormal()[1], 1.0E-7);
        Assert.assertEquals(2.0, (double)triangle.getNormal()[2], 1.0E-7);
        Assert.assertEquals(0.01, (double)triangle.getVertex(0)[0], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getVertex(0)[1], 1.0E-7);
        Assert.assertEquals(2000.0, (double)triangle.getVertex(0)[2], 1.0E-7);
        Assert.assertEquals(4.0, (double)triangle.getVertex(1)[0], 1.0E-7);
        Assert.assertEquals(6.0, (double)triangle.getVertex(1)[1], 1.0E-7);
        Assert.assertEquals(7.0, (double)triangle.getVertex(1)[2], 1.0E-7);
        Assert.assertEquals(0.0, (double)triangle.getVertex(2)[0], 1.0E-7);
        Assert.assertEquals(2.0, (double)triangle.getVertex(2)[1], 1.0E-7);
        Assert.assertEquals(3.0, (double)triangle.getVertex(2)[2], 1.0E-7);
    }
}

