/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.node;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.transform.Affine;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.node.JavaFXGraphicsObject;

public class JavaFXGraphics3DNode
extends Group {
    private final Graphics3DNode graphicsNode;
    private final JavaFXGraphicsObject javaFXGraphicsObject;
    private final ArrayList<JavaFXGraphics3DNode> updatables = new ArrayList();

    public JavaFXGraphics3DNode(Graphics3DNode graphicsNode) {
        this(graphicsNode, null);
    }

    public JavaFXGraphics3DNode(Graphics3DNode graphicsNode, AppearanceDefinition appearance) {
        this.graphicsNode = graphicsNode;
        this.javaFXGraphicsObject = new JavaFXGraphicsObject(graphicsNode.getGraphics3DObject(), appearance);
        this.getChildren().add((Object)this.javaFXGraphicsObject.getGroup());
    }

    public void update() {
        ObservableList transforms = this.getTransforms();
        transforms.clear();
        Affine javaFxAffineTransform = new Affine();
        AffineTransform euclidAffineTransform = this.graphicsNode.getTransform();
        JavaFXTools.convertEuclidAffineToJavaFXAffine(euclidAffineTransform, javaFxAffineTransform);
        transforms.add((Object)javaFxAffineTransform);
        for (int i = 0; i < this.updatables.size(); ++i) {
            this.updatables.get(i).update();
        }
    }

    public void addChild(JavaFXGraphics3DNode child) {
        this.getChildren().add((Object)child);
        this.updatables.add(child);
    }
}

