/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.graphics;

import jassimp.AiBuiltInWrapperProvider;
import jassimp.AiClassLoaderIOSystem;
import jassimp.AiColor;
import jassimp.AiIOSystem;
import jassimp.AiMaterial;
import jassimp.AiMatrix4f;
import jassimp.AiMesh;
import jassimp.AiMetadataEntry;
import jassimp.AiNode;
import jassimp.AiPostProcessSteps;
import jassimp.AiScene;
import jassimp.AiTextureType;
import jassimp.AiWrapperProvider;
import jassimp.IHMCJassimp;
import jassimp.Jassimp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.graphics.JavaFXMeshDataInterpreter;

public class JAssImpJavaFXTools {
    private static final AiBuiltInWrapperProvider builtinWrapperProvider = (AiBuiltInWrapperProvider)Jassimp.BUILTIN;

    public static Color aiColorToJFXColor(AiColor aiColor) {
        float alpha = aiColor.getAlpha();
        int red = (int)((double)aiColor.getRed() * 255.0);
        int blue = (int)((double)aiColor.getBlue() * 255.0);
        int green = (int)((double)aiColor.getGreen() * 255.0);
        return Color.rgb((int)red, (int)green, (int)blue, (double)alpha);
    }

    public static void convertAssimpMatrix4fToEuclidAffine(AiMatrix4f aiMatrix4f, AffineTransform affineTransform, boolean print) {
        double[] matrix = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float v = aiMatrix4f.get(i, j);
                if (print) {
                    System.out.println("Matrix value: [i,j]: [" + i + ", " + j + "]: " + v);
                }
                matrix[4 * i + j] = v;
            }
        }
        affineTransform.set(matrix);
    }

    public static MeshView[] getJavaFxMeshes(String meshFileName) throws URISyntaxException, IOException {
        return JAssImpJavaFXTools.getJavaFxMeshes(meshFileName, null);
    }

    public static MeshView[] getJavaFxMeshes(String meshFileName, ClassLoader resourceClassLoader) throws URISyntaxException, IOException {
        HashSet<AiPostProcessSteps> aiPostProcessSteps = new HashSet<AiPostProcessSteps>();
        aiPostProcessSteps.add(AiPostProcessSteps.FLIP_UVS);
        aiPostProcessSteps.add(AiPostProcessSteps.OPTIMIZE_MESHES);
        try {
            if (resourceClassLoader == null) {
                resourceClassLoader = JAssImpJavaFXTools.class.getClassLoader();
            }
            AiScene aiScene = IHMCJassimp.importFile((String)meshFileName, aiPostProcessSteps, (AiIOSystem)new AiClassLoaderIOSystem(resourceClassLoader));
            AiNode sceneRoot = (AiNode)aiScene.getSceneRoot((AiWrapperProvider)builtinWrapperProvider);
            AiMatrix4f transform = (AiMatrix4f)sceneRoot.getTransform((AiWrapperProvider)builtinWrapperProvider);
            AffineTransform affineTransform = new AffineTransform();
            JAssImpJavaFXTools.convertAssimpMatrix4fToEuclidAffine(transform, affineTransform, false);
            AiMetadataEntry up_axis = (AiMetadataEntry)sceneRoot.getMetadata().get("UP_AXIS");
            if (meshFileName.toLowerCase().endsWith(".dae") && up_axis != null && up_axis.getMetaDataType() == AiMetadataEntry.AiMetadataType.AI_AISTRING) {
                String upAxisString = (String)up_axis.getData();
                if (upAxisString.contains("UP_Z")) {
                    affineTransform.appendRollRotation(1.5707963267948966);
                }
                if (upAxisString.contains("UP_X")) {
                    affineTransform.appendPitchRotation(1.5707963267948966);
                }
            }
            List meshes = aiScene.getMeshes();
            MeshDataHolder[] meshDataHolders = new MeshDataHolder[meshes.size()];
            Material[] materials = new Material[meshes.size()];
            for (int i = 0; i < meshes.size(); ++i) {
                AiMesh aiMesh = (AiMesh)meshes.get(i);
                AiMaterial aiMaterial = null;
                int uvIndexToUse = 0;
                int materialIndex = aiMesh.getMaterialIndex();
                if (materialIndex >= 0) {
                    aiMaterial = (AiMaterial)aiScene.getMaterials().get(materialIndex);
                }
                if (aiMaterial != null) {
                    int numDiffuseTextures = aiMaterial.getNumTextures(AiTextureType.DIFFUSE);
                    AiColor diffuseColor = (AiColor)aiMaterial.getDiffuseColor((AiWrapperProvider)builtinWrapperProvider);
                    AiColor specularColor = (AiColor)aiMaterial.getSpecularColor((AiWrapperProvider)builtinWrapperProvider);
                    float shininess = aiMaterial.getShininess();
                    Image diffuseMap = null;
                    int j = 0;
                    while (j < numDiffuseTextures) {
                        String textureFile = aiMaterial.getTextureFile(AiTextureType.DIFFUSE, j);
                        String textureLocation = meshFileName.substring(0, meshFileName.lastIndexOf("/")) + "/" + textureFile;
                        URI normalize = new URI(textureLocation).normalize();
                        InputStream textureAsStream = JAssImpJavaFXTools.class.getClassLoader().getResourceAsStream(normalize.toString());
                        if (textureAsStream == null) {
                            throw new FileNotFoundException("Could not find the resource: " + normalize);
                        }
                        diffuseMap = new Image(textureAsStream);
                        uvIndexToUse = j++;
                    }
                    PhongMaterial material = new PhongMaterial(JAssImpJavaFXTools.aiColorToJFXColor(diffuseColor));
                    material.setSpecularPower((double)shininess);
                    material.setSpecularColor(JAssImpJavaFXTools.aiColorToJFXColor(specularColor));
                    material.setDiffuseMap(diffuseMap);
                    materials[i] = material;
                } else {
                    double hue = (double)i / ((double)meshDataHolders.length - 1.0) * 360.0;
                    PhongMaterial material = new PhongMaterial(Color.hsb((double)hue, (double)0.9, (double)0.9));
                    materials[i] = material;
                }
                int totalNumberOfVertices = aiMesh.getNumVertices();
                int numberOfTriangles = aiMesh.getNumFaces();
                Point3D32[] vertices = new Point3D32[totalNumberOfVertices];
                TexCoord2f[] texturePoints = new TexCoord2f[totalNumberOfVertices];
                Vector3D32[] vertexNormals = new Vector3D32[totalNumberOfVertices];
                int[] triangleIndices = new int[3 * totalNumberOfVertices];
                for (int j = 0; j < numberOfTriangles; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        int currentIndex = k + 3 * j;
                        int faceVertexIndex = aiMesh.getFaceVertex(j, k);
                        vertices[currentIndex] = new Point3D32(aiMesh.getPositionX(faceVertexIndex), aiMesh.getPositionY(faceVertexIndex), aiMesh.getPositionZ(faceVertexIndex));
                        vertexNormals[currentIndex] = new Vector3D32(aiMesh.getNormalX(faceVertexIndex), aiMesh.getNormalY(faceVertexIndex), aiMesh.getNormalZ(faceVertexIndex));
                        if (aiMaterial != null && aiMesh.getNumUVComponents(aiMaterial.getTextureUVIndex(AiTextureType.DIFFUSE, uvIndexToUse)) == 2) {
                            float texCoordU = aiMesh.getTexCoordU(faceVertexIndex, uvIndexToUse);
                            float texCoordV = aiMesh.getTexCoordV(faceVertexIndex, uvIndexToUse);
                            texturePoints[currentIndex] = new TexCoord2f(texCoordU, texCoordV);
                        } else {
                            texturePoints[currentIndex] = new TexCoord2f();
                        }
                        for (int l = 0; l < 3; ++l) {
                            triangleIndices[currentIndex + 3 * l] = currentIndex;
                        }
                    }
                }
                meshDataHolders[i] = new MeshDataHolder(vertices, texturePoints, triangleIndices, vertexNormals);
            }
            MeshView[] meshViews = new MeshView[meshDataHolders.length];
            for (int i = 0; i < meshDataHolders.length; ++i) {
                Affine javaFxAffineToPack = new Affine();
                JavaFXTools.convertEuclidAffineToJavaFXAffine(affineTransform, javaFxAffineToPack);
                MeshDataHolder meshDataHolder = meshDataHolders[i];
                MeshView meshView = new MeshView();
                meshView.setMesh((Mesh)JavaFXMeshDataInterpreter.interpretMeshData(meshDataHolder));
                meshView.setMaterial(materials[i]);
                meshView.getTransforms().add((Object)javaFxAffineToPack);
                meshViews[i] = meshView;
            }
            return meshViews;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

