/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.cameraControllers;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.scene.input.ScrollEvent;
import us.ihmc.commons.MathTools;

public class CameraZoomCalculator {
    private final DoubleProperty zoom = new SimpleDoubleProperty((Object)this, "zoom", 10.0);
    private final DoubleProperty minZoom = new SimpleDoubleProperty((Object)this, "minZoom", 0.1);
    private final DoubleProperty maxZoom = new SimpleDoubleProperty((Object)this, "maxZoom", 100.0);
    private final DoubleProperty zoomSpeedFactor = new SimpleDoubleProperty((Object)this, "zoomSpeedFactor", 0.1);
    private final BooleanProperty invertZoomDirection = new SimpleBooleanProperty((Object)this, "invertZoomDirection", false);

    public EventHandler<ScrollEvent> createScrollEventHandler() {
        return new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                double direction = Math.signum(event.getDeltaY());
                if (CameraZoomCalculator.this.invertZoomDirection.get()) {
                    direction = -direction;
                }
                CameraZoomCalculator.this.zoomInternal(direction);
            }
        };
    }

    public void zoomIn() {
        this.zoomInternal(-1.0);
    }

    public void zoomOut() {
        this.zoomInternal(1.0);
    }

    private void zoomInternal(double direction) {
        double newOffset = this.zoom.get() + direction * this.zoom.get() * this.zoomSpeedFactor.get();
        newOffset = MathTools.clamp((double)newOffset, (double)this.minZoom.get(), (double)this.maxZoom.get());
        this.zoom.set(newOffset);
    }

    public final DoubleProperty zoomProperty() {
        return this.zoom;
    }

    public final double getZoom() {
        return this.zoomProperty().get();
    }

    public final void setZoom(double zoom) {
        this.zoomProperty().set(zoom);
    }

    public final DoubleProperty minZoomProperty() {
        return this.minZoom;
    }

    public final double getMinZoom() {
        return this.minZoomProperty().get();
    }

    public final void setMinZoom(double minZoom) {
        this.minZoomProperty().set(minZoom);
    }

    public final DoubleProperty maxZoomProperty() {
        return this.maxZoom;
    }

    public final double getMaxZoom() {
        return this.maxZoomProperty().get();
    }

    public final void setMaxZoom(double maxZoom) {
        this.maxZoomProperty().set(maxZoom);
    }

    public final DoubleProperty zoomSpeedFactorProperty() {
        return this.zoomSpeedFactor;
    }

    public final double getZoomSpeedFactor() {
        return this.zoomSpeedFactorProperty().get();
    }

    public final void setZoomSpeedFactor(double zoomSpeedFactor) {
        this.zoomSpeedFactorProperty().set(zoomSpeedFactor);
    }

    public final BooleanProperty invertZoomDirectionProperty() {
        return this.invertZoomDirection;
    }

    public final boolean isInvertZoomDirection() {
        return this.invertZoomDirectionProperty().get();
    }

    public final void setInvertZoomDirection(boolean invertZoomDirection) {
        this.invertZoomDirectionProperty().set(invertZoomDirection);
    }
}

